/*
 * Decompiled with CFR 0.152.
 */
package me.jpomykala.starters.springhoc.s3;

import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.google.common.hash.Hashing;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import javax.validation.constraints.NotNull;
import me.jpomykala.starters.springhoc.s3.SpringHocS3Properties;
import me.jpomykala.starters.springhoc.s3.model.UploadRequest;
import org.springframework.web.multipart.MultipartFile;

public class UploadService {
    private final SpringHocS3Properties properties;
    private final AmazonS3 amazonS3;

    public UploadService(SpringHocS3Properties properties, AmazonS3 amazonS3) {
        this.properties = properties;
        this.amazonS3 = amazonS3;
    }

    public void upload(@NotNull UploadRequest uploadRequest) {
        byte[] requestBytes = uploadRequest.getBytes();
        String filePath = uploadRequest.getFilePath();
        ObjectMetadata metadata = uploadRequest.getMetadata();
        this.upload(requestBytes, filePath, metadata);
    }

    public void upload(@NotNull MultipartFile file) throws IOException {
        this.upload(file, "");
    }

    public void upload(@NotNull MultipartFile file, @NotNull String path) throws IOException {
        Optional<MultipartFile> multipartFile = Optional.of(file);
        String originalFilename = multipartFile.map(MultipartFile::getOriginalFilename).orElse("unknown_name");
        String contentType = multipartFile.map(MultipartFile::getContentType).orElse("");
        ObjectMetadata objectMetadata = new ObjectMetadata();
        objectMetadata.setContentType(contentType);
        byte[] bytes = file.getBytes();
        this.upload(bytes, path + "/" + originalFilename, objectMetadata);
    }

    public String upload(byte[] bytes) {
        String generatedFilePath = Hashing.sha256().toString();
        this.upload(bytes, generatedFilePath);
        return generatedFilePath;
    }

    public void upload(byte[] bytes, String fileKey) {
        this.upload(bytes, fileKey, new ObjectMetadata());
    }

    public void upload(byte[] bytes, String fileKey, ObjectMetadata metadata) {
        int length = bytes.length;
        if (length == 0) {
            throw new IllegalArgumentException("File has 0 bytes");
        }
        ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);
        metadata.setContentLength((long)length);
        String bucketName = this.properties.getBucketName();
        this.amazonS3.putObject(bucketName, fileKey, (InputStream)inputStream, metadata);
    }
}

