/*
 * Decompiled with CFR 0.152.
 */
package me.jpomykala.starters.springhoc.mail;

import com.amazonaws.services.simpleemail.model.Body;
import com.amazonaws.services.simpleemail.model.Content;
import com.amazonaws.services.simpleemail.model.Destination;
import com.amazonaws.services.simpleemail.model.Message;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class EmailRequest {
    private Destination destination;
    private Set<String> replyTo;
    private Message message;

    public Destination getDestination() {
        return this.destination;
    }

    public Set<String> getReplyTo() {
        return this.replyTo;
    }

    public Message getMessage() {
        return this.message;
    }

    protected EmailRequest(Builder builder) {
        this.destination = builder.destination;
        this.message = builder.message;
        this.replyTo = new HashSet<String>(builder.replyTo);
    }

    public static ToStep builder() {
        return new Builder();
    }

    public static class Builder
    implements ToStep,
    SubjectStep,
    BodyStep {
        private Message message = new Message();
        private Destination destination;
        private Collection<String> replyTo = new ArrayList<String>();

        Builder() {
        }

        @Override
        public SubjectStep to(String address) {
            return this.to(Collections.singletonList(address));
        }

        @Override
        public SubjectStep to(Collection<String> to) {
            ArrayList<String> toAddresses = new ArrayList<String>(to);
            this.destination = new Destination(toAddresses);
            return this;
        }

        @Override
        public Builder body(String bodyText) {
            Content content = new Content().withData(bodyText).withCharset("UTF-8");
            Body body = new Body().withHtml(content);
            this.message.setBody(body);
            return this;
        }

        @Override
        public SubjectStep replyTo(String replyTo) {
            this.replyTo.add(replyTo);
            return this;
        }

        @Override
        public SubjectStep replyTo(Collection<String> replyTo) {
            this.replyTo.addAll(replyTo);
            return this;
        }

        @Override
        public Builder subject(String subject) {
            Content content = new Content(subject);
            this.message.setSubject(content);
            return this;
        }

        public EmailRequest build() {
            return new EmailRequest(this);
        }
    }

    public static interface BodyStep {
        public Builder body(String var1);
    }

    public static interface SubjectStep {
        public SubjectStep replyTo(String var1);

        public SubjectStep replyTo(Collection<String> var1);

        public BodyStep subject(String var1);
    }

    public static interface ToStep {
        public SubjectStep to(String var1);

        public SubjectStep to(Collection<String> var1);
    }
}

