/*
 * Decompiled with CFR 0.152.
 */
package me.jpomykala.starters.springhoc.logging;

import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.validation.constraints.NotNull;
import me.jpomykala.starters.springhoc.logging.LoggingFilter;
import me.jpomykala.starters.springhoc.logging.PrincipalProvider;
import me.jpomykala.starters.springhoc.logging.RequestIdProvider;
import me.jpomykala.starters.springhoc.utils.RequestUtils;
import org.springframework.lang.NonNull;

public class LoggingFilterFactory {
    private RequestIdProvider requestIdProvider = new DefaultRequestIdProvider();
    private PrincipalProvider principalProvider = new DefaultPrincipalProvider();
    private String mdcKey = "user";
    private String logFormat = "[u:%s][rid:%s]";

    @NotNull
    public LoggingFilterFactory withCustomMdc(@NotNull String mdcKey, @NotNull String logFormat) {
        this.mdcKey = mdcKey;
        this.logFormat = logFormat;
        return this;
    }

    @NotNull
    public LoggingFilterFactory withRequestIdProvider(@NonNull RequestIdProvider requestIdProvider) {
        this.requestIdProvider = requestIdProvider;
        return this;
    }

    @NotNull
    public LoggingFilterFactory withPrincipalProvider(@NotNull PrincipalProvider principalProvider) {
        this.principalProvider = principalProvider;
        return this;
    }

    @NotNull
    public LoggingFilter createFilter() {
        LoggingFilter loggingFilter = new LoggingFilter(this.mdcKey, this.logFormat);
        loggingFilter.setPrincipalProvider(this.principalProvider);
        loggingFilter.setRequestIdProvider(this.requestIdProvider);
        return loggingFilter;
    }

    private class DefaultPrincipalProvider
    implements PrincipalProvider {
        private DefaultPrincipalProvider() {
        }

        @Override
        public String getPrincipal(HttpServletRequest request) {
            return RequestUtils.getClientIP(request);
        }
    }

    private class DefaultRequestIdProvider
    implements RequestIdProvider {
        private DefaultRequestIdProvider() {
        }

        @Override
        public String getRequestId(HttpServletRequest request) {
            return UUID.randomUUID().toString().toUpperCase().replace("-", "");
        }
    }
}

