/*
 * Decompiled with CFR 0.152.
 */
package me.jpomykala.starters.springhoc.logging;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import me.jpomykala.starters.springhoc.logging.PrincipalProvider;
import me.jpomykala.starters.springhoc.logging.RequestIdProvider;
import org.slf4j.MDC;
import org.springframework.web.filter.OncePerRequestFilter;

public class LoggingFilter
extends OncePerRequestFilter {
    private String mdcKey;
    private String mdcLogFormat;
    private PrincipalProvider principalProvider;
    private RequestIdProvider requestIdProvider;

    public LoggingFilter(String mdcKey, String mdcLogFormat) {
        this.mdcKey = mdcKey;
        this.mdcLogFormat = mdcLogFormat;
    }

    public void setPrincipalProvider(PrincipalProvider principalProvider) {
        this.principalProvider = principalProvider;
    }

    public void setRequestIdProvider(RequestIdProvider requestIdProvider) {
        this.requestIdProvider = requestIdProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        try {
            String principal = this.principalProvider.getPrincipal(request);
            String requestId = this.requestIdProvider.getRequestId(request);
            String mdcData = String.format(this.mdcLogFormat, principal, requestId);
            MDC.put((String)this.mdcKey, (String)mdcData);
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
        finally {
            MDC.clear();
        }
    }
}

