/*
 * Decompiled with CFR 0.152.
 */
package me.jpomykala.starters.springhoc.cors;

import java.util.Arrays;
import java.util.List;
import javax.servlet.Filter;
import me.jpomykala.starters.springhoc.cors.SpringHocCorsProperties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpMethod;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.cors.CorsConfigurationSource;
import org.springframework.web.cors.UrlBasedCorsConfigurationSource;
import org.springframework.web.filter.CorsFilter;

@Configuration
@EnableConfigurationProperties(value={SpringHocCorsProperties.class})
public class SpringHocCorsAutoConfiguration {
    @Autowired
    private SpringHocCorsProperties corsProperties;

    @Bean
    public FilterRegistrationBean corsConfigurationSource() {
        CorsConfiguration configuration = new CorsConfiguration();
        List<String> allowedOrigins = this.corsProperties.getAllowedOrigins();
        configuration.setAllowedOrigins(allowedOrigins);
        configuration.setAllowCredentials(Boolean.valueOf(true));
        configuration.setAllowedMethods(Arrays.asList(HttpMethod.GET.name(), HttpMethod.HEAD.name(), HttpMethod.POST.name(), HttpMethod.PATCH.name(), HttpMethod.PUT.name(), HttpMethod.OPTIONS.name(), HttpMethod.DELETE.name()));
        List<String> allowedHeaders = Arrays.asList("Origin", "Referer", "User-Agent", "X-Requested-With", "X-Forwarded-For", "Cache-Control", "Content-Type", "Accept", "Authorization", "x-ijt", "X-Token");
        configuration.setAllowedHeaders(allowedHeaders);
        UrlBasedCorsConfigurationSource source = new UrlBasedCorsConfigurationSource();
        source.registerCorsConfiguration("/**", configuration);
        FilterRegistrationBean bean = new FilterRegistrationBean((Filter)new CorsFilter((CorsConfigurationSource)source), new ServletRegistrationBean[0]);
        bean.setOrder(Integer.MIN_VALUE);
        return bean;
    }
}

