/*
 * Decompiled with CFR 0.152.
 */
package me.devnatan.inventoryframework;

import java.util.function.UnaryOperator;
import me.devnatan.inventoryframework.AnvilInputConfig;
import me.devnatan.inventoryframework.AnvilInputStateValue;
import me.devnatan.inventoryframework.ViewConfig;
import me.devnatan.inventoryframework.ViewConfigBuilder;
import me.devnatan.inventoryframework.ViewType;
import me.devnatan.inventoryframework.context.IFContext;
import me.devnatan.inventoryframework.state.BaseMutableState;
import me.devnatan.inventoryframework.state.State;
import me.devnatan.inventoryframework.state.StateValueFactory;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public final class AnvilInput
extends BaseMutableState<String>
implements ViewConfig.Modifier {
    private static final AnvilInputConfig DEFAULT_CONFIG = new AnvilInputConfig();

    AnvilInput(long id, StateValueFactory valueFactory) {
        super(id, valueFactory);
    }

    public void apply(@NotNull ViewConfigBuilder config, @NotNull IFContext context) {
        config.type(ViewType.ANVIL);
    }

    public static AnvilInputConfig defaultConfig() {
        return DEFAULT_CONFIG;
    }

    @ApiStatus.Experimental
    public static AnvilInput createAnvilInput() {
        return AnvilInput.createAnvilInput("");
    }

    @ApiStatus.Experimental
    public static AnvilInput createAnvilInput(@NotNull String initialInput) {
        return AnvilInput.createAnvilInput(initialInput, UnaryOperator.identity());
    }

    @ApiStatus.Experimental
    public static AnvilInput createAnvilInput(@NotNull UnaryOperator<String> onInputChange) {
        return AnvilInput.createAnvilInput("", onInputChange);
    }

    @ApiStatus.Experimental
    public static AnvilInput createAnvilInput(@NotNull String initialInput, @NotNull UnaryOperator<String> onInputChange) {
        return AnvilInput.createAnvilInput(AnvilInput.defaultConfig().initialInput(initialInput).onInputChange(onInputChange));
    }

    @ApiStatus.Experimental
    public static AnvilInput createAnvilInput(@NotNull AnvilInputConfig config) {
        long id = State.next();
        StateValueFactory factory = (host, state) -> new AnvilInputStateValue(id, config);
        return new AnvilInput(id, factory);
    }
}

