/*
 * Decompiled with CFR 0.152.
 */
package me.ccampo.maven.git.version.strategy;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import me.ccampo.maven.git.version.core.VersionException;
import me.ccampo.maven.git.version.core.strategy.VersionStrategy;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Configuration;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.util.IOUtil;

@Component(role=VersionStrategy.class, hint="script")
public class ScriptStrategy
implements VersionStrategy {
    @Configuration(value="./version.sh")
    private String script;
    @Requirement
    private Logger log;

    public String getVersion(MavenProject mavenProject) throws VersionException {
        String string;
        ProcessBuilder ps = new ProcessBuilder(this.script);
        ps.redirectErrorStream(true);
        BufferedReader reader = null;
        try {
            Process pr = ps.start();
            reader = new BufferedReader(new InputStreamReader(pr.getInputStream()));
            String versionString = reader.readLine();
            pr.waitFor();
            if (pr.exitValue() != 0) {
                this.log.error("Execution Exit Code: " + pr.exitValue());
                throw new VersionException("The script exit status: " + pr.exitValue());
            }
            string = versionString;
        }
        catch (IOException | InterruptedException e) {
            try {
                throw new VersionException("Failed to execute script: " + e.getMessage(), (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtil.close(reader);
                throw throwable;
            }
        }
        IOUtil.close((Reader)reader);
        return string;
    }
}

