/*
 * Decompiled with CFR 0.152.
 */
package me.ccampo.maven.git.version.strategy;

import com.github.zafarkhaja.semver.Version;
import fr.brouillard.oss.jgitver.GitVersionCalculator;
import fr.brouillard.oss.jgitver.metadata.Metadatas;
import java.io.File;
import java.util.Optional;
import java.util.Properties;
import me.ccampo.maven.git.version.core.VersionException;
import me.ccampo.maven.git.version.core.strategy.VersionStrategy;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Configuration;

@Component(role=VersionStrategy.class, hint="git")
public class GitVersionStrategy
implements VersionStrategy {
    public static final String DEFAULT_NON_QUALIFIED_BRANCH = "master";
    public static final String DEFAULT_PRE_RELEASE_STAGE = "dev";
    public static final String DEFAULT_DIRTY_QUALIFIER = "uncommitted";
    public static final String PROPERTY_PREFIX = "project.";
    public static final String NORMAL_VERSION_PROPERTY = "project.normalVersion";
    public static final String PRE_RELEASE_VERSION_PROPERTY = "project.preReleaseVersion";
    public static final String BUILD_METADATA_PROPERTY = "project.buildMetadata";
    public static final String DOCKER_SAFE_VERSION_PROPERTY = "project.dockerSafeVersion";
    public static final String FULL_INFERRED_VERSION_PROPERTY = "project.fullInferredVersion";
    @Configuration(name="nonQualifierBranches", value="master")
    private String nonQualifierBranches;
    @Configuration(name="preReleaseStage", value="dev")
    private String preReleaseStage;
    @Configuration(name="dirtyQualifier", value="uncommitted")
    private String dirtyQualifier;
    @Configuration(name="snapshot", value="false")
    private Boolean snapshot;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getVersion(MavenProject mavenProject) throws VersionException {
        File rootDir = mavenProject.getBasedir();
        try (GitVersionCalculator calculator = GitVersionCalculator.location((File)rootDir);){
            Version semVer = this.getVersionInternal(calculator);
            this.setProjectProperties(mavenProject.getProperties(), semVer);
            String string = semVer.toString();
            return string;
        }
        catch (Exception e) {
            throw new VersionException("Cannot close GitVersionCalculator object for project: " + rootDir, (Throwable)e);
        }
    }

    protected void setProjectProperties(Properties properties, Version semVer) {
        properties.setProperty(NORMAL_VERSION_PROPERTY, semVer.getNormalVersion());
        properties.setProperty(PRE_RELEASE_VERSION_PROPERTY, semVer.getPreReleaseVersion());
        properties.setProperty(BUILD_METADATA_PROPERTY, semVer.getBuildMetadata());
        properties.setProperty(FULL_INFERRED_VERSION_PROPERTY, semVer.toString());
        properties.setProperty(DOCKER_SAFE_VERSION_PROPERTY, semVer.toString().replace('+', '-'));
    }

    protected Version getVersionInternal(GitVersionCalculator calculator) {
        this.configureGitVersionCalculator(calculator);
        fr.brouillard.oss.jgitver.Version calculatedVersion = calculator.getVersionObject();
        Version normalVersion = Version.forIntegers((int)calculatedVersion.getMajor(), (int)calculatedVersion.getMinor(), (int)calculatedVersion.getPatch());
        Version.Builder semVerBuilder = new Version.Builder().setNormalVersion(normalVersion.toString());
        int commitDistance = calculator.meta(Metadatas.COMMIT_DISTANCE).map(Integer::valueOf).orElse(0);
        StringBuilder preReleaseVersion = new StringBuilder();
        if (this.snapshot != null && this.snapshot.booleanValue() && commitDistance > 0) {
            preReleaseVersion.append("SNAPSHOT");
            semVerBuilder.setPreReleaseVersion(preReleaseVersion.toString());
            return semVerBuilder.build();
        }
        preReleaseVersion.append(this.preReleaseStage).append(".").append(commitDistance);
        boolean isDirty = calculator.meta(Metadatas.DIRTY).map(Boolean::valueOf).orElse(false);
        if (isDirty) {
            preReleaseVersion.append(".").append(this.dirtyQualifier);
        }
        if (isDirty || commitDistance > 0) {
            semVerBuilder.setPreReleaseVersion(preReleaseVersion.toString());
            calculator.meta(Metadatas.GIT_SHA1_8).ifPresent(arg_0 -> ((Version.Builder)semVerBuilder).setBuildMetadata(arg_0));
        }
        return semVerBuilder.build();
    }

    private void configureGitVersionCalculator(GitVersionCalculator calculator) {
        calculator.setUseDistance(true);
        calculator.setUseGitCommitId(true);
        calculator.setAutoIncrementPatch(true);
        calculator.setNonQualifierBranches(Optional.ofNullable(this.nonQualifierBranches).orElse(DEFAULT_NON_QUALIFIED_BRANCH));
    }

    public void setNonQualifierBranches(String nonQualifierBranches) {
        this.nonQualifierBranches = nonQualifierBranches;
    }

    public void setPreReleaseStage(String preReleaseStage) {
        this.preReleaseStage = preReleaseStage;
    }

    public void setDirtyQualifier(String dirtyQualifier) {
        this.dirtyQualifier = dirtyQualifier;
    }

    public void setSnapshot(Boolean snapshot) {
        this.snapshot = snapshot;
    }
}

