/*
 * Decompiled with CFR 0.152.
 */
package me.ccampo.maven.git.version.strategy;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import me.ccampo.maven.git.version.core.VersionException;
import me.ccampo.maven.git.version.core.strategy.VersionStrategy;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Configuration;
import org.codehaus.plexus.util.IOUtil;

@Component(role=VersionStrategy.class, hint="file")
public class FileStrategy
implements VersionStrategy {
    @Configuration(value="VERSION")
    private String versionFilePath = "VERSION";

    public String getVersion(MavenProject mavenProject) throws VersionException {
        String versionString;
        File versionFile = new File(mavenProject.getBasedir(), this.versionFilePath);
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(versionFile));
            versionString = reader.readLine();
        }
        catch (IOException e) {
            try {
                throw new VersionException("Failed to read version file: [" + versionFile.getAbsolutePath() + "]", (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtil.close(reader);
                throw throwable;
            }
        }
        IOUtil.close((Reader)reader);
        return versionString;
    }
}

