/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.simba.jdbc;

import java.time.Duration;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import me.ahoo.simba.core.AbstractMutexRetrievalService;
import me.ahoo.simba.core.ContendPeriod;
import me.ahoo.simba.core.MutexOwner;
import me.ahoo.simba.core.MutexRetriever;
import me.ahoo.simba.jdbc.MutexOwnerEntity;
import me.ahoo.simba.jdbc.MutexOwnerRepository;
import me.ahoo.simba.util.Threads;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcMutexRetrievalService
extends AbstractMutexRetrievalService {
    private static final Logger log = LoggerFactory.getLogger(JdbcMutexRetrievalService.class);
    private final MutexOwnerRepository mutexOwnerRepository;
    private final Duration initialDelay;
    private final Duration ttl;
    private ScheduledThreadPoolExecutor executorService;
    private ScheduledFuture<?> contendScheduledFuture;

    public JdbcMutexRetrievalService(MutexRetriever mutexRetriever, Executor handleExecutor, MutexOwnerRepository mutexOwnerRepository, Duration initialDelay, Duration ttl) {
        super(mutexRetriever, handleExecutor);
        this.mutexOwnerRepository = mutexOwnerRepository;
        this.initialDelay = initialDelay;
        this.ttl = ttl;
    }

    protected void startRetrieval() {
        this.executorService = new ScheduledThreadPoolExecutor(1, Threads.defaultFactory((String)"JdbcMutexRetrievalService"));
        this.nextSchedule(this.initialDelay.toMillis());
    }

    private void nextSchedule(long nextDelay) {
        if (log.isDebugEnabled()) {
            log.debug("nextSchedule - mutex:[{}] - nextDelay:[{}].", (Object)this.getMutex(), (Object)nextDelay);
        }
        this.contendScheduledFuture = this.executorService.schedule(this::safeRetrieval, nextDelay, TimeUnit.MILLISECONDS);
    }

    protected void stopRetrieval() {
        if (this.contendScheduledFuture != null) {
            this.contendScheduledFuture.cancel(true);
        }
        if (this.executorService != null) {
            this.executorService.shutdown();
        }
    }

    private void safeRetrieval() {
        try {
            MutexOwnerEntity mutexOwner = this.mutexOwnerRepository.ensureOwner(this.getMutex());
            this.notifyOwner(mutexOwner).whenComplete((nil, err) -> {
                if (err != null && log.isErrorEnabled()) {
                    log.error(err.getMessage(), err);
                }
                long nextDelay = ContendPeriod.nextContenderDelay((MutexOwner)mutexOwner);
                this.nextSchedule(nextDelay);
            });
        }
        catch (Throwable throwable) {
            if (log.isErrorEnabled()) {
                log.error(throwable.getMessage(), throwable);
            }
            this.nextSchedule(this.ttl.toMillis());
        }
    }
}

