/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.simba.jdbc;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLIntegrityConstraintViolationException;
import javax.sql.DataSource;
import me.ahoo.simba.SimbaException;
import me.ahoo.simba.jdbc.MutexOwnerEntity;
import me.ahoo.simba.jdbc.MutexOwnerRepository;
import me.ahoo.simba.jdbc.NotFoundMutexOwnerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcMutexOwnerRepository
implements MutexOwnerRepository {
    private static final Logger log = LoggerFactory.getLogger(JdbcMutexOwnerRepository.class);
    private final DataSource dataSource;
    private static final String SQL_INIT_MUTEX = "insert into simba_mutex (mutex, acquired_at, ttl_at, transition_at, owner_id, version) values (?, 0, 0, 0, '', 0);";
    private static final String SQL_GET = "select acquired_at, ttl_at, transition_at, owner_id, version, cast(unix_timestamp(current_timestamp(3)) * 1000 as unsigned) as current_at from simba_mutex where mutex = ?;";
    private static final String SQL_ACQUIRE = "update simba_mutex set acquired_at=cast(unix_timestamp(current_timestamp(3)) * 1000 as unsigned),    ttl_at=(cast(unix_timestamp(current_timestamp(3)) * 1000 as unsigned) + ?),    transition_at=(cast(unix_timestamp(current_timestamp(3)) * 1000 as unsigned) + ?),    owner_id= ?,    version=version + 1 where mutex = ?   and (      (transition_at < (unix_timestamp(current_timestamp(3)) * 1000))     or       (owner_id = ? and transition_at > (unix_timestamp(current_timestamp(3)) * 1000))    );";
    private static final String SQL_RELEASE = "update simba_mutex set acquired_at=0,ttl_at=0,transition_at=0,owner_id='',version=version + 1 where mutex = ? and owner_id = ?;";

    public JdbcMutexOwnerRepository(DataSource dataSource) {
        Preconditions.checkNotNull((Object)dataSource, (Object)"dataSource can not be null!");
        this.dataSource = dataSource;
    }

    @Override
    public boolean initMutex(String mutex) throws SQLException, SQLIntegrityConstraintViolationException {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)mutex) ? 1 : 0) != 0, (Object)"mutex can not be empty!");
        if (log.isInfoEnabled()) {
            log.info("initMutex - mutex:[{}].", (Object)mutex);
        }
        try (Connection connection = this.dataSource.getConnection();){
            boolean bl = this.initMutex(connection, mutex);
            return bl;
        }
    }

    private boolean initMutex(Connection connection, String mutex) throws SQLException {
        try (PreparedStatement initStatement = connection.prepareStatement(SQL_INIT_MUTEX);){
            initStatement.setString(1, mutex);
            int affected = initStatement.executeUpdate();
            boolean bl = affected > 0;
            return bl;
        }
    }

    @Override
    public boolean tryInitMutex(String mutex) {
        try {
            this.initMutex(mutex);
            return true;
        }
        catch (Throwable throwable) {
            if (log.isInfoEnabled()) {
                log.info("tryInitMutex failed.[{}]", (Object)throwable.getMessage());
            }
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public MutexOwnerEntity getOwner(String mutex) {
        try (Connection connection = this.dataSource.getConnection();){
            MutexOwnerEntity mutexOwnerEntity = this.getOwner(connection, mutex);
            return mutexOwnerEntity;
        }
        catch (SQLException sqlException) {
            throw new SimbaException(sqlException.getMessage(), (Throwable)sqlException);
        }
    }

    /*
     * Exception decompiling
     */
    private MutexOwnerEntity getOwner(Connection connection, String mutex) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public MutexOwnerEntity ensureOwner(String mutex) {
        try (Connection connection = this.dataSource.getConnection();){
            MutexOwnerEntity mutexOwnerEntity = this.ensureOwner(connection, mutex);
            return mutexOwnerEntity;
        }
        catch (SQLException sqlException) {
            throw new SimbaException(sqlException.getMessage(), (Throwable)sqlException);
        }
    }

    private MutexOwnerEntity ensureOwner(Connection connection, String mutex) throws SQLException {
        try {
            return this.getOwner(connection, mutex);
        }
        catch (NotFoundMutexOwnerException notFoundMutexOwnerException) {
            block5: {
                try {
                    if (log.isInfoEnabled()) {
                        log.info("ensureOwner - initMutex:[{}].", (Object)mutex);
                    }
                    this.initMutex(connection, mutex);
                }
                catch (SQLException sqlIntegrityConstraintViolationException) {
                    if (!log.isWarnEnabled()) break block5;
                    log.warn(sqlIntegrityConstraintViolationException.getMessage(), (Throwable)sqlIntegrityConstraintViolationException);
                }
            }
            return this.getOwner(connection, mutex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean acquire(String mutex, String contenderId, long ttl, long transition) {
        try (Connection connection = this.dataSource.getConnection();){
            boolean bl = this.acquire(connection, mutex, contenderId, ttl, transition);
            return bl;
        }
        catch (SQLException sqlException) {
            throw new SimbaException(sqlException.getMessage(), (Throwable)sqlException);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public MutexOwnerEntity acquireAndGetOwner(String mutex, String contenderId, long ttl, long transition) {
        try {
            Throwable throwable = null;
            try (Connection connection = this.dataSource.getConnection();){
                connection.setAutoCommit(false);
                try {
                    boolean acquired = this.acquire(connection, mutex, contenderId, ttl, transition);
                    MutexOwnerEntity mutexOwner = this.ensureOwner(connection, mutex);
                    if (!acquired && !mutexOwner.hasOwner()) {
                        if (log.isInfoEnabled()) {
                            log.info("acquireAndGetOwner - There is no competition for leadership && There is currently no leader [When initializing]. Retry!");
                        }
                        acquired = this.acquire(connection, mutex, contenderId, ttl, transition);
                        mutexOwner = this.ensureOwner(connection, mutex);
                    }
                    if (acquired && !mutexOwner.isOwner(contenderId)) {
                        throw new IllegalStateException(Strings.lenientFormat((String)"Contender:[%s] has acquired leadership, but MutexOwner status is inconsistent!", (Object[])new Object[]{contenderId}));
                    }
                    connection.commit();
                    MutexOwnerEntity mutexOwnerEntity = mutexOwner;
                    return mutexOwnerEntity;
                }
                catch (Throwable throwable2) {
                    try {
                        connection.rollback();
                        throw new SimbaException(throwable2.getMessage(), throwable2);
                    }
                    catch (Throwable throwable3) {
                        throwable = throwable3;
                        throw throwable3;
                    }
                }
            }
        }
        catch (SQLException sqlException) {
            throw new SimbaException(sqlException.getMessage(), (Throwable)sqlException);
        }
    }

    private boolean acquire(Connection connection, String mutex, String contenderId, long ttl, long transition) throws SQLException {
        try (PreparedStatement acquireStatement = connection.prepareStatement(SQL_ACQUIRE);){
            acquireStatement.setLong(1, ttl);
            acquireStatement.setLong(2, ttl + transition);
            acquireStatement.setString(3, contenderId);
            acquireStatement.setString(4, mutex);
            acquireStatement.setString(5, contenderId);
            int affected = acquireStatement.executeUpdate();
            boolean bl = affected > 0;
            return bl;
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean release(String mutex, String contenderId) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

