/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.simba.jdbc;

import com.google.common.base.Strings;
import java.time.Duration;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import me.ahoo.simba.core.AbstractMutexContendService;
import me.ahoo.simba.core.ContendPeriod;
import me.ahoo.simba.core.MutexContender;
import me.ahoo.simba.core.MutexOwner;
import me.ahoo.simba.jdbc.MutexOwnerEntity;
import me.ahoo.simba.jdbc.MutexOwnerRepository;
import me.ahoo.simba.util.Threads;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcMutexContendService
extends AbstractMutexContendService {
    private static final Logger log = LoggerFactory.getLogger(JdbcMutexContendService.class);
    private final MutexOwnerRepository mutexOwnerRepository;
    private final Duration initialDelay;
    private final Duration ttl;
    private final Duration transition;
    private ScheduledThreadPoolExecutor executorService;
    private final ContendPeriod contendPeriod = new ContendPeriod(this.getContenderId());
    private volatile ScheduledFuture<?> contendScheduledFuture;

    public JdbcMutexContendService(MutexContender mutexContender, Executor handleExecutor, MutexOwnerRepository mutexOwnerRepository, Duration initialDelay, Duration ttl, Duration transition) {
        super(mutexContender, handleExecutor);
        this.mutexOwnerRepository = mutexOwnerRepository;
        this.initialDelay = initialDelay;
        this.ttl = ttl;
        this.transition = transition;
    }

    protected void startContend() {
        this.executorService = new ScheduledThreadPoolExecutor(1, Threads.defaultFactory((String)Strings.lenientFormat((String)"JdbcSimba_%s_%s", (Object[])new Object[]{this.getMutex(), this.getContenderId()})));
        this.nextSchedule(this.initialDelay.toMillis());
    }

    private void nextSchedule(long nextDelay) {
        if (log.isDebugEnabled()) {
            log.debug("nextSchedule - mutex:[{}] contenderId:[{}] - nextDelay:[{}].", new Object[]{this.getMutex(), this.getContenderId(), nextDelay});
        }
        this.contendScheduledFuture = this.executorService.schedule(this::safeHandleContend, nextDelay, TimeUnit.MILLISECONDS);
    }

    protected void stopContend() {
        if (this.contendScheduledFuture != null) {
            this.contendScheduledFuture.cancel(true);
        }
        if (this.executorService != null) {
            this.executorService.shutdown();
        }
        this.notifyOwner(MutexOwner.NONE);
        this.mutexOwnerRepository.release(this.getMutex(), this.getContenderId());
    }

    private void safeHandleContend() {
        try {
            MutexOwner mutexOwner = this.contend();
            this.notifyOwner(mutexOwner);
            long nextDelay = this.contendPeriod.ensureNextDelay(mutexOwner);
            this.nextSchedule(nextDelay);
        }
        catch (Throwable throwable) {
            if (log.isErrorEnabled()) {
                log.error(throwable.getMessage(), throwable);
            }
            this.nextSchedule(this.ttl.toMillis());
        }
    }

    private MutexOwner contend() {
        MutexOwnerEntity mutexOwner = this.mutexOwnerRepository.acquireAndGetOwner(this.getMutex(), this.getContenderId(), this.ttl.toMillis(), this.transition.toMillis());
        if (log.isDebugEnabled()) {
            log.debug("contend - mutex:[{}] contenderId:[{}] - succeeded:[{}].", new Object[]{this.getMutex(), this.getContenderId(), mutexOwner.isOwner(this.getContenderId())});
        }
        return mutexOwner;
    }
}

