
package lu.greenhalos.j2asyncapi.schemas;

import java.util.List;
import javax.annotation.processing.Generated;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;


/**
 * An object representing a Server.
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "$ref",
    "url",
    "description",
    "protocol",
    "protocolVersion",
    "variables",
    "security",
    "bindings"
})
@Generated("jsonschema2pojo")
public class Server {

    @JsonProperty("$ref")
    private String $ref;
    @JsonProperty("url")
    private String url;
    @JsonProperty("description")
    private String description;
    /**
     * The transfer protocol.
     * 
     */
    @JsonProperty("protocol")
    @JsonPropertyDescription("The transfer protocol.")
    private String protocol;
    @JsonProperty("protocolVersion")
    private String protocolVersion;
    @JsonProperty("variables")
    private ServerVariables variables;
    @JsonProperty("security")
    private List<SecurityRequirement> security = null;
    @JsonProperty("bindings")
    private BindingsObject bindings;

    @JsonProperty("$ref")
    public String get$ref() {
        return $ref;
    }

    @JsonProperty("$ref")
    public void set$ref(String $ref) {
        this.$ref = $ref;
    }

    @JsonProperty("url")
    public String getUrl() {
        return url;
    }

    @JsonProperty("url")
    public void setUrl(String url) {
        this.url = url;
    }

    @JsonProperty("description")
    public String getDescription() {
        return description;
    }

    @JsonProperty("description")
    public void setDescription(String description) {
        this.description = description;
    }

    /**
     * The transfer protocol.
     * 
     */
    @JsonProperty("protocol")
    public String getProtocol() {
        return protocol;
    }

    /**
     * The transfer protocol.
     * 
     */
    @JsonProperty("protocol")
    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    @JsonProperty("protocolVersion")
    public String getProtocolVersion() {
        return protocolVersion;
    }

    @JsonProperty("protocolVersion")
    public void setProtocolVersion(String protocolVersion) {
        this.protocolVersion = protocolVersion;
    }

    @JsonProperty("variables")
    public ServerVariables getVariables() {
        return variables;
    }

    @JsonProperty("variables")
    public void setVariables(ServerVariables variables) {
        this.variables = variables;
    }

    @JsonProperty("security")
    public List<SecurityRequirement> getSecurity() {
        return security;
    }

    @JsonProperty("security")
    public void setSecurity(List<SecurityRequirement> security) {
        this.security = security;
    }

    @JsonProperty("bindings")
    public BindingsObject getBindings() {
        return bindings;
    }

    @JsonProperty("bindings")
    public void setBindings(BindingsObject bindings) {
        this.bindings = bindings;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Server.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("$ref");
        sb.append('=');
        sb.append(((this.$ref == null)?"<null>":this.$ref));
        sb.append(',');
        sb.append("url");
        sb.append('=');
        sb.append(((this.url == null)?"<null>":this.url));
        sb.append(',');
        sb.append("description");
        sb.append('=');
        sb.append(((this.description == null)?"<null>":this.description));
        sb.append(',');
        sb.append("protocol");
        sb.append('=');
        sb.append(((this.protocol == null)?"<null>":this.protocol));
        sb.append(',');
        sb.append("protocolVersion");
        sb.append('=');
        sb.append(((this.protocolVersion == null)?"<null>":this.protocolVersion));
        sb.append(',');
        sb.append("variables");
        sb.append('=');
        sb.append(((this.variables == null)?"<null>":this.variables));
        sb.append(',');
        sb.append("security");
        sb.append('=');
        sb.append(((this.security == null)?"<null>":this.security));
        sb.append(',');
        sb.append("bindings");
        sb.append('=');
        sb.append(((this.bindings == null)?"<null>":this.bindings));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.protocol == null)? 0 :this.protocol.hashCode()));
        result = ((result* 31)+((this.variables == null)? 0 :this.variables.hashCode()));
        result = ((result* 31)+((this.security == null)? 0 :this.security.hashCode()));
        result = ((result* 31)+((this.bindings == null)? 0 :this.bindings.hashCode()));
        result = ((result* 31)+((this.description == null)? 0 :this.description.hashCode()));
        result = ((result* 31)+((this.protocolVersion == null)? 0 :this.protocolVersion.hashCode()));
        result = ((result* 31)+((this.$ref == null)? 0 :this.$ref.hashCode()));
        result = ((result* 31)+((this.url == null)? 0 :this.url.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof Server) == false) {
            return false;
        }
        Server rhs = ((Server) other);
        return (((((((((this.protocol == rhs.protocol)||((this.protocol!= null)&&this.protocol.equals(rhs.protocol)))&&((this.variables == rhs.variables)||((this.variables!= null)&&this.variables.equals(rhs.variables))))&&((this.security == rhs.security)||((this.security!= null)&&this.security.equals(rhs.security))))&&((this.bindings == rhs.bindings)||((this.bindings!= null)&&this.bindings.equals(rhs.bindings))))&&((this.description == rhs.description)||((this.description!= null)&&this.description.equals(rhs.description))))&&((this.protocolVersion == rhs.protocolVersion)||((this.protocolVersion!= null)&&this.protocolVersion.equals(rhs.protocolVersion))))&&((this.$ref == rhs.$ref)||((this.$ref!= null)&&this.$ref.equals(rhs.$ref))))&&((this.url == rhs.url)||((this.url!= null)&&this.url.equals(rhs.url))));
    }

}
