
package lu.greenhalos.j2asyncapi.schemas;

import java.util.List;
import java.util.Set;
import javax.annotation.processing.Generated;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "schemaFormat",
    "contentType",
    "headers",
    "correlationId",
    "tags",
    "summary",
    "name",
    "title",
    "description",
    "externalDocs",
    "deprecated",
    "examples",
    "bindings"
})
@Generated("jsonschema2pojo")
public class MessageTrait {

    @JsonProperty("schemaFormat")
    private String schemaFormat;
    @JsonProperty("contentType")
    private String contentType;
    @JsonProperty("headers")
    private Object headers;
    @JsonProperty("correlationId")
    private Object correlationId;
    @JsonProperty("tags")
    @JsonDeserialize(as = java.util.LinkedHashSet.class)
    private Set<Tag> tags = null;
    /**
     * A brief summary of the message.
     * 
     */
    @JsonProperty("summary")
    @JsonPropertyDescription("A brief summary of the message.")
    private String summary;
    /**
     * Name of the message.
     * 
     */
    @JsonProperty("name")
    @JsonPropertyDescription("Name of the message.")
    private String name;
    /**
     * A human-friendly title for the message.
     * 
     */
    @JsonProperty("title")
    @JsonPropertyDescription("A human-friendly title for the message.")
    private String title;
    /**
     * A longer description of the message. CommonMark is allowed.
     * 
     */
    @JsonProperty("description")
    @JsonPropertyDescription("A longer description of the message. CommonMark is allowed.")
    private String description;
    /**
     * information about external documentation
     * 
     */
    @JsonProperty("externalDocs")
    @JsonPropertyDescription("information about external documentation")
    private ExternalDocs externalDocs;
    @JsonProperty("deprecated")
    private Boolean deprecated = false;
    @JsonProperty("examples")
    private List<Example> examples = null;
    @JsonProperty("bindings")
    private BindingsObject bindings;

    @JsonProperty("schemaFormat")
    public String getSchemaFormat() {
        return schemaFormat;
    }

    @JsonProperty("schemaFormat")
    public void setSchemaFormat(String schemaFormat) {
        this.schemaFormat = schemaFormat;
    }

    @JsonProperty("contentType")
    public String getContentType() {
        return contentType;
    }

    @JsonProperty("contentType")
    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    @JsonProperty("headers")
    public Object getHeaders() {
        return headers;
    }

    @JsonProperty("headers")
    public void setHeaders(Object headers) {
        this.headers = headers;
    }

    @JsonProperty("correlationId")
    public Object getCorrelationId() {
        return correlationId;
    }

    @JsonProperty("correlationId")
    public void setCorrelationId(Object correlationId) {
        this.correlationId = correlationId;
    }

    @JsonProperty("tags")
    public Set<Tag> getTags() {
        return tags;
    }

    @JsonProperty("tags")
    public void setTags(Set<Tag> tags) {
        this.tags = tags;
    }

    /**
     * A brief summary of the message.
     * 
     */
    @JsonProperty("summary")
    public String getSummary() {
        return summary;
    }

    /**
     * A brief summary of the message.
     * 
     */
    @JsonProperty("summary")
    public void setSummary(String summary) {
        this.summary = summary;
    }

    /**
     * Name of the message.
     * 
     */
    @JsonProperty("name")
    public String getName() {
        return name;
    }

    /**
     * Name of the message.
     * 
     */
    @JsonProperty("name")
    public void setName(String name) {
        this.name = name;
    }

    /**
     * A human-friendly title for the message.
     * 
     */
    @JsonProperty("title")
    public String getTitle() {
        return title;
    }

    /**
     * A human-friendly title for the message.
     * 
     */
    @JsonProperty("title")
    public void setTitle(String title) {
        this.title = title;
    }

    /**
     * A longer description of the message. CommonMark is allowed.
     * 
     */
    @JsonProperty("description")
    public String getDescription() {
        return description;
    }

    /**
     * A longer description of the message. CommonMark is allowed.
     * 
     */
    @JsonProperty("description")
    public void setDescription(String description) {
        this.description = description;
    }

    /**
     * information about external documentation
     * 
     */
    @JsonProperty("externalDocs")
    public ExternalDocs getExternalDocs() {
        return externalDocs;
    }

    /**
     * information about external documentation
     * 
     */
    @JsonProperty("externalDocs")
    public void setExternalDocs(ExternalDocs externalDocs) {
        this.externalDocs = externalDocs;
    }

    @JsonProperty("deprecated")
    public Boolean getDeprecated() {
        return deprecated;
    }

    @JsonProperty("deprecated")
    public void setDeprecated(Boolean deprecated) {
        this.deprecated = deprecated;
    }

    @JsonProperty("examples")
    public List<Example> getExamples() {
        return examples;
    }

    @JsonProperty("examples")
    public void setExamples(List<Example> examples) {
        this.examples = examples;
    }

    @JsonProperty("bindings")
    public BindingsObject getBindings() {
        return bindings;
    }

    @JsonProperty("bindings")
    public void setBindings(BindingsObject bindings) {
        this.bindings = bindings;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(MessageTrait.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("schemaFormat");
        sb.append('=');
        sb.append(((this.schemaFormat == null)?"<null>":this.schemaFormat));
        sb.append(',');
        sb.append("contentType");
        sb.append('=');
        sb.append(((this.contentType == null)?"<null>":this.contentType));
        sb.append(',');
        sb.append("headers");
        sb.append('=');
        sb.append(((this.headers == null)?"<null>":this.headers));
        sb.append(',');
        sb.append("correlationId");
        sb.append('=');
        sb.append(((this.correlationId == null)?"<null>":this.correlationId));
        sb.append(',');
        sb.append("tags");
        sb.append('=');
        sb.append(((this.tags == null)?"<null>":this.tags));
        sb.append(',');
        sb.append("summary");
        sb.append('=');
        sb.append(((this.summary == null)?"<null>":this.summary));
        sb.append(',');
        sb.append("name");
        sb.append('=');
        sb.append(((this.name == null)?"<null>":this.name));
        sb.append(',');
        sb.append("title");
        sb.append('=');
        sb.append(((this.title == null)?"<null>":this.title));
        sb.append(',');
        sb.append("description");
        sb.append('=');
        sb.append(((this.description == null)?"<null>":this.description));
        sb.append(',');
        sb.append("externalDocs");
        sb.append('=');
        sb.append(((this.externalDocs == null)?"<null>":this.externalDocs));
        sb.append(',');
        sb.append("deprecated");
        sb.append('=');
        sb.append(((this.deprecated == null)?"<null>":this.deprecated));
        sb.append(',');
        sb.append("examples");
        sb.append('=');
        sb.append(((this.examples == null)?"<null>":this.examples));
        sb.append(',');
        sb.append("bindings");
        sb.append('=');
        sb.append(((this.bindings == null)?"<null>":this.bindings));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.summary == null)? 0 :this.summary.hashCode()));
        result = ((result* 31)+((this.headers == null)? 0 :this.headers.hashCode()));
        result = ((result* 31)+((this.deprecated == null)? 0 :this.deprecated.hashCode()));
        result = ((result* 31)+((this.bindings == null)? 0 :this.bindings.hashCode()));
        result = ((result* 31)+((this.description == null)? 0 :this.description.hashCode()));
        result = ((result* 31)+((this.title == null)? 0 :this.title.hashCode()));
        result = ((result* 31)+((this.schemaFormat == null)? 0 :this.schemaFormat.hashCode()));
        result = ((result* 31)+((this.tags == null)? 0 :this.tags.hashCode()));
        result = ((result* 31)+((this.examples == null)? 0 :this.examples.hashCode()));
        result = ((result* 31)+((this.name == null)? 0 :this.name.hashCode()));
        result = ((result* 31)+((this.correlationId == null)? 0 :this.correlationId.hashCode()));
        result = ((result* 31)+((this.externalDocs == null)? 0 :this.externalDocs.hashCode()));
        result = ((result* 31)+((this.contentType == null)? 0 :this.contentType.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof MessageTrait) == false) {
            return false;
        }
        MessageTrait rhs = ((MessageTrait) other);
        return ((((((((((((((this.summary == rhs.summary)||((this.summary!= null)&&this.summary.equals(rhs.summary)))&&((this.headers == rhs.headers)||((this.headers!= null)&&this.headers.equals(rhs.headers))))&&((this.deprecated == rhs.deprecated)||((this.deprecated!= null)&&this.deprecated.equals(rhs.deprecated))))&&((this.bindings == rhs.bindings)||((this.bindings!= null)&&this.bindings.equals(rhs.bindings))))&&((this.description == rhs.description)||((this.description!= null)&&this.description.equals(rhs.description))))&&((this.title == rhs.title)||((this.title!= null)&&this.title.equals(rhs.title))))&&((this.schemaFormat == rhs.schemaFormat)||((this.schemaFormat!= null)&&this.schemaFormat.equals(rhs.schemaFormat))))&&((this.tags == rhs.tags)||((this.tags!= null)&&this.tags.equals(rhs.tags))))&&((this.examples == rhs.examples)||((this.examples!= null)&&this.examples.equals(rhs.examples))))&&((this.name == rhs.name)||((this.name!= null)&&this.name.equals(rhs.name))))&&((this.correlationId == rhs.correlationId)||((this.correlationId!= null)&&this.correlationId.equals(rhs.correlationId))))&&((this.externalDocs == rhs.externalDocs)||((this.externalDocs!= null)&&this.externalDocs.equals(rhs.externalDocs))))&&((this.contentType == rhs.contentType)||((this.contentType!= null)&&this.contentType.equals(rhs.contentType))));
    }

}
