
package lu.greenhalos.j2asyncapi.schemas;

import javax.annotation.processing.Generated;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;


/**
 * An object to hold a set of reusable objects for different aspects of the AsyncAPI Specification.
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "schemas",
    "servers",
    "channels",
    "messages",
    "securitySchemes",
    "parameters",
    "correlationIds",
    "operationTraits",
    "messageTraits",
    "serverBindings",
    "channelBindings",
    "operationBindings",
    "messageBindings"
})
@Generated("jsonschema2pojo")
public class Components {

    /**
     * JSON objects describing schemas the API uses.
     * 
     */
    @JsonProperty("schemas")
    @JsonPropertyDescription("JSON objects describing schemas the API uses.")
    private Schemas schemas;
    @JsonProperty("servers")
    private Servers servers;
    @JsonProperty("channels")
    private Channels channels;
    /**
     * JSON objects describing the messages being consumed and produced by the API.
     * 
     */
    @JsonProperty("messages")
    @JsonPropertyDescription("JSON objects describing the messages being consumed and produced by the API.")
    private Messages messages;
    @JsonProperty("securitySchemes")
    private SecuritySchemes securitySchemes;
    /**
     * JSON objects describing re-usable channel parameters.
     * 
     */
    @JsonProperty("parameters")
    @JsonPropertyDescription("JSON objects describing re-usable channel parameters.")
    private Parameters__1 parameters;
    @JsonProperty("correlationIds")
    private CorrelationIds correlationIds;
    @JsonProperty("operationTraits")
    private OperationTraits operationTraits;
    @JsonProperty("messageTraits")
    private MessageTraits messageTraits;
    @JsonProperty("serverBindings")
    private ServerBindings serverBindings;
    @JsonProperty("channelBindings")
    private ChannelBindings channelBindings;
    @JsonProperty("operationBindings")
    private OperationBindings operationBindings;
    @JsonProperty("messageBindings")
    private MessageBindings messageBindings;

    /**
     * JSON objects describing schemas the API uses.
     * 
     */
    @JsonProperty("schemas")
    public Schemas getSchemas() {
        return schemas;
    }

    /**
     * JSON objects describing schemas the API uses.
     * 
     */
    @JsonProperty("schemas")
    public void setSchemas(Schemas schemas) {
        this.schemas = schemas;
    }

    @JsonProperty("servers")
    public Servers getServers() {
        return servers;
    }

    @JsonProperty("servers")
    public void setServers(Servers servers) {
        this.servers = servers;
    }

    @JsonProperty("channels")
    public Channels getChannels() {
        return channels;
    }

    @JsonProperty("channels")
    public void setChannels(Channels channels) {
        this.channels = channels;
    }

    /**
     * JSON objects describing the messages being consumed and produced by the API.
     * 
     */
    @JsonProperty("messages")
    public Messages getMessages() {
        return messages;
    }

    /**
     * JSON objects describing the messages being consumed and produced by the API.
     * 
     */
    @JsonProperty("messages")
    public void setMessages(Messages messages) {
        this.messages = messages;
    }

    @JsonProperty("securitySchemes")
    public SecuritySchemes getSecuritySchemes() {
        return securitySchemes;
    }

    @JsonProperty("securitySchemes")
    public void setSecuritySchemes(SecuritySchemes securitySchemes) {
        this.securitySchemes = securitySchemes;
    }

    /**
     * JSON objects describing re-usable channel parameters.
     * 
     */
    @JsonProperty("parameters")
    public Parameters__1 getParameters() {
        return parameters;
    }

    /**
     * JSON objects describing re-usable channel parameters.
     * 
     */
    @JsonProperty("parameters")
    public void setParameters(Parameters__1 parameters) {
        this.parameters = parameters;
    }

    @JsonProperty("correlationIds")
    public CorrelationIds getCorrelationIds() {
        return correlationIds;
    }

    @JsonProperty("correlationIds")
    public void setCorrelationIds(CorrelationIds correlationIds) {
        this.correlationIds = correlationIds;
    }

    @JsonProperty("operationTraits")
    public OperationTraits getOperationTraits() {
        return operationTraits;
    }

    @JsonProperty("operationTraits")
    public void setOperationTraits(OperationTraits operationTraits) {
        this.operationTraits = operationTraits;
    }

    @JsonProperty("messageTraits")
    public MessageTraits getMessageTraits() {
        return messageTraits;
    }

    @JsonProperty("messageTraits")
    public void setMessageTraits(MessageTraits messageTraits) {
        this.messageTraits = messageTraits;
    }

    @JsonProperty("serverBindings")
    public ServerBindings getServerBindings() {
        return serverBindings;
    }

    @JsonProperty("serverBindings")
    public void setServerBindings(ServerBindings serverBindings) {
        this.serverBindings = serverBindings;
    }

    @JsonProperty("channelBindings")
    public ChannelBindings getChannelBindings() {
        return channelBindings;
    }

    @JsonProperty("channelBindings")
    public void setChannelBindings(ChannelBindings channelBindings) {
        this.channelBindings = channelBindings;
    }

    @JsonProperty("operationBindings")
    public OperationBindings getOperationBindings() {
        return operationBindings;
    }

    @JsonProperty("operationBindings")
    public void setOperationBindings(OperationBindings operationBindings) {
        this.operationBindings = operationBindings;
    }

    @JsonProperty("messageBindings")
    public MessageBindings getMessageBindings() {
        return messageBindings;
    }

    @JsonProperty("messageBindings")
    public void setMessageBindings(MessageBindings messageBindings) {
        this.messageBindings = messageBindings;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Components.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("schemas");
        sb.append('=');
        sb.append(((this.schemas == null)?"<null>":this.schemas));
        sb.append(',');
        sb.append("servers");
        sb.append('=');
        sb.append(((this.servers == null)?"<null>":this.servers));
        sb.append(',');
        sb.append("channels");
        sb.append('=');
        sb.append(((this.channels == null)?"<null>":this.channels));
        sb.append(',');
        sb.append("messages");
        sb.append('=');
        sb.append(((this.messages == null)?"<null>":this.messages));
        sb.append(',');
        sb.append("securitySchemes");
        sb.append('=');
        sb.append(((this.securitySchemes == null)?"<null>":this.securitySchemes));
        sb.append(',');
        sb.append("parameters");
        sb.append('=');
        sb.append(((this.parameters == null)?"<null>":this.parameters));
        sb.append(',');
        sb.append("correlationIds");
        sb.append('=');
        sb.append(((this.correlationIds == null)?"<null>":this.correlationIds));
        sb.append(',');
        sb.append("operationTraits");
        sb.append('=');
        sb.append(((this.operationTraits == null)?"<null>":this.operationTraits));
        sb.append(',');
        sb.append("messageTraits");
        sb.append('=');
        sb.append(((this.messageTraits == null)?"<null>":this.messageTraits));
        sb.append(',');
        sb.append("serverBindings");
        sb.append('=');
        sb.append(((this.serverBindings == null)?"<null>":this.serverBindings));
        sb.append(',');
        sb.append("channelBindings");
        sb.append('=');
        sb.append(((this.channelBindings == null)?"<null>":this.channelBindings));
        sb.append(',');
        sb.append("operationBindings");
        sb.append('=');
        sb.append(((this.operationBindings == null)?"<null>":this.operationBindings));
        sb.append(',');
        sb.append("messageBindings");
        sb.append('=');
        sb.append(((this.messageBindings == null)?"<null>":this.messageBindings));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.messageTraits == null)? 0 :this.messageTraits.hashCode()));
        result = ((result* 31)+((this.servers == null)? 0 :this.servers.hashCode()));
        result = ((result* 31)+((this.channels == null)? 0 :this.channels.hashCode()));
        result = ((result* 31)+((this.schemas == null)? 0 :this.schemas.hashCode()));
        result = ((result* 31)+((this.correlationIds == null)? 0 :this.correlationIds.hashCode()));
        result = ((result* 31)+((this.operationBindings == null)? 0 :this.operationBindings.hashCode()));
        result = ((result* 31)+((this.operationTraits == null)? 0 :this.operationTraits.hashCode()));
        result = ((result* 31)+((this.messageBindings == null)? 0 :this.messageBindings.hashCode()));
        result = ((result* 31)+((this.messages == null)? 0 :this.messages.hashCode()));
        result = ((result* 31)+((this.securitySchemes == null)? 0 :this.securitySchemes.hashCode()));
        result = ((result* 31)+((this.parameters == null)? 0 :this.parameters.hashCode()));
        result = ((result* 31)+((this.serverBindings == null)? 0 :this.serverBindings.hashCode()));
        result = ((result* 31)+((this.channelBindings == null)? 0 :this.channelBindings.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof Components) == false) {
            return false;
        }
        Components rhs = ((Components) other);
        return ((((((((((((((this.messageTraits == rhs.messageTraits)||((this.messageTraits!= null)&&this.messageTraits.equals(rhs.messageTraits)))&&((this.servers == rhs.servers)||((this.servers!= null)&&this.servers.equals(rhs.servers))))&&((this.channels == rhs.channels)||((this.channels!= null)&&this.channels.equals(rhs.channels))))&&((this.schemas == rhs.schemas)||((this.schemas!= null)&&this.schemas.equals(rhs.schemas))))&&((this.correlationIds == rhs.correlationIds)||((this.correlationIds!= null)&&this.correlationIds.equals(rhs.correlationIds))))&&((this.operationBindings == rhs.operationBindings)||((this.operationBindings!= null)&&this.operationBindings.equals(rhs.operationBindings))))&&((this.operationTraits == rhs.operationTraits)||((this.operationTraits!= null)&&this.operationTraits.equals(rhs.operationTraits))))&&((this.messageBindings == rhs.messageBindings)||((this.messageBindings!= null)&&this.messageBindings.equals(rhs.messageBindings))))&&((this.messages == rhs.messages)||((this.messages!= null)&&this.messages.equals(rhs.messages))))&&((this.securitySchemes == rhs.securitySchemes)||((this.securitySchemes!= null)&&this.securitySchemes.equals(rhs.securitySchemes))))&&((this.parameters == rhs.parameters)||((this.parameters!= null)&&this.parameters.equals(rhs.parameters))))&&((this.serverBindings == rhs.serverBindings)||((this.serverBindings!= null)&&this.serverBindings.equals(rhs.serverBindings))))&&((this.channelBindings == rhs.channelBindings)||((this.channelBindings!= null)&&this.channelBindings.equals(rhs.channelBindings))));
    }

}
