
package lu.greenhalos.j2asyncapi.schemas;

import java.util.Set;
import javax.annotation.processing.Generated;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "$ref",
    "parameters",
    "description",
    "servers",
    "publish",
    "subscribe",
    "deprecated",
    "bindings"
})
@Generated("jsonschema2pojo")
public class ChannelItem {

    @JsonProperty("$ref")
    private String $ref;
    @JsonProperty("parameters")
    private Parameters parameters;
    /**
     * A description of the channel.
     * 
     */
    @JsonProperty("description")
    @JsonPropertyDescription("A description of the channel.")
    private String description;
    /**
     * The names of the servers on which this channel is available. If absent or empty then this channel must be available on all servers.
     * 
     */
    @JsonProperty("servers")
    @JsonDeserialize(as = java.util.LinkedHashSet.class)
    @JsonPropertyDescription("The names of the servers on which this channel is available. If absent or empty then this channel must be available on all servers.")
    private Set<String> servers = null;
    @JsonProperty("publish")
    private Operation publish;
    @JsonProperty("subscribe")
    private Operation subscribe;
    @JsonProperty("deprecated")
    private Boolean deprecated = false;
    @JsonProperty("bindings")
    private BindingsObject bindings;

    @JsonProperty("$ref")
    public String get$ref() {
        return $ref;
    }

    @JsonProperty("$ref")
    public void set$ref(String $ref) {
        this.$ref = $ref;
    }

    @JsonProperty("parameters")
    public Parameters getParameters() {
        return parameters;
    }

    @JsonProperty("parameters")
    public void setParameters(Parameters parameters) {
        this.parameters = parameters;
    }

    /**
     * A description of the channel.
     * 
     */
    @JsonProperty("description")
    public String getDescription() {
        return description;
    }

    /**
     * A description of the channel.
     * 
     */
    @JsonProperty("description")
    public void setDescription(String description) {
        this.description = description;
    }

    /**
     * The names of the servers on which this channel is available. If absent or empty then this channel must be available on all servers.
     * 
     */
    @JsonProperty("servers")
    public Set<String> getServers() {
        return servers;
    }

    /**
     * The names of the servers on which this channel is available. If absent or empty then this channel must be available on all servers.
     * 
     */
    @JsonProperty("servers")
    public void setServers(Set<String> servers) {
        this.servers = servers;
    }

    @JsonProperty("publish")
    public Operation getPublish() {
        return publish;
    }

    @JsonProperty("publish")
    public void setPublish(Operation publish) {
        this.publish = publish;
    }

    @JsonProperty("subscribe")
    public Operation getSubscribe() {
        return subscribe;
    }

    @JsonProperty("subscribe")
    public void setSubscribe(Operation subscribe) {
        this.subscribe = subscribe;
    }

    @JsonProperty("deprecated")
    public Boolean getDeprecated() {
        return deprecated;
    }

    @JsonProperty("deprecated")
    public void setDeprecated(Boolean deprecated) {
        this.deprecated = deprecated;
    }

    @JsonProperty("bindings")
    public BindingsObject getBindings() {
        return bindings;
    }

    @JsonProperty("bindings")
    public void setBindings(BindingsObject bindings) {
        this.bindings = bindings;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(ChannelItem.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("$ref");
        sb.append('=');
        sb.append(((this.$ref == null)?"<null>":this.$ref));
        sb.append(',');
        sb.append("parameters");
        sb.append('=');
        sb.append(((this.parameters == null)?"<null>":this.parameters));
        sb.append(',');
        sb.append("description");
        sb.append('=');
        sb.append(((this.description == null)?"<null>":this.description));
        sb.append(',');
        sb.append("servers");
        sb.append('=');
        sb.append(((this.servers == null)?"<null>":this.servers));
        sb.append(',');
        sb.append("publish");
        sb.append('=');
        sb.append(((this.publish == null)?"<null>":this.publish));
        sb.append(',');
        sb.append("subscribe");
        sb.append('=');
        sb.append(((this.subscribe == null)?"<null>":this.subscribe));
        sb.append(',');
        sb.append("deprecated");
        sb.append('=');
        sb.append(((this.deprecated == null)?"<null>":this.deprecated));
        sb.append(',');
        sb.append("bindings");
        sb.append('=');
        sb.append(((this.bindings == null)?"<null>":this.bindings));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.servers == null)? 0 :this.servers.hashCode()));
        result = ((result* 31)+((this.subscribe == null)? 0 :this.subscribe.hashCode()));
        result = ((result* 31)+((this.publish == null)? 0 :this.publish.hashCode()));
        result = ((result* 31)+((this.deprecated == null)? 0 :this.deprecated.hashCode()));
        result = ((result* 31)+((this.bindings == null)? 0 :this.bindings.hashCode()));
        result = ((result* 31)+((this.description == null)? 0 :this.description.hashCode()));
        result = ((result* 31)+((this.$ref == null)? 0 :this.$ref.hashCode()));
        result = ((result* 31)+((this.parameters == null)? 0 :this.parameters.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof ChannelItem) == false) {
            return false;
        }
        ChannelItem rhs = ((ChannelItem) other);
        return (((((((((this.servers == rhs.servers)||((this.servers!= null)&&this.servers.equals(rhs.servers)))&&((this.subscribe == rhs.subscribe)||((this.subscribe!= null)&&this.subscribe.equals(rhs.subscribe))))&&((this.publish == rhs.publish)||((this.publish!= null)&&this.publish.equals(rhs.publish))))&&((this.deprecated == rhs.deprecated)||((this.deprecated!= null)&&this.deprecated.equals(rhs.deprecated))))&&((this.bindings == rhs.bindings)||((this.bindings!= null)&&this.bindings.equals(rhs.bindings))))&&((this.description == rhs.description)||((this.description!= null)&&this.description.equals(rhs.description))))&&((this.$ref == rhs.$ref)||((this.$ref!= null)&&this.$ref.equals(rhs.$ref))))&&((this.parameters == rhs.parameters)||((this.parameters!= null)&&this.parameters.equals(rhs.parameters))));
    }

}
