/*
 * Decompiled with CFR 0.152.
 */
package it.krzeminski.githubactions.yaml;

import it.krzeminski.githubactions.domain.Concurrency;
import it.krzeminski.githubactions.domain.Job;
import it.krzeminski.githubactions.domain.JobOutputs;
import it.krzeminski.githubactions.domain.RunnerType;
import it.krzeminski.githubactions.internal.InternalGithubActionsApi;
import it.krzeminski.githubactions.yaml.StepsToYamlKt;
import it.krzeminski.githubactions.yaml.UtilsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 0}, k=2, xi=48, d1={"\u0000\u001e\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a0\u0010\u0000\u001a\u001c\u0012\u0004\u0012\u00020\u0002\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u00010\u0001*\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00050\u0004H\u0000\u001a\u001e\u0010\u0006\u001a\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0001*\u0006\u0012\u0002\b\u00030\u0005H\u0002\u001a\f\u0010\u0006\u001a\u00020\u0002*\u00020\u0007H\u0007\u00a8\u0006\b"}, d2={"jobsToYaml", "", "", "", "", "Lit/krzeminski/githubactions/domain/Job;", "toYaml", "Lit/krzeminski/githubactions/domain/RunnerType;", "library"})
@SourceDebugExtension(value={"SMAP\nJobsToYaml.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JobsToYaml.kt\nit/krzeminski/githubactions/yaml/JobsToYamlKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,63:1\n1208#2,2:64\n1238#2,4:66\n1549#2:71\n1620#2,3:72\n1#3:70\n*S KotlinDebug\n*F\n+ 1 JobsToYaml.kt\nit/krzeminski/githubactions/yaml/JobsToYamlKt\n*L\n19#1:64,2\n19#1:66,4\n35#1:71\n35#1:72,3\n*E\n"})
public final class JobsToYamlKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Map<String, Map<String, Object>> jobsToYaml(@NotNull List<? extends Job<?>> $this$jobsToYaml) {
        void $this$associateByTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$jobsToYaml, (String)"<this>");
        Iterable $this$associateBy$iv = $this$jobsToYaml;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            Job job = (Job)element$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            Job it = (Job)element$iv$iv;
            String string = it.getId();
            boolean bl2 = false;
            Map<String, Object> map2 = JobsToYamlKt.toYaml(it);
            map.put(string, map2);
        }
        return destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private static final Map<String, Object> toYaml(Job<?> $this$toYaml) {
        Object object;
        Object object2;
        Map<String, String> map;
        Object object3;
        Collection collection;
        Map map2;
        Object object4;
        Pair[] pairArray;
        int n;
        String string;
        Pair[] pairArray2 = new Pair[9];
        pairArray2[0] = TuplesKt.to((Object)"name", (Object)$this$toYaml.getName());
        pairArray2[1] = TuplesKt.to((Object)"runs-on", (Object)JobsToYamlKt.toYaml($this$toYaml.getRunsOn()));
        Pair[] pairArray3 = pairArray2;
        int n2 = 2;
        String string2 = "concurrency";
        Concurrency concurrency = $this$toYaml.getConcurrency();
        if (concurrency != null) {
            void it;
            Concurrency concurrency2 = concurrency;
            string = string2;
            n = n2;
            pairArray = pairArray3;
            boolean bl = false;
            Pair[] pairArray4 = new Pair[]{TuplesKt.to((Object)"group", (Object)it.getGroup()), TuplesKt.to((Object)"cancel-in-progress", (Object)it.getCancelInProgress())};
            object4 = MapsKt.mapOf((Pair[])pairArray4);
            pairArray3 = pairArray;
            n2 = n;
            string2 = string;
            map2 = object4;
        } else {
            map2 = null;
        }
        pairArray3[n2] = TuplesKt.to((Object)string2, map2);
        Pair[] pairArray5 = pairArray2;
        int n3 = 3;
        String string3 = "needs";
        Iterable iterable = $this$toYaml.getNeeds();
        if (iterable.isEmpty()) {
            string = string3;
            n = n3;
            pairArray = pairArray5;
            boolean bl = false;
            object4 = null;
            pairArray5 = pairArray;
            n3 = n;
            string3 = string;
            collection = object4;
        } else {
            collection = iterable;
        }
        List list = (List)collection;
        if (list != null) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            iterable = list;
            string = string3;
            n = n3;
            pairArray = pairArray5;
            boolean $i$f$map = false;
            void bl = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Job job = (Job)item$iv$iv;
                object4 = destination$iv$iv;
                boolean bl2 = false;
                object4.add(it.getId());
            }
            object4 = (List)destination$iv$iv;
            pairArray5 = pairArray;
            n3 = n;
            string3 = string;
            object3 = object4;
        } else {
            object3 = null;
        }
        pairArray5[n3] = TuplesKt.to((Object)string3, object3);
        Pair[] pairArray6 = pairArray2;
        int n4 = 4;
        String string4 = "env";
        Map<String, String> map3 = (Map<String, String>)$this$toYaml.getEnv();
        if (map3.isEmpty()) {
            string = string4;
            n = n4;
            pairArray = pairArray6;
            boolean bl = false;
            object4 = null;
            pairArray6 = pairArray;
            n4 = n;
            string4 = string;
            map = object4;
        } else {
            map = map3;
        }
        pairArray6[n4] = TuplesKt.to((Object)string4, (Object)map);
        pairArray2[5] = TuplesKt.to((Object)"if", (Object)$this$toYaml.getCondition());
        Pair[] pairArray7 = pairArray2;
        int n5 = 6;
        String string5 = "strategy";
        Map<String, List<String>> map4 = $this$toYaml.getStrategyMatrix();
        if (map4 != null) {
            void it;
            Map<String, List<String>> $i$f$map = map4;
            string = string5;
            n = n5;
            pairArray = pairArray7;
            boolean bl = false;
            object4 = MapsKt.mapOf((Pair)TuplesKt.to((Object)"matrix", (Object)it));
            pairArray7 = pairArray;
            n5 = n;
            string5 = string;
            object2 = object4;
        } else {
            object2 = null;
        }
        pairArray7[n5] = TuplesKt.to((Object)string5, object2);
        pairArray2[7] = TuplesKt.to((Object)"timeout-minutes", (Object)$this$toYaml.getTimeoutMinutes());
        Pair[] pairArray8 = pairArray2;
        int n6 = 8;
        String string6 = "outputs";
        map3 = ((JobOutputs)$this$toYaml.getOutputs()).getOutputMapping();
        if (map3.isEmpty()) {
            string = string6;
            n = n6;
            pairArray = pairArray8;
            boolean bl = false;
            object4 = null;
            pairArray8 = pairArray;
            n6 = n;
            string6 = string;
            object = object4;
        } else {
            object = map3;
        }
        pairArray8[n6] = TuplesKt.to((Object)string6, object);
        return MapsKt.plus((Map)MapsKt.plus(UtilsKt.mapOfNotNullValues(pairArray2), $this$toYaml.get_customArguments()), (Map)MapsKt.mapOf((Pair)TuplesKt.to((Object)"steps", StepsToYamlKt.stepsToYaml($this$toYaml.getSteps()))));
    }

    @InternalGithubActionsApi
    @NotNull
    public static final String toYaml(@NotNull RunnerType $this$toYaml) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$toYaml, (String)"<this>");
        RunnerType runnerType = $this$toYaml;
        if (runnerType instanceof RunnerType.Custom) {
            string = ((RunnerType.Custom)$this$toYaml).getRunsOn();
        } else if (Intrinsics.areEqual((Object)runnerType, (Object)RunnerType.UbuntuLatest.INSTANCE)) {
            string = "ubuntu-latest";
        } else if (Intrinsics.areEqual((Object)runnerType, (Object)RunnerType.WindowsLatest.INSTANCE)) {
            string = "windows-latest";
        } else if (Intrinsics.areEqual((Object)runnerType, (Object)RunnerType.MacOSLatest.INSTANCE)) {
            string = "macos-latest";
        } else if (Intrinsics.areEqual((Object)runnerType, (Object)RunnerType.Windows2022.INSTANCE)) {
            string = "windows-2022";
        } else if (Intrinsics.areEqual((Object)runnerType, (Object)RunnerType.Windows2019.INSTANCE)) {
            string = "windows-2019";
        } else if (Intrinsics.areEqual((Object)runnerType, (Object)RunnerType.Windows2016.INSTANCE)) {
            string = "windows-2016";
        } else if (Intrinsics.areEqual((Object)runnerType, (Object)RunnerType.Ubuntu2004.INSTANCE)) {
            string = "ubuntu-20.04";
        } else if (Intrinsics.areEqual((Object)runnerType, (Object)RunnerType.Ubuntu1804.INSTANCE)) {
            string = "ubuntu-18.04";
        } else if (Intrinsics.areEqual((Object)runnerType, (Object)RunnerType.MacOS11.INSTANCE)) {
            string = "macos-11";
        } else if (Intrinsics.areEqual((Object)runnerType, (Object)RunnerType.MacOS1015.INSTANCE)) {
            string = "macos-10.15";
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string;
    }
}

