/*
 * Decompiled with CFR 0.152.
 */
package it.krzeminski.githubactions.domain.triggers;

import it.krzeminski.githubactions.domain.triggers.Cron;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.CharRange;
import kotlin.ranges.IntRange;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 0}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a8\u0010\u0000\u001a\u00020\u00012\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\u0003\u001a8\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\t2\u0006\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\r2\u0010\b\u0002\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\tH\u0002\u00a8\u0006\u000f"}, d2={"Cron", "Lit/krzeminski/githubactions/domain/triggers/Cron;", "minute", "", "hour", "dayMonth", "month", "dayWeek", "checkCronSyntax", "", "value", "field", "range", "Lkotlin/ranges/IntRange;", "namedValues", "library"})
public final class ScheduleKt {
    @NotNull
    public static final Cron Cron(@NotNull String minute, @NotNull String hour, @NotNull String dayMonth, @NotNull String month, @NotNull String dayWeek) {
        Intrinsics.checkNotNullParameter((Object)minute, (String)"minute");
        Intrinsics.checkNotNullParameter((Object)hour, (String)"hour");
        Intrinsics.checkNotNullParameter((Object)dayMonth, (String)"dayMonth");
        Intrinsics.checkNotNullParameter((Object)month, (String)"month");
        Intrinsics.checkNotNullParameter((Object)dayWeek, (String)"dayWeek");
        Object[] objectArray = new List[5];
        objectArray[0] = ScheduleKt.checkCronSyntax$default(minute, "minute", new IntRange(0, 59), null, 8, null);
        objectArray[1] = ScheduleKt.checkCronSyntax$default(hour, "hour", new IntRange(0, 23), null, 8, null);
        objectArray[2] = ScheduleKt.checkCronSyntax$default(dayMonth, "dayMonth", new IntRange(0, 59), null, 8, null);
        Object[] objectArray2 = new String[]{"JAN", "FEB", "MAR", "APR", "MAY", "JUN", "JUL", "AUG", "SEP", "OCT", "NOV", "DEC"};
        objectArray[3] = ScheduleKt.checkCronSyntax(month, "month", new IntRange(1, 31), CollectionsKt.listOf((Object[])objectArray2));
        objectArray2 = new String[]{"MON", "TUE", "WED", "THU", "FRI", "SAT", "SUN"};
        objectArray[4] = ScheduleKt.checkCronSyntax(dayWeek, "dayWeek", new IntRange(0, 6), CollectionsKt.listOf((Object[])objectArray2));
        List errors = CollectionsKt.flatten((Iterable)CollectionsKt.listOf((Object[])objectArray));
        String cron = minute + " " + hour + " " + dayMonth + " " + month + " " + dayWeek;
        if (!errors.isEmpty()) {
            boolean bl = false;
            String formattedErrors = CollectionsKt.joinToString$default((Iterable)errors, (CharSequence)"\n- ", (CharSequence)"\n- ", null, (int)0, null, null, (int)60, null);
            String string = "Your Cron syntax [" + cron + "] contains errors:" + formattedErrors;
            throw new IllegalStateException(string.toString());
        }
        return new Cron(cron);
    }

    public static /* synthetic */ Cron Cron$default(String string, String string2, String string3, String string4, String string5, int n, Object object) {
        if ((n & 1) != 0) {
            string = "*";
        }
        if ((n & 2) != 0) {
            string2 = "*";
        }
        if ((n & 4) != 0) {
            string3 = "*";
        }
        if ((n & 8) != 0) {
            string4 = "*";
        }
        if ((n & 0x10) != 0) {
            string5 = "*";
        }
        return ScheduleKt.Cron(string, string2, string3, string4, string5);
    }

    private static final List<String> checkCronSyntax(String value, String field, IntRange range, List<String> namedValues) {
        List errors = new ArrayList();
        ScheduleKt.checkCronSyntax$addErrorIf(errors, field, value, "contains invalid characters", (Function0<Boolean>)((Function0)new Function0<Boolean>(value){
            final /* synthetic */ String $value;
            {
                this.$value = $value;
                super(0);
            }

            @NotNull
            public final Boolean invoke() {
                boolean bl;
                block1: {
                    Object[] objectArray = new Character[]{Character.valueOf('-'), Character.valueOf('*'), Character.valueOf(','), Character.valueOf('/')};
                    List allowedCharacters = CollectionsKt.plus((Collection)CollectionsKt.plus((Iterable)((Iterable)new CharRange('0', '9')), (Iterable)CollectionsKt.listOf((Object[])objectArray)), (Iterable)((Iterable)new CharRange('A', 'Z')));
                    CharSequence $this$any$iv = this.$value;
                    boolean $i$f$any = false;
                    for (int i = 0; i < $this$any$iv.length(); ++i) {
                        char element$iv;
                        char it = element$iv = $this$any$iv.charAt(i);
                        boolean bl2 = false;
                        if (!(!allowedCharacters.contains(Character.valueOf(it)))) continue;
                        bl = true;
                        break block1;
                    }
                    bl = false;
                }
                return bl;
            }
        }));
        ScheduleKt.checkCronSyntax$addErrorIf(errors, field, value, "contains value(s) not included in " + namedValues, (Function0<Boolean>)((Function0)new Function0<Boolean>(namedValues, value){
            final /* synthetic */ List<String> $namedValues;
            final /* synthetic */ String $value;
            {
                this.$namedValues = $namedValues;
                this.$value = $value;
                super(0);
            }

            @NotNull
            public final Boolean invoke() {
                boolean bl;
                block7: {
                    List<String> list = this.$namedValues;
                    if (list != null) {
                        String it;
                        Iterable $this$filterTo$iv$iv;
                        Iterable $this$filter$iv;
                        List<String> list2 = list;
                        String string = this.$value;
                        List<String> list3 = this.$namedValues;
                        List<String> it2 = list2;
                        boolean bl2 = false;
                        CharSequence charSequence = string;
                        Object object = new Regex("[-*,/]");
                        String string2 = " ";
                        String replace = object.replace(charSequence, string2);
                        object = new String[]{" "};
                        object = StringsKt.split$default((CharSequence)replace, (String[])object, (boolean)false, (int)0, (int)6, null);
                        boolean $i$f$filter = false;
                        Iterator<T> iterator = $this$filter$iv;
                        Collection destination$iv$iv = new ArrayList<E>();
                        boolean $i$f$filterTo = false;
                        for (T element$iv$iv : $this$filterTo$iv$iv) {
                            it = (String)element$iv$iv;
                            boolean bl3 = false;
                            boolean bl4 = !StringsKt.isBlank((CharSequence)it);
                            if (!bl4) continue;
                            destination$iv$iv.add(element$iv$iv);
                        }
                        $this$filter$iv = (List)destination$iv$iv;
                        $i$f$filter = false;
                        $this$filterTo$iv$iv = $this$filter$iv;
                        destination$iv$iv = new ArrayList<E>();
                        $i$f$filterTo = false;
                        for (T element$iv$iv : $this$filterTo$iv$iv) {
                            it = (String)element$iv$iv;
                            boolean bl5 = false;
                            if (!(StringsKt.toIntOrNull((String)it) == null)) continue;
                            destination$iv$iv.add(element$iv$iv);
                        }
                        List values = (List)destination$iv$iv;
                        Iterable $this$any$iv = values;
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl = false;
                        } else {
                            for (T element$iv : $this$any$iv) {
                                String it3 = (String)element$iv;
                                boolean bl6 = false;
                                if (!(!list3.contains(it3))) continue;
                                bl = true;
                                break block7;
                            }
                            bl = false;
                        }
                    } else {
                        bl = false;
                    }
                }
                return bl;
            }
        }));
        ScheduleKt.checkCronSyntax$addErrorIf(errors, field, value, "contains number(s) outside of range " + range, (Function0<Boolean>)((Function0)new Function0<Boolean>(value, range){
            final /* synthetic */ String $value;
            final /* synthetic */ IntRange $range;
            {
                this.$value = $value;
                this.$range = $range;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Boolean invoke() {
                boolean bl;
                block4: {
                    void $this$any$iv;
                    void $this$mapNotNullTo$iv$iv;
                    CharSequence charSequence = this.$value;
                    String[] stringArray = new Regex("[-*,/]");
                    String string = " ";
                    String replace = stringArray.replace(charSequence, string);
                    stringArray = new String[]{" "};
                    Iterable $this$mapNotNull$iv = StringsKt.split$default((CharSequence)replace, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
                    boolean $i$f$mapNotNull = false;
                    Iterable iterable = $this$mapNotNull$iv;
                    Collection destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$mapNotNullTo = false;
                    void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                    boolean $i$f$forEach = false;
                    Iterator<T> iterator = $this$forEach$iv$iv$iv.iterator();
                    while (iterator.hasNext()) {
                        Integer it$iv$iv;
                        T element$iv$iv$iv;
                        T element$iv$iv = element$iv$iv$iv = iterator.next();
                        boolean bl2 = false;
                        String it = (String)element$iv$iv;
                        boolean bl3 = false;
                        if (StringsKt.toIntOrNull((String)it) == null) continue;
                        boolean bl4 = false;
                        destination$iv$iv.add(it$iv$iv);
                    }
                    List numbers = (List)destination$iv$iv;
                    $this$mapNotNull$iv = numbers;
                    IntRange intRange = this.$range;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (T element$iv : $this$any$iv) {
                            int it = ((Number)element$iv).intValue();
                            boolean bl5 = false;
                            int n = intRange.getFirst();
                            boolean bl6 = it <= intRange.getLast() ? n <= it : false;
                            if (!(!bl6)) continue;
                            bl = true;
                            break block4;
                        }
                        bl = false;
                    }
                }
                return bl;
            }
        }));
        ScheduleKt.checkCronSyntax$addErrorIf(errors, field, value, "is blank", (Function0<Boolean>)((Function0)new Function0<Boolean>(value){
            final /* synthetic */ String $value;
            {
                this.$value = $value;
                super(0);
            }

            @NotNull
            public final Boolean invoke() {
                return StringsKt.isBlank((CharSequence)this.$value);
            }
        }));
        return errors;
    }

    static /* synthetic */ List checkCronSyntax$default(String string, String string2, IntRange intRange, List list, int n, Object object) {
        if ((n & 8) != 0) {
            list = null;
        }
        return ScheduleKt.checkCronSyntax(string, string2, intRange, list);
    }

    private static final void checkCronSyntax$addErrorIf(List<String> errors, String $field, String $value, String message, Function0<Boolean> predicate) {
        if (((Boolean)predicate.invoke()).booleanValue()) {
            ((Collection)errors).add("Field '" + $field + "' with value [" + $value + "] " + message);
        }
    }
}

