/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.security;

import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Properties;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.CreateDelegationTokenOptions;
import org.apache.kafka.clients.admin.CreateDelegationTokenResult;
import org.apache.kafka.common.security.JaasContext;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.security.token.delegation.DelegationToken;
import org.apache.kafka.common.security.token.delegation.TokenInformation;
import org.apache.spark.SparkConf;
import org.apache.spark.deploy.SparkHadoopUtil$;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.config.ConfigEntry;
import org.apache.spark.internal.config.Kafka$;
import org.apache.spark.internal.config.package$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.control.NonFatal$;

public final class KafkaTokenUtil$
implements Logging {
    public static final KafkaTokenUtil$ MODULE$;
    private final Text TOKEN_KIND;
    private final Text TOKEN_SERVICE;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new KafkaTokenUtil$();
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.class.initializeLogIfNecessary$default$2((Logging)this);
    }

    public Text TOKEN_KIND() {
        return this.TOKEN_KIND;
    }

    public Text TOKEN_SERVICE() {
        return this.TOKEN_SERVICE;
    }

    public Tuple2<Token<? extends TokenIdentifier>, Object> obtainToken(SparkConf sparkConf) {
        this.checkProxyUser();
        AdminClient adminClient = AdminClient.create((Properties)this.createAdminClientProperties(sparkConf));
        CreateDelegationTokenOptions createDelegationTokenOptions = new CreateDelegationTokenOptions();
        CreateDelegationTokenResult createResult = adminClient.createDelegationToken(createDelegationTokenOptions);
        DelegationToken token = (DelegationToken)createResult.delegationToken().get();
        this.printToken(token);
        return new Tuple2((Object)new Token(token.tokenInfo().tokenId().getBytes(), token.hmacAsBase64String().getBytes(), this.TOKEN_KIND(), this.TOKEN_SERVICE()), (Object)BoxesRunTime.boxToLong((long)token.tokenInfo().expiryTimestamp()));
    }

    public void checkProxyUser() {
        UserGroupInformation currentUser = UserGroupInformation.getCurrentUser();
        Predef$.MODULE$.require(!SparkHadoopUtil$.MODULE$.get().isProxyUser(currentUser), (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Obtaining delegation token for proxy user is not yet supported.";
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public Properties createAdminClientProperties(SparkConf sparkConf) {
        String string;
        block10: {
            void var2_2;
            Object object;
            Properties adminClientProperties;
            block8: {
                block9: {
                    block7: {
                        adminClientProperties = new Properties();
                        Option bootstrapServers = (Option)sparkConf.get(Kafka$.MODULE$.BOOTSTRAP_SERVERS());
                        Predef$.MODULE$.require(bootstrapServers.nonEmpty(), (Function0)new Serializable(){
                            public static final long serialVersionUID = 0L;

                            public final String apply() {
                                return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Tried to obtain kafka delegation token but bootstrap "})).s((Seq)Nil$.MODULE$)).append((Object)"servers not configured.").toString();
                            }
                        });
                        adminClientProperties.put("bootstrap.servers", bootstrapServers.get());
                        String protocol = (String)sparkConf.get(Kafka$.MODULE$.SECURITY_PROTOCOL());
                        adminClientProperties.put("security.protocol", protocol);
                        string = protocol;
                        String string2 = SecurityProtocol.SASL_SSL.name;
                        String string3 = string;
                        if (string2 != null ? !string2.equals(string3) : string3 != null) break block7;
                        this.setTrustStoreProperties(sparkConf, adminClientProperties);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break block8;
                    }
                    String string4 = SecurityProtocol.SSL.name;
                    String string5 = string;
                    if (string4 != null ? !string4.equals(string5) : string5 != null) break block9;
                    this.setTrustStoreProperties(sparkConf, adminClientProperties);
                    this.setKeyStoreProperties(sparkConf, adminClientProperties);
                    this.logWarning((Function0<String>)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "Obtaining kafka delegation token with SSL protocol. Please configure 2-way authentication on the broker side.";
                        }
                    });
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block8;
                }
                String string6 = SecurityProtocol.SASL_PLAINTEXT.name;
                String string7 = string;
                if (string6 != null ? !string6.equals(string7) : string7 != null) break block10;
                this.logWarning((Function0<String>)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Obtaining kafka delegation token through plain communication channel. Please consider the security impact.";
                    }
                });
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            if (this.isGlobalJaasConfigurationProvided()) {
                this.logDebug((Function0<String>)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "JVM global security configuration detected, using it for login.";
                    }
                });
                object = BoxedUnit.UNIT;
            } else {
                adminClientProperties.put("sasl.mechanism", "GSSAPI");
                if (sparkConf.contains((ConfigEntry)package$.MODULE$.KEYTAB())) {
                    this.logDebug((Function0<String>)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "Keytab detected, using it for login.";
                        }
                    });
                    String jaasParams = this.getKeytabJaasParams(sparkConf);
                    object = adminClientProperties.put("sasl.jaas.config", jaasParams);
                } else {
                    this.logDebug((Function0<String>)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "Using ticket cache for login.";
                        }
                    });
                    String jaasParams = this.getTicketCacheJaasParams(sparkConf);
                    object = adminClientProperties.put("sasl.jaas.config", jaasParams);
                }
            }
            return var2_2;
        }
        throw new MatchError((Object)string);
    }

    public boolean isGlobalJaasConfigurationProvided() {
        boolean bl;
        try {
            JaasContext.loadClientContext(Collections.emptyMap());
            bl = true;
        }
        catch (Throwable throwable) {
            boolean bl2;
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            bl = bl2 = false;
        }
        return bl;
    }

    private void setTrustStoreProperties(SparkConf sparkConf, Properties properties) {
        ((Option)sparkConf.get(Kafka$.MODULE$.TRUSTSTORE_LOCATION())).foreach((Function1)new Serializable(properties){
            public static final long serialVersionUID = 0L;
            private final Properties properties$1;

            public final Object apply(String truststoreLocation) {
                return this.properties$1.put("ssl.truststore.location", truststoreLocation);
            }
            {
                this.properties$1 = properties$1;
            }
        });
        ((Option)sparkConf.get(Kafka$.MODULE$.TRUSTSTORE_PASSWORD())).foreach((Function1)new Serializable(properties){
            public static final long serialVersionUID = 0L;
            private final Properties properties$1;

            public final Object apply(String truststorePassword) {
                return this.properties$1.put("ssl.truststore.password", truststorePassword);
            }
            {
                this.properties$1 = properties$1;
            }
        });
    }

    private void setKeyStoreProperties(SparkConf sparkConf, Properties properties) {
        ((Option)sparkConf.get(Kafka$.MODULE$.KEYSTORE_LOCATION())).foreach((Function1)new Serializable(properties){
            public static final long serialVersionUID = 0L;
            private final Properties properties$2;

            public final Object apply(String keystoreLocation) {
                return this.properties$2.put("ssl.keystore.location", keystoreLocation);
            }
            {
                this.properties$2 = properties$2;
            }
        });
        ((Option)sparkConf.get(Kafka$.MODULE$.KEYSTORE_PASSWORD())).foreach((Function1)new Serializable(properties){
            public static final long serialVersionUID = 0L;
            private final Properties properties$2;

            public final Object apply(String keystorePassword) {
                return this.properties$2.put("ssl.keystore.password", keystorePassword);
            }
            {
                this.properties$2 = properties$2;
            }
        });
        ((Option)sparkConf.get(Kafka$.MODULE$.KEY_PASSWORD())).foreach((Function1)new Serializable(properties){
            public static final long serialVersionUID = 0L;
            private final Properties properties$2;

            public final Object apply(String keyPassword) {
                return this.properties$2.put("ssl.key.password", keyPassword);
            }
            {
                this.properties$2 = properties$2;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public String getKeytabJaasParams(SparkConf sparkConf) {
        void var2_2;
        String params = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n      |", " required\n      | useKeyTab=true\n      | serviceName=\"", "\"\n      | keyTab=\"", "\"\n      | principal=\"", "\";\n      "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.getKrb5LoginModuleName(), sparkConf.get(Kafka$.MODULE$.KERBEROS_SERVICE_NAME()), ((Option)sparkConf.get((ConfigEntry)package$.MODULE$.KEYTAB())).get(), ((Option)sparkConf.get((ConfigEntry)package$.MODULE$.PRINCIPAL())).get()})))).stripMargin().replace("\n", "");
        this.logDebug((Function0<String>)new Serializable(params){
            public static final long serialVersionUID = 0L;
            private final String params$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Krb keytab JAAS params: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.params$1}));
            }
            {
                this.params$1 = params$1;
            }
        });
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public String getTicketCacheJaasParams(SparkConf sparkConf) {
        void var3_3;
        String serviceName = (String)sparkConf.get(Kafka$.MODULE$.KERBEROS_SERVICE_NAME());
        Predef$.MODULE$.require(new StringOps(Predef$.MODULE$.augmentString(serviceName)).nonEmpty(), (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Kerberos service name must be defined";
            }
        });
        String params = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n      |", " required\n      | useTicketCache=true\n      | serviceName=\"", "\";\n      "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.getKrb5LoginModuleName(), sparkConf.get(Kafka$.MODULE$.KERBEROS_SERVICE_NAME())})))).stripMargin().replace("\n", "");
        this.logDebug((Function0<String>)new Serializable(params){
            public static final long serialVersionUID = 0L;
            private final String params$2;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Krb ticket cache JAAS params: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.params$2}));
            }
            {
                this.params$2 = params$2;
            }
        });
        return var3_3;
    }

    private String getKrb5LoginModuleName() {
        return System.getProperty("java.vendor").contains("IBM") ? "com.ibm.security.auth.module.Krb5LoginModule" : "com.sun.security.auth.module.Krb5LoginModule";
    }

    private void printToken(DelegationToken token) {
        if (this.log().isDebugEnabled()) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm");
            this.logDebug((Function0<String>)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("%-15s %-30s %-15s %-25s %-15s %-15s %-15s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"TOKENID", "HMAC", "OWNER", "RENEWERS", "ISSUEDATE", "EXPIRYDATE", "MAXDATE"}));
                }
            });
            TokenInformation tokenInfo = token.tokenInfo();
            this.logDebug((Function0<String>)new Serializable(dateFormat, tokenInfo){
                public static final long serialVersionUID = 0L;
                private final SimpleDateFormat dateFormat$1;
                private final TokenInformation tokenInfo$1;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("%-15s [hidden] %-15s %-25s %-15s %-15s %-15s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.tokenInfo$1.tokenId(), this.tokenInfo$1.owner(), this.tokenInfo$1.renewersAsString(), this.dateFormat$1.format(BoxesRunTime.boxToLong((long)this.tokenInfo$1.issueTimestamp())), this.dateFormat$1.format(BoxesRunTime.boxToLong((long)this.tokenInfo$1.expiryTimestamp())), this.dateFormat$1.format(BoxesRunTime.boxToLong((long)this.tokenInfo$1.maxTimestamp()))}));
                }
                {
                    this.dateFormat$1 = dateFormat$1;
                    this.tokenInfo$1 = tokenInfo$1;
                }
            });
        }
    }

    private KafkaTokenUtil$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
        this.TOKEN_KIND = new Text("KAFKA_DELEGATION_TOKEN");
        this.TOKEN_SERVICE = new Text("kafka.server.delegation.token");
    }
}

