/*
 * Decompiled with CFR 0.152.
 */
package it.agilelab.bigdata.wasp.consumers.spark.plugins.kafka;

import com.typesafe.config.Config;
import it.agilelab.bigdata.wasp.consumers.spark.plugins.kafka.KafkaTopicSettings;
import it.agilelab.bigdata.wasp.consumers.spark.plugins.kafka.TopicModelUtils;
import it.agilelab.bigdata.wasp.consumers.spark.plugins.kafka.TopicModelUtils$;
import it.agilelab.bigdata.wasp.consumers.spark.plugins.kafka.TopicModelUtils$$anonfun$checkForStructuredDataType$3$;
import it.agilelab.bigdata.wasp.consumers.spark.plugins.kafka.TopicModelUtils$$anonfun$checkTopicModelHasCoherentFields$1$;
import it.agilelab.bigdata.wasp.consumers.spark.plugins.kafka.TopicModelUtils$$anonfun$it$agilelab$bigdata$wasp$consumers$spark$plugins$kafka$TopicModelUtils$;
import it.agilelab.bigdata.wasp.core.WaspSystem$;
import it.agilelab.bigdata.wasp.core.kafka.CheckOrCreateTopic;
import it.agilelab.bigdata.wasp.core.logging.Logging;
import it.agilelab.bigdata.wasp.core.logging.WaspLogger;
import it.agilelab.bigdata.wasp.core.utils.ConfigManager$;
import it.agilelab.bigdata.wasp.models.DatastoreModel;
import it.agilelab.bigdata.wasp.models.MultiTopicModel;
import it.agilelab.bigdata.wasp.models.MultiTopicModel$;
import it.agilelab.bigdata.wasp.models.TopicDataTypes$;
import it.agilelab.bigdata.wasp.models.TopicModel;
import it.agilelab.bigdata.wasp.models.configuration.TinyKafkaConfig;
import it.agilelab.bigdata.wasp.repository.core.bl.TopicBL;
import it.agilelab.bigdata.wasp.utils.EitherUtils;
import it.agilelab.bigdata.wasp.utils.EitherUtils$;
import org.apache.avro.Schema;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.StringBuilder;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class TopicModelUtils$
implements Logging {
    public static final TopicModelUtils$ MODULE$;
    private final WaspLogger logger;

    static {
        new TopicModelUtils$();
    }

    public WaspLogger logger() {
        return this.logger;
    }

    public void it$agilelab$bigdata$wasp$core$logging$Logging$_setter_$logger_$eq(WaspLogger x$1) {
        this.logger = x$1;
    }

    public void askToCheckOrCreateTopics(Seq<TopicModel> topics) {
        this.logger().info((Function0)new Serializable(topics){
            public static final long serialVersionUID = 0L;
            private final Seq topics$2;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Creating topics ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topics$2}));
            }
            {
                this.topics$2 = topics$2;
            }
        });
        topics.foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(TopicModel topic) {
                if (BoxesRunTime.unboxToBoolean((Object)WaspSystem$.MODULE$.$qmark$qmark(WaspSystem$.MODULE$.kafkaAdminActor(), (Object)new CheckOrCreateTopic(topic.name(), topic.partitions(), topic.replicas()), WaspSystem$.MODULE$.$qmark$qmark$default$3()))) {
                    return;
                }
                throw new Exception(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error creating topic \"", "\""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic.name()})));
            }
        });
    }

    public TopicModelUtils.FieldNameAndTopicModels retrieveTopicFieldNameAndTopicModels(DatastoreModel dsModel, TopicBL topicBL, String topicDatastoreModelName) {
        DatastoreModel datastoreModel;
        block4: {
            Product product;
            block3: {
                block2: {
                    datastoreModel = dsModel;
                    if (!(datastoreModel instanceof TopicModel)) break block2;
                    TopicModel topicModel = (TopicModel)datastoreModel;
                    product = new TopicModelUtils.SingleTopic(topicModel);
                    break block3;
                }
                if (!(datastoreModel instanceof MultiTopicModel)) break block4;
                MultiTopicModel multiTopicModel = (MultiTopicModel)datastoreModel;
                Seq topics = (Seq)((TraversableLike)multiTopicModel.topicModelNames().map((Function1)new Serializable(topicBL){
                    public static final long serialVersionUID = 0L;
                    private final TopicBL topicBL$1;

                    public final Option<DatastoreModel> apply(String name) {
                        return this.topicBL$1.getByName(name);
                    }
                    {
                        this.topicBL$1 = topicBL$1;
                    }
                }, Seq$.MODULE$.canBuildFrom())).flatMap((Function1)new Serializable(topicDatastoreModelName){
                    public static final long serialVersionUID = 0L;
                    private final String topicDatastoreModelName$2;

                    public final Seq<TopicModel> apply(Option<DatastoreModel> x0$1) {
                        Some some;
                        DatastoreModel topicModel;
                        Option<DatastoreModel> option = x0$1;
                        if (option instanceof Some && (topicModel = (DatastoreModel)(some = (Some)option).x()) instanceof TopicModel) {
                            TopicModel topicModel2 = (TopicModel)topicModel;
                            Seq seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicModel[]{topicModel2}));
                            return seq;
                        }
                        throw new Exception(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unable to retrieve topic datastore model with name \"", "\""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicDatastoreModelName$2})));
                    }
                    {
                        this.topicDatastoreModelName$2 = topicDatastoreModelName$2;
                    }
                }, Seq$.MODULE$.canBuildFrom());
                product = new TopicModelUtils.MultiTopic(multiTopicModel.topicNameField(), (Seq<TopicModel>)topics);
            }
            return product;
        }
        throw new Exception(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Datastore model ", " is not compatible with Kafka"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{datastoreModel})));
    }

    public KafkaTopicSettings retrieveKafkaTopicSettings(TopicBL topicBL, String topicDatastoreModelName) {
        TopicModelUtils.FieldNameAndTopicModels fieldNameAndTopicModels;
        block4: {
            KafkaTopicSettings kafkaTopicSettings;
            block3: {
                DatastoreModel mainTopicModel;
                TinyKafkaConfig tinyKafkaConfig;
                block2: {
                    tinyKafkaConfig = ConfigManager$.MODULE$.getKafkaConfig().toTinyConfig();
                    mainTopicModel = (DatastoreModel)topicBL.getByName(topicDatastoreModelName).getOrElse((Function0)new Serializable(topicDatastoreModelName){
                        public static final long serialVersionUID = 0L;
                        private final String topicDatastoreModelName$1;

                        public final Nothing$ apply() {
                            throw new Exception(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unable to retrieve topic datastore model with name \"", "\""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicDatastoreModelName$1})));
                        }
                        {
                            this.topicDatastoreModelName$1 = topicDatastoreModelName$1;
                        }
                    });
                    TopicModelUtils.FieldNameAndTopicModels topicFieldNameAndTopics = this.retrieveTopicFieldNameAndTopicModels(mainTopicModel, topicBL, topicDatastoreModelName);
                    fieldNameAndTopicModels = topicFieldNameAndTopics;
                    if (!(fieldNameAndTopicModels instanceof TopicModelUtils.SingleTopic)) break block2;
                    TopicModelUtils.SingleTopic singleTopic = (TopicModelUtils.SingleTopic)fieldNameAndTopicModels;
                    TopicModel t = singleTopic.t();
                    this.askToCheckOrCreateTopics((Seq<TopicModel>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicModel[]{t}))));
                    None$ darwinConf = t.useAvroSchemaManager() ? new Some((Object)ConfigManager$.MODULE$.getAvroSchemaManagerConfig()) : None$.MODULE$;
                    kafkaTopicSettings = new KafkaTopicSettings(tinyKafkaConfig, mainTopicModel, (Option<String>)None$.MODULE$, (Seq<TopicModel>)((Seq)Seq$.MODULE$.empty()), (Option<Config>)darwinConf);
                    break block3;
                }
                if (!(fieldNameAndTopicModels instanceof TopicModelUtils.MultiTopic)) break block4;
                TopicModelUtils.MultiTopic multiTopic = (TopicModelUtils.MultiTopic)fieldNameAndTopicModels;
                String topicFieldName = multiTopic.topicFieldName();
                Seq<TopicModel> topics = multiTopic.topics();
                this.askToCheckOrCreateTopics(topics);
                None$ darwinConf = topics.exists((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(TopicModel x$1) {
                        return x$1.useAvroSchemaManager();
                    }
                }) ? new Some((Object)ConfigManager$.MODULE$.getAvroSchemaManagerConfig()) : None$.MODULE$;
                kafkaTopicSettings = new KafkaTopicSettings(tinyKafkaConfig, mainTopicModel, (Option<String>)new Some((Object)topicFieldName), topics, (Option<Config>)darwinConf);
            }
            return kafkaTopicSettings;
        }
        throw new MatchError((Object)fieldNameAndTopicModels);
    }

    public String topicNameToColumnName(String s) {
        return new StringOps(Predef$.MODULE$.augmentString(new StringOps(Predef$.MODULE$.augmentString(s)).replaceAllLiterally(".", "_"))).replaceAllLiterally("-", "_");
    }

    public Either<String, BoxedUnit> areTopicsEqualForReading(Seq<TopicModel> models) {
        return EitherUtils.RightBiasedEither$.MODULE$.flatMap$extension(EitherUtils$.MODULE$.RightBiasedEither(MultiTopicModel$.MODULE$.areTopicsHealthy(models)), (Function1)new Serializable(models){
            public static final long serialVersionUID = 0L;
            public final Seq models$1;

            public final Either<String, BoxedUnit> apply(BoxedUnit _) {
                return EitherUtils.RightBiasedEither$.MODULE$.flatMap$extension(EitherUtils$.MODULE$.RightBiasedEither(package$.MODULE$.Either().cond(((SeqLike)((SeqLike)this.models$1.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(TopicModel x$2) {
                        return x$2.topicDataType();
                    }
                }, Seq$.MODULE$.canBuildFrom())).distinct()).length() == 1, (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                    }
                }, (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "All topic models must have the same topic data type";
                    }
                })), (Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.areTopicsEqualForReading.1 $outer;

                    public final Either<String, BoxedUnit> apply(BoxedUnit _) {
                        return EitherUtils.RightBiasedEither$.MODULE$.map$extension(EitherUtils$.MODULE$.RightBiasedEither(package$.MODULE$.Either().cond(((SeqLike)((SeqLike)this.$outer.models$1.map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final String apply(TopicModel x$3) {
                                return x$3.getJsonSchema();
                            }
                        }, Seq$.MODULE$.canBuildFrom())).distinct()).size() == 1, (Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final void apply() {
                                this.apply$mcV$sp();
                            }

                            public void apply$mcV$sp() {
                            }
                        }, (Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final String apply() {
                                return "All topic models must have the same schema";
                            }
                        })), (Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final void apply(BoxedUnit r) {
                            }
                        });
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.models$1 = models$1;
            }
        });
    }

    public Either<String, BoxedUnit> isTopicWritable(DatastoreModel mainTopicModel, Seq<TopicModel> multiTopicModels, Dataset<Row> df) {
        Either either;
        DatastoreModel datastoreModel = mainTopicModel;
        if (datastoreModel instanceof MultiTopicModel) {
            MultiTopicModel multiTopicModel = (MultiTopicModel)datastoreModel;
            either = EitherUtils.RightBiasedEither$.MODULE$.flatMap$extension(EitherUtils$.MODULE$.RightBiasedEither(package$.MODULE$.Either().cond(multiTopicModels.nonEmpty(), (Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final void apply() {
                    this.apply$mcV$sp();
                }

                public void apply$mcV$sp() {
                }
            }, (Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Multi topic needs inner multiTopicModels";
                }
            })), (Function1)new Serializable(multiTopicModels, df, multiTopicModel){
                public static final long serialVersionUID = 0L;
                public final Seq multiTopicModels$1;
                public final Dataset df$1;
                public final MultiTopicModel x2$1;

                public final Either<String, BoxedUnit> apply(BoxedUnit _) {
                    return EitherUtils.RightBiasedEither$.MODULE$.flatMap$extension(EitherUtils$.MODULE$.RightBiasedEither(EitherUtils$.MODULE$.traverse((List)this.multiTopicModels$1.toList().map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.isTopicWritable.4 $outer;

                        public final Either<String, List<Column>> apply(TopicModel t) {
                            return TopicModelUtils$.MODULE$.checkTopicModelHasCoherentFields(t, (Dataset<Row>)this.$outer.df$1, (Option<String>)new Some((Object)this.$outer.x2$1.topicNameField()));
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    }, List$.MODULE$.canBuildFrom()))), (Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.isTopicWritable.4 $outer;

                        public final Either<String, BoxedUnit> apply(List<List<Column>> _) {
                            return EitherUtils.RightBiasedEither$.MODULE$.map$extension(EitherUtils$.MODULE$.RightBiasedEither(MultiTopicModel$.MODULE$.areTopicsHealthy(this.$outer.multiTopicModels$1)), (Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final void apply(BoxedUnit _) {
                                }
                            });
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    });
                }
                {
                    this.multiTopicModels$1 = multiTopicModels$1;
                    this.df$1 = df$1;
                    this.x2$1 = x2$1;
                }
            });
        } else if (datastoreModel instanceof TopicModel) {
            TopicModel topicModel = (TopicModel)datastoreModel;
            either = EitherUtils.RightBiasedEither$.MODULE$.flatMap$extension(EitherUtils$.MODULE$.RightBiasedEither(package$.MODULE$.Either().cond(multiTopicModels.isEmpty(), (Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final void apply() {
                    this.apply$mcV$sp();
                }

                public void apply$mcV$sp() {
                }
            }, (Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Single topic should not have multiTopicModels";
                }
            })), (Function1)new Serializable(df, topicModel){
                public static final long serialVersionUID = 0L;
                private final Dataset df$1;
                public final TopicModel x3$1;

                public final Either<String, BoxedUnit> apply(BoxedUnit _) {
                    return EitherUtils.RightBiasedEither$.MODULE$.flatMap$extension(EitherUtils$.MODULE$.RightBiasedEither(TopicModelUtils$.MODULE$.checkTopicModelHasCoherentFields(this.x3$1, (Dataset<Row>)this.df$1, (Option<String>)None$.MODULE$)), (Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.isTopicWritable.6 $outer;

                        public final Either<String, BoxedUnit> apply(List<Column> _) {
                            return EitherUtils.RightBiasedEither$.MODULE$.map$extension(EitherUtils$.MODULE$.RightBiasedEither(MultiTopicModel$.MODULE$.areTopicsHealthy((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicModel[]{this.$outer.x3$1})))), (Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final void apply(BoxedUnit _) {
                                }
                            });
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    });
                }
                {
                    this.df$1 = df$1;
                    this.x3$1 = x3$1;
                }
            });
        } else {
            either = package$.MODULE$.Left().apply((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " is not a topic model"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{datastoreModel.name()})));
        }
        return either;
    }

    public Either<String, List<Column>> checkTopicModelHasCoherentFields(TopicModel topic, Dataset<Row> df, Option<String> topicColumn) {
        Option<String> option;
        block11: {
            Option option2;
            block14: {
                Option option3;
                block17: {
                    Object object;
                    Right right;
                    Right headerColumnName;
                    Right topicColumnName;
                    block16: {
                        block15: {
                            Right right2;
                            block13: {
                                block12: {
                                    Right right3;
                                    block10: {
                                        block9: {
                                            option = topicColumn;
                                            if (!(option instanceof Some)) break block9;
                                            Some some = (Some)option;
                                            String tColumn = (String)some.x();
                                            right3 = EitherUtils.RightBiasedEither$.MODULE$.map$extension(EitherUtils$.MODULE$.RightBiasedEither(EitherUtils$.MODULE$.catchNonFatal((Function0)new Serializable(df, tColumn){
                                                public static final long serialVersionUID = 0L;
                                                private final Dataset df$2;
                                                private final String tColumn$1;

                                                public final Column apply() {
                                                    return this.df$2.apply(this.tColumn$1);
                                                }
                                                {
                                                    this.df$2 = df$2;
                                                    this.tColumn$1 = tColumn$1;
                                                }
                                            }).left().map((Function1)new Serializable(topic, tColumn){
                                                public static final long serialVersionUID = 0L;
                                                private final TopicModel topic$1;
                                                private final String tColumn$1;

                                                public final String apply(Throwable t) {
                                                    return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected column named `", "` for topic ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.tColumn$1, this.topic$1.name()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"to be used as topic, but found None: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{t.getMessage()}))).toString();
                                                }
                                                {
                                                    this.topic$1 = topic$1;
                                                    this.tColumn$1 = tColumn$1;
                                                }
                                            })), (Function1)new Serializable(){
                                                public static final long serialVersionUID = 0L;

                                                public final void apply(Column x$4) {
                                                }
                                            });
                                            break block10;
                                        }
                                        if (!None$.MODULE$.equals(option)) break block11;
                                        right3 = package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT);
                                    }
                                    topicColumnName = right3;
                                    option2 = topic.headersFieldName();
                                    if (!(option2 instanceof Some)) break block12;
                                    Some some = (Some)option2;
                                    String c = (String)some.x();
                                    right2 = EitherUtils.RightBiasedEither$.MODULE$.map$extension(EitherUtils$.MODULE$.RightBiasedEither(EitherUtils$.MODULE$.catchNonFatal((Function0)new Serializable(df, c){
                                        public static final long serialVersionUID = 0L;
                                        private final Dataset df$2;
                                        private final String c$1;

                                        public final Column apply() {
                                            return this.df$2.apply(this.c$1);
                                        }
                                        {
                                            this.df$2 = df$2;
                                            this.c$1 = c$1;
                                        }
                                    }).left().map((Function1)new Serializable(topic, c){
                                        public static final long serialVersionUID = 0L;
                                        private final TopicModel topic$1;
                                        private final String c$1;

                                        public final String apply(Throwable t) {
                                            return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected column named `", "` for topic ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.c$1, this.topic$1.name()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"to be used as header, but found None: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{t.getMessage()}))).toString();
                                        }
                                        {
                                            this.topic$1 = topic$1;
                                            this.c$1 = c$1;
                                        }
                                    })), (Function1)new Serializable(){
                                        public static final long serialVersionUID = 0L;

                                        public final void apply(Column x$5) {
                                        }
                                    });
                                    break block13;
                                }
                                if (!None$.MODULE$.equals(option2)) break block14;
                                right2 = package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT);
                            }
                            headerColumnName = right2;
                            option3 = topic.keyFieldName();
                            if (!(option3 instanceof Some)) break block15;
                            Some some = (Some)option3;
                            String c = (String)some.x();
                            right = EitherUtils.RightBiasedEither$.MODULE$.map$extension(EitherUtils$.MODULE$.RightBiasedEither(EitherUtils$.MODULE$.catchNonFatal((Function0)new Serializable(df, c){
                                public static final long serialVersionUID = 0L;
                                private final Dataset df$2;
                                private final String c$2;

                                public final Column apply() {
                                    return this.df$2.apply(this.c$2);
                                }
                                {
                                    this.df$2 = df$2;
                                    this.c$2 = c$2;
                                }
                            }).left().map((Function1)new Serializable(topic, c){
                                public static final long serialVersionUID = 0L;
                                private final TopicModel topic$1;
                                private final String c$2;

                                public final String apply(Throwable t) {
                                    return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected column named `", "` for topic ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.c$2, this.topic$1.name()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"to be used as key, but found None: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{t.getMessage()}))).toString();
                                }
                                {
                                    this.topic$1 = topic$1;
                                    this.c$2 = c$2;
                                }
                            })), (Function1)new Serializable(){
                                public static final long serialVersionUID = 0L;

                                public final void apply(Column x$6) {
                                }
                            });
                            break block16;
                        }
                        if (!None$.MODULE$.equals(option3)) break block17;
                        right = package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT);
                    }
                    Right keyColumnName = right;
                    String string = topic.topicDataType();
                    String string2 = TopicDataTypes$.MODULE$.AVRO();
                    String string3 = string;
                    if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                        object = EitherUtils.RightBiasedEither$.MODULE$.flatMap$extension(EitherUtils$.MODULE$.RightBiasedEither(this.checkForStructuredDataType(topic, df, topicColumn)), (Function1)new Serializable(topic){
                            public static final long serialVersionUID = 0L;
                            public final TopicModel topic$1;

                            public final Either<String, List<Column>> apply(List<Column> step1) {
                                return EitherUtils.RightBiasedEither$.MODULE$.map$extension(EitherUtils$.MODULE$.RightBiasedEither(package$.MODULE$.Either().cond(!this.topic$1.schema().isEmpty(), (Function0)new Serializable(this, step1){
                                    public static final long serialVersionUID = 0L;
                                    private final List step1$1;

                                    public final List<Column> apply() {
                                        return this.step1$1;
                                    }
                                    {
                                        this.step1$1 = step1$1;
                                    }
                                }, (Function0)new Serializable(this){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ anonfun.14 $outer;

                                    public final String apply() {
                                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Topic ", " datatype is avro therefore the schema should be mandatory"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.topic$1.name()}));
                                    }
                                    {
                                        if ($outer == null) {
                                            throw null;
                                        }
                                        this.$outer = $outer;
                                    }
                                })), (Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final List<Column> apply(List<Column> step2) {
                                        return step2;
                                    }
                                });
                            }
                            {
                                this.topic$1 = topic$1;
                            }
                        });
                    } else {
                        String string4 = TopicDataTypes$.MODULE$.JSON();
                        String string5 = string;
                        if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                            object = this.checkForStructuredDataType(topic, df, topicColumn);
                        } else {
                            boolean bl;
                            String string6 = TopicDataTypes$.MODULE$.BINARY();
                            String string7 = string;
                            if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
                                bl = true;
                            } else {
                                String string8 = TopicDataTypes$.MODULE$.PLAINTEXT();
                                String string9 = string;
                                bl = !(string8 != null ? !string8.equals(string9) : string9 != null);
                            }
                            object = bl ? this.checkForPrimitiveDataType(topic, df, topicColumn) : package$.MODULE$.Left().apply((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unknown datatype ", " for topic ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{string, topic.name()})));
                        }
                    }
                    Left fieldNames = object;
                    return EitherUtils.RightBiasedEither$.MODULE$.flatMap$extension(EitherUtils$.MODULE$.RightBiasedEither((Either)topicColumnName), (Function1)new Serializable((Either)headerColumnName, (Either)keyColumnName, (Either)fieldNames){
                        public static final long serialVersionUID = 0L;
                        private final Either headerColumnName$1;
                        public final Either keyColumnName$1;
                        public final Either fieldNames$1;

                        public final Either<String, List<Column>> apply(BoxedUnit _) {
                            return EitherUtils.RightBiasedEither$.MODULE$.flatMap$extension(EitherUtils$.MODULE$.RightBiasedEither(this.headerColumnName$1), (Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ anonfun.checkTopicModelHasCoherentFields.1 $outer;

                                public final Either<String, List<Column>> apply(BoxedUnit _) {
                                    return EitherUtils.RightBiasedEither$.MODULE$.flatMap$extension(EitherUtils$.MODULE$.RightBiasedEither(this.$outer.keyColumnName$1), (Function1)new Serializable(this){
                                        public static final long serialVersionUID = 0L;
                                        private final /* synthetic */ anonfun$checkTopicModelHasCoherentFields$1$$anonfun$apply$17 $outer;

                                        public final Either<String, List<Column>> apply(BoxedUnit _) {
                                            return EitherUtils.RightBiasedEither$.MODULE$.map$extension(EitherUtils$.MODULE$.RightBiasedEither(this.$outer.it$agilelab$bigdata$wasp$consumers$spark$plugins$kafka$TopicModelUtils$$anonfun$$anonfun$$$outer().fieldNames$1), (Function1)new Serializable(this){
                                                public static final long serialVersionUID = 0L;

                                                public final List<Column> apply(List<Column> out) {
                                                    return out;
                                                }
                                            });
                                        }
                                        {
                                            if ($outer == null) {
                                                throw null;
                                            }
                                            this.$outer = $outer;
                                        }
                                    });
                                }

                                public /* synthetic */ anonfun.checkTopicModelHasCoherentFields.1 it$agilelab$bigdata$wasp$consumers$spark$plugins$kafka$TopicModelUtils$$anonfun$$anonfun$$$outer() {
                                    return this.$outer;
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                }
                            });
                        }
                        {
                            this.headerColumnName$1 = headerColumnName$1;
                            this.keyColumnName$1 = keyColumnName$1;
                            this.fieldNames$1 = fieldNames$1;
                        }
                    });
                }
                throw new MatchError((Object)option3);
            }
            throw new MatchError((Object)option2);
        }
        throw new MatchError(option);
    }

    public Option<List<String>> getAllValueFieldsFromSchema(TopicModel topicModel) {
        None$ none$;
        boolean bl;
        String string = topicModel.topicDataType();
        String string2 = TopicDataTypes$.MODULE$.AVRO();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            bl = true;
        } else {
            String string4 = TopicDataTypes$.MODULE$.JSON();
            String string5 = string;
            bl = !(string4 != null ? !string4.equals(string5) : string5 != null);
        }
        if (bl) {
            None$ none$2;
            if (topicModel.schema().isEmpty()) {
                none$2 = None$.MODULE$;
            } else {
                Schema avroSchema = new Schema.Parser().parse(topicModel.getJsonSchema());
                none$2 = new Some((Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(avroSchema.getFields()).asScala()).map((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final String apply(Schema.Field x$7) {
                        return x$7.name();
                    }
                }, Buffer$.MODULE$.canBuildFrom())).toList());
            }
            none$ = none$2;
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    private Either<String, List<Column>> checkForPrimitiveDataType(TopicModel topic, Dataset<Row> dfWTopicColumn, Option<String> topicColumn) {
        Option option;
        block5: {
            Either either;
            block3: {
                block4: {
                    Some some;
                    boolean bl;
                    block2: {
                        bl = false;
                        some = null;
                        option = topic.valueFieldsNames();
                        if (!(option instanceof Some)) break block2;
                        bl = true;
                        some = (Some)option;
                        Seq valueFieldsNames = (Seq)some.x();
                        if (valueFieldsNames.size() != 1) break block2;
                        either = EitherUtils$.MODULE$.catchNonFatal((Function0)new Serializable(dfWTopicColumn, valueFieldsNames){
                            public static final long serialVersionUID = 0L;
                            private final Dataset dfWTopicColumn$2;
                            private final Seq valueFieldsNames$3;

                            public final List<Column> apply() {
                                return List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{this.dfWTopicColumn$2.apply((String)this.valueFieldsNames$3.head())}));
                            }
                            {
                                this.dfWTopicColumn$2 = dfWTopicColumn$2;
                                this.valueFieldsNames$3 = valueFieldsNames$3;
                            }
                        }).left().map((Function1)new Serializable(topic, valueFieldsNames){
                            public static final long serialVersionUID = 0L;
                            private final TopicModel topic$7;
                            private final Seq valueFieldsNames$3;

                            public final String apply(Throwable t) {
                                return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unknown field ", " set as valueFieldsNames in topic ", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.valueFieldsNames$3, this.topic$7.name()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"original spark exception: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{t.getMessage()}))).toString();
                            }
                            {
                                this.topic$7 = topic$7;
                                this.valueFieldsNames$3 = valueFieldsNames$3;
                            }
                        });
                        break block3;
                    }
                    if (!bl) break block4;
                    Seq valueFieldsNames = (Seq)some.x();
                    either = package$.MODULE$.Left().apply((Object)new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TopicModel ", " is of type ", " so valueFieldsNames "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic.name(), topic.topicDataType()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"should have only element but it has [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{valueFieldsNames.mkString(", ")}))).toString());
                    break block3;
                }
                if (!None$.MODULE$.equals(option)) break block5;
                Dataset df = (Dataset)topicColumn.map((Function1)new Serializable(dfWTopicColumn){
                    public static final long serialVersionUID = 0L;
                    private final Dataset dfWTopicColumn$2;

                    public final Dataset<Row> apply(String colName) {
                        return this.dfWTopicColumn$2.drop(colName);
                    }
                    {
                        this.dfWTopicColumn$2 = dfWTopicColumn$2;
                    }
                }).getOrElse((Function0)new Serializable(dfWTopicColumn){
                    public static final long serialVersionUID = 0L;
                    private final Dataset dfWTopicColumn$2;

                    public final Dataset<Row> apply() {
                        return this.dfWTopicColumn$2;
                    }
                    {
                        this.dfWTopicColumn$2 = dfWTopicColumn$2;
                    }
                });
                either = package$.MODULE$.Either().cond(df.schema().fieldNames().length == 1, (Function0)new Serializable(df){
                    public static final long serialVersionUID = 0L;
                    private final Dataset df$7;

                    public final List<Column> apply() {
                        return List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{this.df$7.apply((String)Predef$.MODULE$.refArrayOps((Object[])this.df$7.schema().fieldNames()).head())}));
                    }
                    {
                        this.df$7 = df$7;
                    }
                }, (Function0)new Serializable(topic, df){
                    public static final long serialVersionUID = 0L;
                    private final TopicModel topic$7;
                    private final Dataset df$7;

                    public final String apply() {
                        return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Dataframe for topic ", " is of type ", " therefore it "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic$7.name(), this.topic$7.topicDataType()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"needs to have only one column. If you need more columns to leverage headers and/or "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"key features, please set valueFieldsNames accordingly. Current dataframe schema:\\n"})).s((Seq)Nil$.MODULE$)).append((Object)this.df$7.schema().treeString()).toString();
                    }
                    {
                        this.topic$7 = topic$7;
                        this.df$7 = df$7;
                    }
                });
            }
            return either;
        }
        throw new MatchError((Object)option);
    }

    public List<Column> it$agilelab$bigdata$wasp$consumers$spark$plugins$kafka$TopicModelUtils$$columnsOfDF(Dataset<Row> df) {
        return Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])df.schema().fieldNames()).map((Function1)new Serializable(df){
            public static final long serialVersionUID = 0L;
            private final Dataset df$4;

            public final Column apply(String colName) {
                return this.df$4.apply(colName);
            }
            {
                this.df$4 = df$4;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Column.class)))).toList();
    }

    private Either<String, Schema> parseSchema(TopicModel topic) {
        return EitherUtils$.MODULE$.catchNonFatal((Function0)new Serializable(topic){
            public static final long serialVersionUID = 0L;
            private final TopicModel topic$4;

            public final Schema apply() {
                return new Schema.Parser().parse(this.topic$4.schema().toJson());
            }
            {
                this.topic$4 = topic$4;
            }
        }).left().map((Function1)new Serializable(topic){
            public static final long serialVersionUID = 0L;
            private final TopicModel topic$4;

            public final String apply(Throwable t) {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Schema of ", " cannot be parsed: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic$4.name(), t.getMessage()}));
            }
            {
                this.topic$4 = topic$4;
            }
        });
    }

    public Either<String, List<Column>> it$agilelab$bigdata$wasp$consumers$spark$plugins$kafka$TopicModelUtils$$safelyProjectColumns(TopicModel topic, List<String> fields, Dataset<Row> df) {
        return EitherUtils$.MODULE$.catchNonFatal((Function0)new Serializable(fields, df){
            public static final long serialVersionUID = 0L;
            private final List fields$2;
            public final Dataset df$5;

            public final List<Column> apply() {
                return (List)this.fields$2.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun$it$agilelab$bigdata$wasp$consumers$spark$plugins$kafka$TopicModelUtils$$safelyProjectColumns$1 $outer;

                    public final Column apply(String colName) {
                        return this.$outer.df$5.apply(colName);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, List$.MODULE$.canBuildFrom());
            }
            {
                this.fields$2 = fields$2;
                this.df$5 = df$5;
            }
        }).left().map((Function1)new Serializable(topic, fields, df){
            public static final long serialVersionUID = 0L;
            private final TopicModel topic$5;
            private final List fields$2;
            private final Dataset df$5;

            public final String apply(Throwable t) {
                return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Fields of the schema for topic ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic$5.name()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[", "] do not match the fields available "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.fields$2.mkString(",")}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"in the dataframe [", "].\\n original "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.refArrayOps((Object[])this.df$5.schema().fieldNames()).mkString(",")}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" spark exception: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{t.getMessage()}))).toString();
            }
            {
                this.topic$5 = topic$5;
                this.fields$2 = fields$2;
                this.df$5 = df$5;
            }
        });
    }

    public Either<String, BoxedUnit> it$agilelab$bigdata$wasp$consumers$spark$plugins$kafka$TopicModelUtils$$schemaAndDFmatch(TopicModel topic, Set<String> columnNames, List<String> fields) {
        return package$.MODULE$.Either().cond(((SetLike)columnNames.$minus$minus((GenTraversableOnce)fields.toSet())).isEmpty(), (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
            }
        }, (Function0)new Serializable(topic, columnNames, fields){
            public static final long serialVersionUID = 0L;
            private final TopicModel topic$6;
            private final Set columnNames$2;
            private final List fields$3;

            public final String apply() {
                return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Dataframe for topic ", " contains more columns "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic$6.name()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[", "] than the expected by the "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.columnNames$2.mkString(",")}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"schema [", "], maybe you need to narrow the columns "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.fields$3.mkString(",")}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"using valueFieldsNames property"})).s((Seq)Nil$.MODULE$)).toString();
            }
            {
                this.topic$6 = topic$6;
                this.columnNames$2 = columnNames$2;
                this.fields$3 = fields$3;
            }
        });
    }

    private Either<String, List<Column>> checkForStructuredDataType(TopicModel topic, Dataset<Row> dfWTopicColumn, Option<String> topicColumn) {
        Option option;
        block4: {
            Either either;
            block3: {
                block2: {
                    option = topic.valueFieldsNames();
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    Seq valueFieldsNames = (Seq)some.x();
                    either = topic.schema().isEmpty() ? EitherUtils.RightBiasedEither$.MODULE$.map$extension(EitherUtils$.MODULE$.RightBiasedEither(this.it$agilelab$bigdata$wasp$consumers$spark$plugins$kafka$TopicModelUtils$$projectValueFieldsNames(topic, dfWTopicColumn, (Seq<String>)valueFieldsNames)), (Function1)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final List<Column> apply(Dataset<Row> projectedDf) {
                            return TopicModelUtils$.MODULE$.it$agilelab$bigdata$wasp$consumers$spark$plugins$kafka$TopicModelUtils$$columnsOfDF(projectedDf);
                        }
                    }) : EitherUtils.RightBiasedEither$.MODULE$.flatMap$extension(EitherUtils$.MODULE$.RightBiasedEither(EitherUtils.RightBiasedEither$.MODULE$.map$extension(EitherUtils$.MODULE$.RightBiasedEither(this.parseSchema(topic)), (Function1)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final Tuple2<Schema, List<String>> apply(Schema schema) {
                            List fields = (List)((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(schema.getFields()).asScala()).toList().map((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final String apply(Schema.Field x$8) {
                                    return x$8.name();
                                }
                            }, List$.MODULE$.canBuildFrom());
                            return new Tuple2((Object)schema, (Object)fields);
                        }
                    })), (Function1)new Serializable(topic, dfWTopicColumn, valueFieldsNames){
                        public static final long serialVersionUID = 0L;
                        public final TopicModel topic$2;
                        private final Dataset dfWTopicColumn$1;
                        private final Seq valueFieldsNames$1;

                        public final Either<String, List<Column>> apply(Tuple2<Schema, List<String>> x$10) {
                            Tuple2<Schema, List<String>> tuple2 = x$10;
                            if (tuple2 != null) {
                                List fields = (List)tuple2._2();
                                Either either = EitherUtils.RightBiasedEither$.MODULE$.flatMap$extension(EitherUtils$.MODULE$.RightBiasedEither(EitherUtils.RightBiasedEither$.MODULE$.map$extension(EitherUtils$.MODULE$.RightBiasedEither(TopicModelUtils$.MODULE$.it$agilelab$bigdata$wasp$consumers$spark$plugins$kafka$TopicModelUtils$$projectValueFieldsNames(this.topic$2, (Dataset<Row>)this.dfWTopicColumn$1, (Seq<String>)this.valueFieldsNames$1)), (Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final Tuple2<Dataset<Row>, Set<String>> apply(Dataset<Row> projectedDf) {
                                        Set columnNames = Predef$.MODULE$.refArrayOps((Object[])projectedDf.schema().fieldNames()).toSet();
                                        return new Tuple2(projectedDf, (Object)columnNames);
                                    }
                                })), (Function1)new Serializable(this, fields){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ anonfun.checkForStructuredDataType.3 $outer;
                                    public final List fields$1;

                                    public final Either<String, List<Column>> apply(Tuple2<Dataset<Row>, Set<String>> x$9) {
                                        Tuple2<Dataset<Row>, Set<String>> tuple2 = x$9;
                                        if (tuple2 != null) {
                                            Dataset projectedDf = (Dataset)tuple2._1();
                                            Set columnNames = (Set)tuple2._2();
                                            Either either = EitherUtils.RightBiasedEither$.MODULE$.flatMap$extension(EitherUtils$.MODULE$.RightBiasedEither(TopicModelUtils$.MODULE$.it$agilelab$bigdata$wasp$consumers$spark$plugins$kafka$TopicModelUtils$$safelyProjectColumns(this.$outer.topic$2, (List<String>)this.fields$1, (Dataset<Row>)projectedDf)), (Function1)new Serializable(this, columnNames){
                                                public static final long serialVersionUID = 0L;
                                                private final /* synthetic */ anonfun$checkForStructuredDataType$3$$anonfun$apply$22 $outer;
                                                private final Set columnNames$1;

                                                public final Either<String, List<Column>> apply(List<Column> columns) {
                                                    return EitherUtils.RightBiasedEither$.MODULE$.map$extension(EitherUtils$.MODULE$.RightBiasedEither(TopicModelUtils$.MODULE$.it$agilelab$bigdata$wasp$consumers$spark$plugins$kafka$TopicModelUtils$$schemaAndDFmatch(this.$outer.it$agilelab$bigdata$wasp$consumers$spark$plugins$kafka$TopicModelUtils$$anonfun$$anonfun$$$outer().topic$2, (Set<String>)this.columnNames$1, (List<String>)this.$outer.fields$1)), (Function1)new Serializable(this, columns){
                                                        public static final long serialVersionUID = 0L;
                                                        private final List columns$1;

                                                        public final List<Column> apply(BoxedUnit _) {
                                                            return this.columns$1;
                                                        }
                                                        {
                                                            this.columns$1 = columns$1;
                                                        }
                                                    });
                                                }
                                                {
                                                    if ($outer == null) {
                                                        throw null;
                                                    }
                                                    this.$outer = $outer;
                                                    this.columnNames$1 = columnNames$1;
                                                }
                                            });
                                            return either;
                                        }
                                        throw new MatchError(tuple2);
                                    }

                                    public /* synthetic */ anonfun.checkForStructuredDataType.3 it$agilelab$bigdata$wasp$consumers$spark$plugins$kafka$TopicModelUtils$$anonfun$$anonfun$$$outer() {
                                        return this.$outer;
                                    }
                                    {
                                        if ($outer == null) {
                                            throw null;
                                        }
                                        this.$outer = $outer;
                                        this.fields$1 = fields$1;
                                    }
                                });
                                return either;
                            }
                            throw new MatchError(tuple2);
                        }
                        {
                            this.topic$2 = topic$2;
                            this.dfWTopicColumn$1 = dfWTopicColumn$1;
                            this.valueFieldsNames$1 = valueFieldsNames$1;
                        }
                    });
                    break block3;
                }
                if (!None$.MODULE$.equals(option)) break block4;
                Dataset df = (Dataset)topicColumn.map((Function1)new Serializable(dfWTopicColumn){
                    public static final long serialVersionUID = 0L;
                    private final Dataset dfWTopicColumn$1;

                    public final Dataset<Row> apply(String colName) {
                        return this.dfWTopicColumn$1.drop(colName);
                    }
                    {
                        this.dfWTopicColumn$1 = dfWTopicColumn$1;
                    }
                }).getOrElse((Function0)new Serializable(dfWTopicColumn){
                    public static final long serialVersionUID = 0L;
                    private final Dataset dfWTopicColumn$1;

                    public final Dataset<Row> apply() {
                        return this.dfWTopicColumn$1;
                    }
                    {
                        this.dfWTopicColumn$1 = dfWTopicColumn$1;
                    }
                });
                either = topic.schema().isEmpty() ? package$.MODULE$.Right().apply(this.it$agilelab$bigdata$wasp$consumers$spark$plugins$kafka$TopicModelUtils$$columnsOfDF((Dataset<Row>)df)) : EitherUtils.RightBiasedEither$.MODULE$.flatMap$extension(EitherUtils$.MODULE$.RightBiasedEither(EitherUtils.RightBiasedEither$.MODULE$.map$extension(EitherUtils$.MODULE$.RightBiasedEither(this.parseSchema(topic)), (Function1)new Serializable(df){
                    public static final long serialVersionUID = 0L;
                    private final Dataset df$6;

                    public final Tuple3<Schema, List<String>, Set<String>> apply(Schema schema) {
                        List fields = (List)((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(schema.getFields()).asScala()).toList().map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final String apply(Schema.Field x$11) {
                                return x$11.name();
                            }
                        }, List$.MODULE$.canBuildFrom());
                        Set columnNames = Predef$.MODULE$.refArrayOps((Object[])this.df$6.schema().fieldNames()).toSet();
                        return new Tuple3((Object)schema, (Object)fields, (Object)columnNames);
                    }
                    {
                        this.df$6 = df$6;
                    }
                })), (Function1)new Serializable(topic, df){
                    public static final long serialVersionUID = 0L;
                    public final TopicModel topic$2;
                    private final Dataset df$6;

                    public final Either<String, List<Column>> apply(Tuple3<Schema, List<String>, Set<String>> x$12) {
                        Tuple3<Schema, List<String>, Set<String>> tuple3 = x$12;
                        if (tuple3 != null) {
                            List fields = (List)tuple3._2();
                            Set columnNames = (Set)tuple3._3();
                            Either either = EitherUtils.RightBiasedEither$.MODULE$.flatMap$extension(EitherUtils$.MODULE$.RightBiasedEither(TopicModelUtils$.MODULE$.it$agilelab$bigdata$wasp$consumers$spark$plugins$kafka$TopicModelUtils$$safelyProjectColumns(this.topic$2, (List<String>)fields, (Dataset<Row>)this.df$6)), (Function1)new Serializable(this, fields, columnNames){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ anonfun.checkForStructuredDataType.5 $outer;
                                private final List fields$4;
                                private final Set columnNames$3;

                                public final Either<String, List<Column>> apply(List<Column> columns) {
                                    return EitherUtils.RightBiasedEither$.MODULE$.map$extension(EitherUtils$.MODULE$.RightBiasedEither(TopicModelUtils$.MODULE$.it$agilelab$bigdata$wasp$consumers$spark$plugins$kafka$TopicModelUtils$$schemaAndDFmatch(this.$outer.topic$2, (Set<String>)this.columnNames$3, (List<String>)this.fields$4)), (Function1)new Serializable(this, columns){
                                        public static final long serialVersionUID = 0L;
                                        private final List columns$2;

                                        public final List<Column> apply(BoxedUnit _) {
                                            return this.columns$2;
                                        }
                                        {
                                            this.columns$2 = columns$2;
                                        }
                                    });
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                    this.fields$4 = fields$4;
                                    this.columnNames$3 = columnNames$3;
                                }
                            });
                            return either;
                        }
                        throw new MatchError(tuple3);
                    }
                    {
                        this.topic$2 = topic$2;
                        this.df$6 = df$6;
                    }
                });
            }
            return either;
        }
        throw new MatchError((Object)option);
    }

    public Either<String, BoxedUnit> topicsShareKeySchema(Seq<TopicModel> topics) {
        return package$.MODULE$.Either().cond(((SeqLike)((SeqLike)topics.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Option<String> apply(TopicModel x$13) {
                return x$13.keySchema();
            }
        }, Seq$.MODULE$.canBuildFrom())).distinct()).size() == 1, (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
            }
        }, (Function0)new Serializable(topics){
            public static final long serialVersionUID = 0L;
            private final Seq topics$1;

            public final String apply() {
                return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot parse data from the following topics as a single dataframe:\\n\\t"})).s((Seq)Nil$.MODULE$)).append((Object)((TraversableOnce)this.topics$1.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(TopicModel x$14) {
                        return x$14.name();
                    }
                }, Seq$.MODULE$.canBuildFrom())).mkString("\t")).append((Object)"\n").append((Object)"It is not possible since they do not share the same key schema:\n\t").append((Object)((TraversableOnce)this.topics$1.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(TopicModel t) {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " -> ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{t.name(), t.keySchema()}));
                    }
                }, Seq$.MODULE$.canBuildFrom())).mkString("\t")).toString();
            }
            {
                this.topics$1 = topics$1;
            }
        });
    }

    public Either<String, Dataset<Row>> it$agilelab$bigdata$wasp$consumers$spark$plugins$kafka$TopicModelUtils$$projectValueFieldsNames(TopicModel topic, Dataset<Row> df, Seq<String> valueFieldsNames) {
        return EitherUtils$.MODULE$.catchNonFatal((Function0)new Serializable(df, valueFieldsNames){
            public static final long serialVersionUID = 0L;
            public final Dataset df$3;
            private final Seq valueFieldsNames$2;

            public final Dataset<Row> apply() {
                return this.df$3.select((Seq)this.valueFieldsNames$2.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun$it$agilelab$bigdata$wasp$consumers$spark$plugins$kafka$TopicModelUtils$$projectValueFieldsNames$1 $outer;

                    public final Column apply(String colName) {
                        return this.$outer.df$3.apply(colName);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, Seq$.MODULE$.canBuildFrom()));
            }
            {
                this.df$3 = df$3;
                this.valueFieldsNames$2 = valueFieldsNames$2;
            }
        }).left().map((Function1)new Serializable(topic, df, valueFieldsNames){
            public static final long serialVersionUID = 0L;
            private final TopicModel topic$3;
            private final Dataset df$3;
            private final Seq valueFieldsNames$2;

            public final String apply(Throwable t) {
                return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Fields specified in valueFieldsNames of topic ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic$3.name()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[", "] are not present in the df schema:\\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.valueFieldsNames$2.mkString(",")}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "\\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.df$3.schema().treeString()}))).append((Object)t.getMessage()).toString();
            }
            {
                this.topic$3 = topic$3;
                this.df$3 = df$3;
                this.valueFieldsNames$2 = valueFieldsNames$2;
            }
        });
    }

    private TopicModelUtils$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
    }
}

