/*
 * Decompiled with CFR 0.152.
 */
package it.agilelab.bigdata.wasp.consumers.spark.plugins.kafka;

import com.typesafe.config.Config;
import it.agilelab.bigdata.wasp.consumers.spark.plugins.kafka.KafkaTopicSettings;
import it.agilelab.bigdata.wasp.consumers.spark.plugins.kafka.TopicModelUtils;
import it.agilelab.bigdata.wasp.core.WaspSystem$;
import it.agilelab.bigdata.wasp.core.kafka.CheckOrCreateTopic;
import it.agilelab.bigdata.wasp.core.logging.Logging;
import it.agilelab.bigdata.wasp.core.logging.WaspLogger;
import it.agilelab.bigdata.wasp.core.utils.ConfigManager$;
import it.agilelab.bigdata.wasp.models.DatastoreModel;
import it.agilelab.bigdata.wasp.models.MultiTopicModel;
import it.agilelab.bigdata.wasp.models.MultiTopicModel$;
import it.agilelab.bigdata.wasp.models.TopicDataTypes$;
import it.agilelab.bigdata.wasp.models.TopicModel;
import it.agilelab.bigdata.wasp.models.configuration.TinyKafkaConfig;
import it.agilelab.bigdata.wasp.repository.core.bl.TopicBL;
import it.agilelab.bigdata.wasp.utils.EitherUtils$;
import java.io.Serializable;
import org.apache.avro.Schema;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class TopicModelUtils$
implements Logging {
    public static TopicModelUtils$ MODULE$;
    private final WaspLogger logger;

    static {
        new TopicModelUtils$();
    }

    public WaspLogger logger() {
        return this.logger;
    }

    public void it$agilelab$bigdata$wasp$core$logging$Logging$_setter_$logger_$eq(WaspLogger x$1) {
        this.logger = x$1;
    }

    public void askToCheckOrCreateTopics(Seq<TopicModel> topics) {
        this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(16).append("Creating topics ").append(topics).toString());
        topics.foreach((Function1 & Serializable & scala.Serializable)topic -> {
            TopicModelUtils$.$anonfun$askToCheckOrCreateTopics$2(topic);
            return BoxedUnit.UNIT;
        });
    }

    public TopicModelUtils.FieldNameAndTopicModels retrieveTopicFieldNameAndTopicModels(DatastoreModel dsModel, TopicBL topicBL, String topicDatastoreModelName) {
        Product product;
        DatastoreModel datastoreModel = dsModel;
        if (datastoreModel instanceof TopicModel) {
            TopicModel topicModel = (TopicModel)datastoreModel;
            product = new TopicModelUtils.SingleTopic(topicModel);
        } else if (datastoreModel instanceof MultiTopicModel) {
            MultiTopicModel multiTopicModel = (MultiTopicModel)datastoreModel;
            Seq topics = (Seq)((TraversableLike)multiTopicModel.topicModelNames().map((Function1 & Serializable & scala.Serializable)name -> topicBL.getByName(name), Seq$.MODULE$.canBuildFrom())).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Some some;
                DatastoreModel topicModel;
                Option option = x0$1;
                if (!(option instanceof Some) || !((topicModel = (DatastoreModel)(some = (Some)option).value()) instanceof TopicModel)) {
                    throw new Exception(new StringBuilder(53).append("Unable to retrieve topic datastore model with name \"").append(topicDatastoreModelName).append("\"").toString());
                }
                TopicModel topicModel2 = (TopicModel)topicModel;
                Seq seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicModel[]{topicModel2}));
                return seq;
            }, Seq$.MODULE$.canBuildFrom());
            product = new TopicModelUtils.MultiTopic(multiTopicModel.topicNameField(), (Seq<TopicModel>)topics);
        } else {
            throw new Exception(new StringBuilder(45).append("Datastore model ").append(datastoreModel).append(" is not compatible with Kafka").toString());
        }
        return product;
    }

    public KafkaTopicSettings retrieveKafkaTopicSettings(TopicBL topicBL, String topicDatastoreModelName) {
        KafkaTopicSettings kafkaTopicSettings;
        TinyKafkaConfig tinyKafkaConfig = ConfigManager$.MODULE$.getKafkaConfig().toTinyConfig();
        DatastoreModel mainTopicModel = (DatastoreModel)topicBL.getByName(topicDatastoreModelName).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new Exception(new StringBuilder(53).append("Unable to retrieve topic datastore model with name \"").append(topicDatastoreModelName).append("\"").toString());
        });
        TopicModelUtils.FieldNameAndTopicModels topicFieldNameAndTopics = this.retrieveTopicFieldNameAndTopicModels(mainTopicModel, topicBL, topicDatastoreModelName);
        TopicModelUtils.FieldNameAndTopicModels fieldNameAndTopicModels = topicFieldNameAndTopics;
        if (fieldNameAndTopicModels instanceof TopicModelUtils.SingleTopic) {
            TopicModelUtils.SingleTopic singleTopic = (TopicModelUtils.SingleTopic)fieldNameAndTopicModels;
            TopicModel t = singleTopic.t();
            this.askToCheckOrCreateTopics((Seq<TopicModel>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicModel[]{t}))));
            None$ darwinConf = t.useAvroSchemaManager() ? new Some((Object)ConfigManager$.MODULE$.getAvroSchemaManagerConfig()) : None$.MODULE$;
            kafkaTopicSettings = new KafkaTopicSettings(tinyKafkaConfig, mainTopicModel, (Option<String>)None$.MODULE$, (Seq<TopicModel>)((Seq)Seq$.MODULE$.empty()), (Option<Config>)darwinConf);
        } else if (fieldNameAndTopicModels instanceof TopicModelUtils.MultiTopic) {
            TopicModelUtils.MultiTopic multiTopic = (TopicModelUtils.MultiTopic)fieldNameAndTopicModels;
            String topicFieldName = multiTopic.topicFieldName();
            Seq<TopicModel> topics = multiTopic.topics();
            this.askToCheckOrCreateTopics(topics);
            None$ darwinConf = topics.exists((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.useAvroSchemaManager())) ? new Some((Object)ConfigManager$.MODULE$.getAvroSchemaManagerConfig()) : None$.MODULE$;
            kafkaTopicSettings = new KafkaTopicSettings(tinyKafkaConfig, mainTopicModel, (Option<String>)new Some((Object)topicFieldName), topics, (Option<Config>)darwinConf);
        } else {
            throw new MatchError((Object)fieldNameAndTopicModels);
        }
        return kafkaTopicSettings;
    }

    public String topicNameToColumnName(String s) {
        return new StringOps(Predef$.MODULE$.augmentString(new StringOps(Predef$.MODULE$.augmentString(s)).replaceAllLiterally(".", "_"))).replaceAllLiterally("-", "_");
    }

    public Either<String, BoxedUnit> areTopicsEqualForReading(Seq<TopicModel> models) {
        return MultiTopicModel$.MODULE$.areTopicsHealthy(models).flatMap((Function1 & Serializable & scala.Serializable)_2 -> package$.MODULE$.Either().cond(((SeqLike)((SeqLike)models.map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.topicDataType(), Seq$.MODULE$.canBuildFrom())).distinct()).length() == 1, (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {}, (Function0 & Serializable & scala.Serializable)() -> "All topic models must have the same topic data type").flatMap((Function1 & Serializable & scala.Serializable)_ -> package$.MODULE$.Either().cond(((SeqLike)((SeqLike)models.map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.getJsonSchema(), Seq$.MODULE$.canBuildFrom())).distinct()).size() == 1, (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {}, (Function0 & Serializable & scala.Serializable)() -> "All topic models must have the same schema").map((Function1 & Serializable & scala.Serializable)r -> {
            TopicModelUtils$.$anonfun$areTopicsEqualForReading$9(r);
            return BoxedUnit.UNIT;
        })));
    }

    public Either<String, BoxedUnit> isTopicWritable(DatastoreModel mainTopicModel, Seq<TopicModel> multiTopicModels, Dataset<Row> df) {
        Either either;
        DatastoreModel datastoreModel = mainTopicModel;
        if (datastoreModel instanceof MultiTopicModel) {
            MultiTopicModel multiTopicModel = (MultiTopicModel)datastoreModel;
            either = package$.MODULE$.Either().cond(multiTopicModels.nonEmpty(), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {}, (Function0 & Serializable & scala.Serializable)() -> "Multi topic needs inner multiTopicModels").flatMap((Function1 & Serializable & scala.Serializable)_ -> EitherUtils$.MODULE$.traverse((List)multiTopicModels.toList().map((Function1 & Serializable & scala.Serializable)t -> MODULE$.checkTopicModelHasCoherentFields((TopicModel)t, df, (Option<String>)new Some((Object)multiTopicModel.topicNameField())), List$.MODULE$.canBuildFrom())).flatMap((Function1 & Serializable & scala.Serializable)_2 -> MultiTopicModel$.MODULE$.areTopicsHealthy(multiTopicModels).map((Function1 & Serializable & scala.Serializable)_ -> {
                TopicModelUtils$.$anonfun$isTopicWritable$6(_);
                return BoxedUnit.UNIT;
            })));
        } else if (datastoreModel instanceof TopicModel) {
            TopicModel topicModel = (TopicModel)datastoreModel;
            either = package$.MODULE$.Either().cond(multiTopicModels.isEmpty(), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {}, (Function0 & Serializable & scala.Serializable)() -> "Single topic should not have multiTopicModels").flatMap((Function1 & Serializable & scala.Serializable)_ -> MODULE$.checkTopicModelHasCoherentFields(topicModel, df, (Option<String>)None$.MODULE$).flatMap((Function1 & Serializable & scala.Serializable)_2 -> MultiTopicModel$.MODULE$.areTopicsHealthy((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicModel[]{topicModel}))).map((Function1 & Serializable & scala.Serializable)_ -> {
                TopicModelUtils$.$anonfun$isTopicWritable$11(_);
                return BoxedUnit.UNIT;
            })));
        } else {
            either = package$.MODULE$.Left().apply((Object)new StringBuilder(21).append(datastoreModel.name()).append(" is not a topic model").toString());
        }
        return either;
    }

    public Either<String, List<Column>> checkTopicModelHasCoherentFields(TopicModel topic, Dataset<Row> df, Option<String> topicColumn) {
        Object object;
        Right right;
        Right right2;
        Right right3;
        Option<String> option = topicColumn;
        if (option instanceof Some) {
            Some some = (Some)option;
            String tColumn = (String)some.value();
            right3 = EitherUtils$.MODULE$.catchNonFatal((Function0 & Serializable & scala.Serializable)() -> df.apply(tColumn)).left().map((Function1 & Serializable & scala.Serializable)t -> new StringBuilder(73).append("Expected column named `").append(tColumn).append("` for topic ").append(topic.name()).append(" ").append("to be used as topic, but found None: ").append(t.getMessage()).toString()).map((Function1 & Serializable & scala.Serializable)x$4 -> {
                TopicModelUtils$.$anonfun$checkTopicModelHasCoherentFields$3(x$4);
                return BoxedUnit.UNIT;
            });
        } else if (None$.MODULE$.equals(option)) {
            right3 = package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT);
        } else {
            throw new MatchError(option);
        }
        Right topicColumnName = right3;
        Option option2 = topic.headersFieldName();
        if (option2 instanceof Some) {
            Some some = (Some)option2;
            String c = (String)some.value();
            right2 = EitherUtils$.MODULE$.catchNonFatal((Function0 & Serializable & scala.Serializable)() -> df.apply(c)).left().map((Function1 & Serializable & scala.Serializable)t -> new StringBuilder(74).append("Expected column named `").append(c).append("` for topic ").append(topic.name()).append(" ").append("to be used as header, but found None: ").append(t.getMessage()).toString()).map((Function1 & Serializable & scala.Serializable)x$5 -> {
                TopicModelUtils$.$anonfun$checkTopicModelHasCoherentFields$6(x$5);
                return BoxedUnit.UNIT;
            });
        } else if (None$.MODULE$.equals(option2)) {
            right2 = package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT);
        } else {
            throw new MatchError((Object)option2);
        }
        Right headerColumnName = right2;
        Option option3 = topic.keyFieldName();
        if (option3 instanceof Some) {
            Some some = (Some)option3;
            String c = (String)some.value();
            right = EitherUtils$.MODULE$.catchNonFatal((Function0 & Serializable & scala.Serializable)() -> df.apply(c)).left().map((Function1 & Serializable & scala.Serializable)t -> new StringBuilder(71).append("Expected column named `").append(c).append("` for topic ").append(topic.name()).append(" ").append("to be used as key, but found None: ").append(t.getMessage()).toString()).map((Function1 & Serializable & scala.Serializable)x$6 -> {
                TopicModelUtils$.$anonfun$checkTopicModelHasCoherentFields$9(x$6);
                return BoxedUnit.UNIT;
            });
        } else if (None$.MODULE$.equals(option3)) {
            right = package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT);
        } else {
            throw new MatchError((Object)option3);
        }
        Right keyColumnName = right;
        String string = topic.topicDataType();
        String string2 = TopicDataTypes$.MODULE$.AVRO();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            object = this.checkForStructuredDataType(topic, df, topicColumn).flatMap((Function1 & Serializable & scala.Serializable)step1 -> package$.MODULE$.Either().cond(!topic.schema().isEmpty(), (Function0 & Serializable & scala.Serializable)() -> step1, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(64).append("Topic ").append(topic.name()).append(" datatype is avro therefore the schema should be mandatory").toString()).map((Function1 & Serializable & scala.Serializable)step2 -> step2));
        } else {
            String string4 = TopicDataTypes$.MODULE$.JSON();
            String string5 = string;
            if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                object = this.checkForStructuredDataType(topic, df, topicColumn);
            } else {
                boolean bl;
                String string6 = TopicDataTypes$.MODULE$.BINARY();
                String string7 = string;
                if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
                    bl = true;
                } else {
                    String string8 = TopicDataTypes$.MODULE$.PLAINTEXT();
                    String string9 = string;
                    bl = !(string8 != null ? !string8.equals(string9) : string9 != null);
                }
                object = bl ? this.checkForPrimitiveDataType(topic, df, topicColumn) : package$.MODULE$.Left().apply((Object)new StringBuilder(28).append("Unknown datatype ").append(string).append(" for topic ").append(topic.name()).toString());
            }
        }
        Left fieldNames = object;
        return topicColumnName.flatMap(arg_0 -> TopicModelUtils$.$anonfun$checkTopicModelHasCoherentFields$14((Either)headerColumnName, (Either)keyColumnName, fieldNames, arg_0));
    }

    public Option<List<String>> getAllValueFieldsFromSchema(TopicModel topicModel) {
        None$ none$;
        boolean bl;
        String string = topicModel.topicDataType();
        String string2 = TopicDataTypes$.MODULE$.AVRO();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            bl = true;
        } else {
            String string4 = TopicDataTypes$.MODULE$.JSON();
            String string5 = string;
            bl = !(string4 != null ? !string4.equals(string5) : string5 != null);
        }
        if (bl) {
            None$ none$2;
            if (topicModel.schema().isEmpty()) {
                none$2 = None$.MODULE$;
            } else {
                Schema avroSchema = new Schema.Parser().parse(topicModel.getJsonSchema());
                none$2 = new Some((Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(avroSchema.getFields()).asScala()).map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.name(), Buffer$.MODULE$.canBuildFrom())).toList());
            }
            none$ = none$2;
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Either<String, List<Column>> checkForPrimitiveDataType(TopicModel topic, Dataset<Row> dfWTopicColumn, Option<String> topicColumn) {
        boolean bl = false;
        Some some = null;
        Option option = topic.valueFieldsNames();
        if (option instanceof Some) {
            bl = true;
            some = (Some)option;
            Seq valueFieldsNames = (Seq)some.value();
            if (valueFieldsNames.size() == 1) {
                return EitherUtils$.MODULE$.catchNonFatal((Function0 & Serializable & scala.Serializable)() -> new .colon.colon((Object)dfWTopicColumn.apply((String)valueFieldsNames.head()), (List)Nil$.MODULE$)).left().map((Function1 & Serializable & scala.Serializable)t -> new StringBuilder(76).append("Unknown field ").append(valueFieldsNames).append(" set as valueFieldsNames in topic ").append(topic.name()).append(", ").append("original spark exception: ").append(t.getMessage()).toString());
            }
        }
        if (bl) {
            Seq valueFieldsNames = (Seq)some.value();
            return package$.MODULE$.Left().apply((Object)new StringBuilder(82).append("TopicModel ").append(topic.name()).append(" is of type ").append(topic.topicDataType()).append(" so valueFieldsNames ").append("should have only element but it has [").append(valueFieldsNames.mkString(", ")).append("]").toString());
        }
        if (!None$.MODULE$.equals(option)) throw new MatchError((Object)option);
        Dataset df = (Dataset)topicColumn.map((Function1 & Serializable & scala.Serializable)colName -> dfWTopicColumn.drop(colName)).getOrElse((Function0 & Serializable & scala.Serializable)() -> dfWTopicColumn);
        return package$.MODULE$.Either().cond(df.schema().fieldNames().length == 1, (Function0 & Serializable & scala.Serializable)() -> new .colon.colon((Object)df.apply((String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])df.schema().fieldNames())).head()), (List)Nil$.MODULE$), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(210).append("Dataframe for topic ").append(topic.name()).append(" is of type ").append(topic.topicDataType()).append(" therefore it ").append("needs to have only one column. If you need more columns to leverage headers and/or ").append("key features, please set valueFieldsNames accordingly. Current dataframe schema:\n").append(df.schema().treeString()).toString());
    }

    private List<Column> columnsOfDF(Dataset<Row> df) {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])df.schema().fieldNames())).map((Function1 & Serializable & scala.Serializable)colName -> df.apply(colName), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Column.class))))).toList();
    }

    private Either<String, Schema> parseSchema(TopicModel topic) {
        return EitherUtils$.MODULE$.catchNonFatal((Function0 & Serializable & scala.Serializable)() -> new Schema.Parser().parse(topic.schema().toJson())).left().map((Function1 & Serializable & scala.Serializable)t -> new StringBuilder(29).append("Schema of ").append(topic.name()).append(" cannot be parsed: ").append(t.getMessage()).toString());
    }

    private Either<String, List<Column>> safelyProjectColumns(TopicModel topic, List<String> fields, Dataset<Row> df) {
        return EitherUtils$.MODULE$.catchNonFatal((Function0 & Serializable & scala.Serializable)() -> (List)fields.map((Function1 & Serializable & scala.Serializable)colName -> df.apply(colName), List$.MODULE$.canBuildFrom())).left().map((Function1 & Serializable & scala.Serializable)t -> new StringBuilder(118).append("Fields of the schema for topic ").append(topic.name()).append(" ").append("[").append(fields.mkString(",")).append("] do not match the fields available ").append("in the dataframe [").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])df.schema().fieldNames())).mkString(",")).append("].\n original ").append(" spark exception: ").append(t.getMessage()).toString());
    }

    private Either<String, BoxedUnit> schemaAndDFmatch(TopicModel topic, Set<String> columnNames, List<String> fields) {
        return package$.MODULE$.Either().cond(((SetLike)columnNames.$minus$minus((GenTraversableOnce)fields.toSet())).isEmpty(), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {}, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(150).append("Dataframe for topic ").append(topic.name()).append(" contains more columns ").append("[").append(columnNames.mkString(",")).append("] than the expected by the ").append("schema [").append(fields.mkString(",")).append("], maybe you need to narrow the columns ").append("using valueFieldsNames property").toString());
    }

    private Either<String, List<Column>> checkForStructuredDataType(TopicModel topic, Dataset<Row> dfWTopicColumn, Option<String> topicColumn) {
        Either either;
        Option option = topic.valueFieldsNames();
        if (option instanceof Some) {
            Some some = (Some)option;
            Seq valueFieldsNames = (Seq)some.value();
            either = topic.schema().isEmpty() ? this.projectValueFieldsNames(topic, dfWTopicColumn, (Seq<String>)valueFieldsNames).map((Function1 & Serializable & scala.Serializable)projectedDf -> MODULE$.columnsOfDF((Dataset<Row>)projectedDf)) : this.parseSchema(topic).map((Function1 & Serializable & scala.Serializable)schema -> {
                List fields = (List)((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(schema.getFields()).asScala()).toList().map((Function1 & Serializable & scala.Serializable)x$8 -> x$8.name(), List$.MODULE$.canBuildFrom());
                return new Tuple2(schema, (Object)fields);
            }).flatMap((Function1 & Serializable & scala.Serializable)x$10 -> {
                Tuple2 tuple2 = x$10;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                List fields = (List)tuple2._2();
                Either either = MODULE$.projectValueFieldsNames(topic, dfWTopicColumn, (Seq<String>)valueFieldsNames).map((Function1 & Serializable & scala.Serializable)projectedDf -> {
                    Set columnNames = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])projectedDf.schema().fieldNames())).toSet();
                    return new Tuple2(projectedDf, (Object)columnNames);
                }).flatMap((Function1 & Serializable & scala.Serializable)x$9 -> {
                    Tuple2 tuple2 = x$9;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    Dataset projectedDf = (Dataset)tuple2._1();
                    Set columnNames = (Set)tuple2._2();
                    Either either = MODULE$.safelyProjectColumns(topic, (List<String>)fields, (Dataset<Row>)projectedDf).flatMap((Function1 & Serializable & scala.Serializable)columns -> MODULE$.schemaAndDFmatch(topic, (Set<String>)columnNames, (List<String>)fields).map((Function1 & Serializable & scala.Serializable)_ -> columns));
                    return either;
                });
                return either;
            });
        } else if (None$.MODULE$.equals(option)) {
            Dataset df = (Dataset)topicColumn.map((Function1 & Serializable & scala.Serializable)colName -> dfWTopicColumn.drop(colName)).getOrElse((Function0 & Serializable & scala.Serializable)() -> dfWTopicColumn);
            either = topic.schema().isEmpty() ? package$.MODULE$.Right().apply(this.columnsOfDF((Dataset<Row>)df)) : this.parseSchema(topic).map((Function1 & Serializable & scala.Serializable)schema -> {
                List fields = (List)((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(schema.getFields()).asScala()).toList().map((Function1 & Serializable & scala.Serializable)x$11 -> x$11.name(), List$.MODULE$.canBuildFrom());
                Set columnNames = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])df.schema().fieldNames())).toSet();
                return new Tuple3(schema, (Object)fields, (Object)columnNames);
            }).flatMap((Function1 & Serializable & scala.Serializable)x$12 -> {
                Tuple3 tuple3 = x$12;
                if (tuple3 == null) {
                    throw new MatchError((Object)tuple3);
                }
                List fields = (List)tuple3._2();
                Set columnNames = (Set)tuple3._3();
                Either either = MODULE$.safelyProjectColumns(topic, (List<String>)fields, (Dataset<Row>)df).flatMap((Function1 & Serializable & scala.Serializable)columns -> MODULE$.schemaAndDFmatch(topic, (Set<String>)columnNames, (List<String>)fields).map((Function1 & Serializable & scala.Serializable)_ -> columns));
                return either;
            });
        } else {
            throw new MatchError((Object)option);
        }
        return either;
    }

    public Either<String, BoxedUnit> topicsShareKeySchema(Seq<TopicModel> topics) {
        return package$.MODULE$.Either().cond(((SeqLike)((SeqLike)topics.map((Function1 & Serializable & scala.Serializable)x$13 -> x$13.keySchema(), Seq$.MODULE$.canBuildFrom())).distinct()).size() == 1, (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {}, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(134).append("Cannot parse data from the following topics as a single dataframe:\n\t").append(((TraversableOnce)topics.map((Function1 & Serializable & scala.Serializable)x$14 -> x$14.name(), Seq$.MODULE$.canBuildFrom())).mkString("\t")).append("\n").append("It is not possible since they do not share the same key schema:\n\t").append(((TraversableOnce)topics.map((Function1 & Serializable & scala.Serializable)t -> new StringBuilder(4).append(t.name()).append(" -> ").append(t.keySchema()).toString(), Seq$.MODULE$.canBuildFrom())).mkString("\t")).toString());
    }

    private Either<String, Dataset<Row>> projectValueFieldsNames(TopicModel topic, Dataset<Row> df, Seq<String> valueFieldsNames) {
        return EitherUtils$.MODULE$.catchNonFatal((Function0 & Serializable & scala.Serializable)() -> df.select((Seq)valueFieldsNames.map((Function1 & Serializable & scala.Serializable)colName -> df.apply(colName), Seq$.MODULE$.canBuildFrom()))).left().map((Function1 & Serializable & scala.Serializable)t -> new StringBuilder(85).append("Fields specified in valueFieldsNames of topic ").append(topic.name()).append(" ").append("[").append(valueFieldsNames.mkString(",")).append("] are not present in the df schema:\n").append(df.schema().treeString()).append("\n").append(t.getMessage()).toString());
    }

    public static final /* synthetic */ void $anonfun$askToCheckOrCreateTopics$2(TopicModel topic) {
        if (!BoxesRunTime.unboxToBoolean((Object)WaspSystem$.MODULE$.$qmark$qmark(WaspSystem$.MODULE$.kafkaAdminActor(), (Object)new CheckOrCreateTopic(topic.name(), topic.partitions(), topic.replicas()), WaspSystem$.MODULE$.$qmark$qmark$default$3()))) {
            throw new Exception(new StringBuilder(23).append("Error creating topic \"").append(topic.name()).append("\"").toString());
        }
    }

    public static final /* synthetic */ void $anonfun$areTopicsEqualForReading$9(BoxedUnit r) {
    }

    public static final /* synthetic */ void $anonfun$isTopicWritable$6(BoxedUnit _) {
    }

    public static final /* synthetic */ void $anonfun$isTopicWritable$11(BoxedUnit _) {
    }

    public static final /* synthetic */ void $anonfun$checkTopicModelHasCoherentFields$3(Column x$4) {
    }

    public static final /* synthetic */ void $anonfun$checkTopicModelHasCoherentFields$6(Column x$5) {
    }

    public static final /* synthetic */ void $anonfun$checkTopicModelHasCoherentFields$9(Column x$6) {
    }

    public static final /* synthetic */ Either $anonfun$checkTopicModelHasCoherentFields$14(Either headerColumnName$1, Either keyColumnName$1, Either fieldNames$1, BoxedUnit _) {
        return headerColumnName$1.flatMap((Function1 & Serializable & scala.Serializable)_2 -> keyColumnName$1.flatMap((Function1 & Serializable & scala.Serializable)_ -> fieldNames$1.map((Function1 & Serializable & scala.Serializable)out -> out)));
    }

    private TopicModelUtils$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
    }
}

