/*
 * Decompiled with CFR 0.152.
 */
package it.agilelab.bigdata.wasp.consumers.spark.plugins.kafka;

import it.agilelab.bigdata.wasp.consumers.spark.plugins.kafka.TopicModelUtils$;
import it.agilelab.bigdata.wasp.consumers.spark.readers.SparkStructuredStreamingReader;
import it.agilelab.bigdata.wasp.consumers.spark.utils.AvroDeserializerExpression;
import it.agilelab.bigdata.wasp.consumers.spark.utils.SparkUtils$;
import it.agilelab.bigdata.wasp.core.WaspSystem$;
import it.agilelab.bigdata.wasp.core.kafka.CheckOrCreateTopic;
import it.agilelab.bigdata.wasp.core.logging.Logging;
import it.agilelab.bigdata.wasp.core.logging.WaspLogger;
import it.agilelab.bigdata.wasp.core.utils.AvroSchemaConverters$;
import it.agilelab.bigdata.wasp.core.utils.ConfigManager$;
import it.agilelab.bigdata.wasp.models.DatastoreModel;
import it.agilelab.bigdata.wasp.models.MultiTopicModel;
import it.agilelab.bigdata.wasp.models.MultiTopicModel$;
import it.agilelab.bigdata.wasp.models.StreamingReaderModel;
import it.agilelab.bigdata.wasp.models.StructuredStreamingETLModel;
import it.agilelab.bigdata.wasp.models.SubjectStrategy$;
import it.agilelab.bigdata.wasp.models.TopicDataTypes$;
import it.agilelab.bigdata.wasp.models.TopicModel;
import it.agilelab.bigdata.wasp.models.configuration.KafkaConfigModel;
import it.agilelab.bigdata.wasp.repository.core.bl.ConfigBL$;
import it.agilelab.bigdata.wasp.repository.core.bl.TopicBL;
import it.agilelab.bigdata.wasp.spark.sql.kafka011.KafkaSparkSQLSchemas$;
import it.agilelab.darwin.manager.AvroSchemaManagerFactory$;
import java.io.Serializable;
import org.apache.avro.Schema;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.expressions.CaseWhen;
import org.apache.spark.sql.catalyst.expressions.CaseWhen$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.Map$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.java8.JFunction1;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class KafkaSparkStructuredStreamingReader$
implements SparkStructuredStreamingReader,
Logging {
    public static KafkaSparkStructuredStreamingReader$ MODULE$;
    private final String KAFKA_METADATA_COL;
    private final WaspLogger logger;

    static {
        new KafkaSparkStructuredStreamingReader$();
    }

    public WaspLogger logger() {
        return this.logger;
    }

    public void it$agilelab$bigdata$wasp$core$logging$Logging$_setter_$logger_$eq(WaspLogger x$1) {
        this.logger = x$1;
    }

    private String KAFKA_METADATA_COL() {
        return this.KAFKA_METADATA_COL;
    }

    public Dataset<Row> createStructuredStream(StructuredStreamingETLModel etl, StreamingReaderModel streamingReaderModel, SparkSession ss) {
        this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(37).append("Creating stream from input: ").append(streamingReaderModel).append(" of ETL: ").append(etl).toString());
        this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(45).append("Retrieving topic datastore model with name \"").append(streamingReaderModel.datastoreModelName()).append("\"").toString());
        TopicBL topicBL = ConfigBL$.MODULE$.topicBL();
        Seq<TopicModel> topics = this.retrieveTopicModelsRecursively(topicBL, streamingReaderModel.datastoreModelName());
        this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(26).append("Retrieved topic model(s): ").append(topics).toString());
        KafkaConfigModel kafkaConfig = ConfigManager$.MODULE$.getKafkaConfig();
        this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(21).append("Kafka configuration: ").append(kafkaConfig).toString());
        boolean allCheckOrCreateResult = BoxesRunTime.unboxToBoolean((Object)((TraversableOnce)topics.map((Function1 & Serializable & scala.Serializable)topic -> BoxesRunTime.boxToBoolean((boolean)KafkaSparkStructuredStreamingReader$.$anonfun$createStructuredStream$5(topic)), Seq$.MODULE$.canBuildFrom())).reduce((Function2 & Serializable & scala.Serializable)(x$1, x$2) -> BoxesRunTime.boxToBoolean((boolean)KafkaSparkStructuredStreamingReader$.$anonfun$createStructuredStream$6(BoxesRunTime.unboxToBoolean((Object)x$1), BoxesRunTime.unboxToBoolean((Object)x$2)))));
        if (!allCheckOrCreateResult) {
            String msg = new StringBuilder(50).append("Unable to check/create one or more topic; topics: ").append(topics).toString();
            this.logger().error((Function0 & Serializable & scala.Serializable)() -> msg);
            throw new Exception(msg);
        }
        long triggerIntervalMs = SparkUtils$.MODULE$.getTriggerIntervalMs(ConfigManager$.MODULE$.getSparkStreamingConfig(), etl);
        Option maybeRateLimit = streamingReaderModel.rateLimit().map((Function1)(JFunction1.mcJI.sp & Serializable & scala.Serializable)x -> triggerIntervalMs == 0L ? (long)x : (long)((double)triggerIntervalMs / 1000.0 * (double)x));
        Option maybeMaxOffsetsPerTrigger = maybeRateLimit.map((Function1 & Serializable & scala.Serializable)rateLimit -> KafkaSparkStructuredStreamingReader$.$anonfun$createStructuredStream$8(BoxesRunTime.unboxToLong((Object)rateLimit)));
        scala.collection.mutable.Map options = Map$.MODULE$.empty();
        options.$plus$plus$eq((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"subscribe"), (Object)((TraversableOnce)topics.map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.name(), Seq$.MODULE$.canBuildFrom())).mkString(",")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"kafka.bootstrap.servers"), (Object)((TraversableOnce)kafkaConfig.connections().map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.toString(), Seq$.MODULE$.canBuildFrom())).mkString(",")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"kafkaConsumer.pollTimeoutMs"), (Object)((Object)BoxesRunTime.boxToInteger((int)kafkaConfig.ingestRateToMills())).toString())})));
        options.$plus$plus$eq((TraversableOnce)Option$.MODULE$.option2Iterable(maybeMaxOffsetsPerTrigger));
        options.$plus$plus$eq((TraversableOnce)((TraversableOnce)kafkaConfig.others().map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.toTupla(), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()));
        options.$plus$plus$eq((TraversableOnce)streamingReaderModel.options());
        this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(48).append("Final options to be pushed to DataStreamReader: ").append(options).toString());
        Dataset df = ss.readStream().format("kafka").options((Map)options).load();
        return this.parseDF(topics, (Dataset<Row>)df);
    }

    /*
     * WARNING - void declaration
     */
    private Column selectMetadata(Column keyCol) {
        void var3_4;
        List allColumnsButValue = ((TraversableOnce)((TraversableLike)KafkaSparkSQLSchemas$.MODULE$.INPUT_SCHEMA().map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.name(), Seq$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)cName -> BoxesRunTime.boxToBoolean((boolean)KafkaSparkStructuredStreamingReader$.$anonfun$selectMetadata$2(cName)))).toList();
        Column column = keyCol;
        Column metadataSelectExpr = functions$.MODULE$.struct((Seq)((List)allColumnsButValue.map((Function1 & Serializable & scala.Serializable)colName -> functions$.MODULE$.col(colName), List$.MODULE$.canBuildFrom())).$colon$colon((Object)column)).as(this.KAFKA_METADATA_COL());
        return var3_4;
    }

    private Column selectMetadata$default$1() {
        return functions$.MODULE$.col(KafkaSparkSQLSchemas$.MODULE$.KEY_ATTRIBUTE_NAME());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Dataset<Row> parseDF(Seq<TopicModel> topics, Dataset<Row> df) {
        Dataset<Row> dataset;
        Either either = MultiTopicModel$.MODULE$.areTopicsHealthy(topics);
        if (either instanceof Left) {
            Left left = (Left)either;
            String a = (String)left.value();
            throw new IllegalArgumentException(a);
        }
        if (!(either instanceof Right)) throw new MatchError((Object)either);
        Either<String, BoxedUnit> either2 = TopicModelUtils$.MODULE$.areTopicsEqualForReading(topics);
        if (either2 instanceof Left) {
            Left left = (Left)either2;
            String a = (String)left.value();
            Either<String, BoxedUnit> either3 = TopicModelUtils$.MODULE$.topicsShareKeySchema(topics);
            if (either3 instanceof Left) {
                Left left2 = (Left)either3;
                String error = (String)left2.value();
                throw new IllegalArgumentException(error);
            }
            if (!(either3 instanceof Right)) throw new MatchError(either3);
            this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(61).append("Suppressing error: '").append(a).append("' and trying with multipleSchema strategy").toString());
            Dataset<Row> dataset2 = this.selectForMultipleSchema(topics, df);
            dataset = dataset2;
            return dataset;
        } else {
            if (!(either2 instanceof Right)) throw new MatchError(either2);
            dataset = this.selectForOneSchema((TopicModel)topics.head(), df);
        }
        return dataset;
    }

    public Dataset<Row> selectForOneSchema(TopicModel prototypeTopic, Dataset<Row> df) {
        Dataset dataset;
        String string = prototypeTopic.topicDataType();
        String string2 = TopicDataTypes$.MODULE$.AVRO();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            dataset = df.withColumn("value_parsed", this.parseAvroValue(prototypeTopic)).drop(KafkaSparkSQLSchemas$.MODULE$.VALUE_ATTRIBUTE_NAME()).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{this.selectMetadata(this.parseKey(prototypeTopic)), functions$.MODULE$.expr("value_parsed.*")}));
        } else {
            String string4 = TopicDataTypes$.MODULE$.JSON();
            String string5 = string;
            if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                dataset = df.withColumn(KafkaSparkSQLSchemas$.MODULE$.VALUE_ATTRIBUTE_NAME(), functions$.MODULE$.from_json(this.parseString(), this.getDataType(prototypeTopic.getJsonSchema()))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{this.selectMetadata(this.selectMetadata$default$1()), functions$.MODULE$.expr("value.*")}));
            } else {
                String string6 = TopicDataTypes$.MODULE$.PLAINTEXT();
                String string7 = string;
                if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
                    dataset = df.withColumn("value_string", this.parseString()).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{this.selectMetadata(this.selectMetadata$default$1()), functions$.MODULE$.expr("value_string AS value")}));
                } else {
                    String string8 = TopicDataTypes$.MODULE$.BINARY();
                    String string9 = string;
                    if (!(string8 != null ? !string8.equals(string9) : string9 != null)) {
                        dataset = df.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{this.selectMetadata(this.selectMetadata$default$1()), functions$.MODULE$.expr(KafkaSparkSQLSchemas$.MODULE$.VALUE_ATTRIBUTE_NAME())}));
                    } else {
                        throw new UnsupportedOperationException(new StringBuilder(30).append("Unsupported topic data type \"").append(prototypeTopic.topicDataType()).append("\"").toString());
                    }
                }
            }
        }
        Dataset ret = dataset;
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(18).append("DataFrame schema: ").append(ret.schema().treeString()).toString());
        return ret;
    }

    public Dataset<Row> selectForMultipleSchema(Seq<TopicModel> topics, Dataset<Row> df) {
        Column metadataExpr;
        Column column;
        List valueColumns = ((List)topics.foldLeft((Object)List$.MODULE$.empty(), (Function2 & Serializable & scala.Serializable)(cols, t) -> {
            List list;
            String string = t.topicDataType();
            String string2 = TopicDataTypes$.MODULE$.AVRO();
            String string3 = string;
            if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                Column column = MODULE$.parseIfMyTopicOrNull(t.name(), MODULE$.parseAvroValue((TopicModel)t));
                list = cols.$colon$colon((Object)column);
            } else {
                String string4 = TopicDataTypes$.MODULE$.JSON();
                String string5 = string;
                if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                    Column column = MODULE$.parseIfMyTopicOrNull(t.name(), MODULE$.parseJson((TopicModel)t));
                    list = cols.$colon$colon((Object)column);
                } else {
                    String string6 = TopicDataTypes$.MODULE$.PLAINTEXT();
                    String string7 = string;
                    if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
                        Column column = MODULE$.parseIfMyTopicOrNull(t.name(), MODULE$.parseString());
                        list = cols.$colon$colon((Object)column);
                    } else {
                        String string8 = TopicDataTypes$.MODULE$.BINARY();
                        String string9 = string;
                        if (!(string8 != null ? !string8.equals(string9) : string9 != null)) {
                            Column column = MODULE$.parseIfMyTopicOrNull(t.name(), MODULE$.parseBinary());
                            list = cols.$colon$colon((Object)column);
                        } else {
                            throw new UnsupportedOperationException(new StringBuilder(30).append("Unsupported topic data type \"").append(t.topicDataType()).append("\"").toString());
                        }
                    }
                }
            }
            return list;
        })).reverse();
        this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(33).append("Selecting the following columns:\n").append(valueColumns.mkString("\t- ", "\n\t- ", "")).toString());
        Option option = topics.collectFirst((PartialFunction)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends TopicModel, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 != null) {
                    String string = A1.topicDataType();
                    String string2 = TopicDataTypes$.MODULE$.AVRO();
                    String string3 = string;
                    if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                        object = A1;
                        return (B1)object;
                    }
                }
                object = function1.apply(x1);
                return (B1)object;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean isDefinedAt(TopicModel x1) {
                TopicModel topicModel = x1;
                if (topicModel == null) return false;
                String string = topicModel.topicDataType();
                String string2 = TopicDataTypes$.MODULE$.AVRO();
                String string3 = string;
                if (string2 != null) {
                    if (!string2.equals(string3)) return false;
                    return true;
                }
                if (string3 == null) return true;
                return false;
            }
        });
        if (option instanceof Some) {
            Some some = (Some)option;
            TopicModel t2 = (TopicModel)some.value();
            column = this.selectMetadata(this.parseKey(t2));
        } else if (None$.MODULE$.equals(option)) {
            column = this.selectMetadata(this.selectMetadata$default$1());
        } else {
            throw new MatchError((Object)option);
        }
        Column column2 = metadataExpr = column;
        Dataset ret = df.select((Seq)valueColumns.$colon$colon((Object)column2));
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(18).append("DataFrame schema: ").append(ret.schema().treeString()).toString());
        return ret;
    }

    private Column parseBinary() {
        return functions$.MODULE$.col(KafkaSparkSQLSchemas$.MODULE$.VALUE_ATTRIBUTE_NAME());
    }

    private Column parseString() {
        return functions$.MODULE$.col(KafkaSparkSQLSchemas$.MODULE$.VALUE_ATTRIBUTE_NAME()).cast((DataType)StringType$.MODULE$);
    }

    private Column parseJson(TopicModel t) {
        return functions$.MODULE$.from_json(this.parseString(), this.getDataType(t.getJsonSchema()));
    }

    private Column parseKey(TopicModel t) {
        Column column;
        Option option = t.keySchema();
        if (option instanceof Some) {
            Some some = (Some)option;
            String keySchema = (String)some.value();
            LazyRef avroSchemaManager$lzy = new LazyRef();
            this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(17).append("AVRO key schema: ").append(new Schema.Parser().parse(keySchema).toString(true)).toString());
            None$ darwinConf = t.useAvroSchemaManager() ? new Some((Object)ConfigManager$.MODULE$.getAvroSchemaManagerConfig()) : None$.MODULE$;
            Some schemaToUse = keySchema.isEmpty() ? KafkaSparkStructuredStreamingReader$.avroSchemaManager$1(avroSchemaManager$lzy, (Option)darwinConf).flatMap((Function1 & Serializable & scala.Serializable)sm -> SubjectStrategy$.MODULE$.subjectFor(t.getJsonSchema(), t, true).map((Function1 & Serializable & scala.Serializable)subj -> {
                Tuple2 idAndSchema = (Tuple2)sm.retrieveLatestSchema(subj).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                    throw new RuntimeException(new StringBuilder(78).append("Reader schema not specified and fetching latest schema with subject '").append((String)subj).append("' failed.").toString());
                });
                return ((Schema)idAndSchema._2()).toString();
            })) : new Some((Object)keySchema);
            AvroDeserializerExpression avroKeyConversion = new AvroDeserializerExpression(functions$.MODULE$.col(KafkaSparkSQLSchemas$.MODULE$.KEY_ATTRIBUTE_NAME()).expr(), (String)schemaToUse.get(), (Option)darwinConf, true);
            column = new Column((Expression)avroKeyConversion);
        } else if (None$.MODULE$.equals(option)) {
            column = functions$.MODULE$.col(KafkaSparkSQLSchemas$.MODULE$.KEY_ATTRIBUTE_NAME());
        } else {
            throw new MatchError((Object)option);
        }
        return column;
    }

    private Column parseAvroValue(TopicModel t) {
        LazyRef avroSchemaManager$lzy = new LazyRef();
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(19).append("AVRO value schema: ").append(new Schema.Parser().parse(t.getJsonSchema()).toString(true)).toString());
        None$ darwinConf = t.useAvroSchemaManager() ? new Some((Object)ConfigManager$.MODULE$.getAvroSchemaManagerConfig()) : None$.MODULE$;
        Some schemaToUse = t.schema().isEmpty() ? KafkaSparkStructuredStreamingReader$.avroSchemaManager$2(avroSchemaManager$lzy, (Option)darwinConf).flatMap((Function1 & Serializable & scala.Serializable)sm -> SubjectStrategy$.MODULE$.subjectFor(t.getJsonSchema(), t, false).map((Function1 & Serializable & scala.Serializable)subj -> {
            Tuple2 idAndSchema = (Tuple2)sm.retrieveLatestSchema(subj).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                throw new RuntimeException(new StringBuilder(78).append("Reader schema not specified and fetching latest schema with subject '").append((String)subj).append("' failed.").toString());
            });
            return ((Schema)idAndSchema._2()).toString();
        })) : new Some((Object)t.getJsonSchema());
        AvroDeserializerExpression avroToRowConversion = new AvroDeserializerExpression(functions$.MODULE$.col(KafkaSparkSQLSchemas$.MODULE$.VALUE_ATTRIBUTE_NAME()).expr(), (String)schemaToUse.get(), (Option)darwinConf, true);
        return new Column((Expression)avroToRowConversion);
    }

    private Seq<TopicModel> retrieveTopicModelsRecursively(TopicBL topicBL, String topicDatastoreModelName) {
        return KafkaSparkStructuredStreamingReader$.innerRetrieveTopicModelsRecursively$1(topicDatastoreModelName, topicBL);
    }

    private DataType getDataType(String schema) {
        Schema schemaAvro = new Schema.Parser().parse(schema);
        return AvroSchemaConverters$.MODULE$.toSqlType(schemaAvro).dataType();
    }

    private Column parseIfMyTopicOrNull(String topicName, Column parseCol) {
        return KafkaSparkStructuredStreamingReader$.when$1(functions$.MODULE$.col(KafkaSparkSQLSchemas$.MODULE$.TOPIC_ATTRIBUTE_NAME()).equalTo((Object)topicName), parseCol).otherwise(null).as(TopicModelUtils$.MODULE$.topicNameToColumnName(topicName));
    }

    public static final /* synthetic */ boolean $anonfun$createStructuredStream$5(TopicModel topic) {
        return BoxesRunTime.unboxToBoolean((Object)WaspSystem$.MODULE$.$qmark$qmark(WaspSystem$.MODULE$.kafkaAdminActor(), (Object)new CheckOrCreateTopic(topic.name(), topic.partitions(), topic.replicas()), WaspSystem$.MODULE$.$qmark$qmark$default$3()));
    }

    public static final /* synthetic */ boolean $anonfun$createStructuredStream$6(boolean x$1, boolean x$2) {
        return x$1 && x$2;
    }

    public static final /* synthetic */ Tuple2 $anonfun$createStructuredStream$8(long rateLimit) {
        return new Tuple2((Object)"maxOffsetsPerTrigger", (Object)((Object)BoxesRunTime.boxToLong((long)rateLimit)).toString());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$selectMetadata$2(String cName) {
        String string = cName;
        String string2 = KafkaSparkSQLSchemas$.MODULE$.VALUE_ATTRIBUTE_NAME();
        if (string == null) {
            if (string2 == null) return false;
        } else if (string.equals(string2)) return false;
        String string3 = cName;
        String string4 = KafkaSparkSQLSchemas$.MODULE$.KEY_ATTRIBUTE_NAME();
        if (string3 == null) {
            if (string4 == null) return false;
            return true;
        } else if (string3.equals(string4)) return false;
        return true;
    }

    private static final /* synthetic */ Option avroSchemaManager$lzycompute$1(LazyRef avroSchemaManager$lzy$1, Option darwinConf$1) {
        Option option;
        LazyRef lazyRef = avroSchemaManager$lzy$1;
        synchronized (lazyRef) {
            option = avroSchemaManager$lzy$1.initialized() ? (Option)avroSchemaManager$lzy$1.value() : (Option)avroSchemaManager$lzy$1.initialize((Object)darwinConf$1.map((Function1 & Serializable & scala.Serializable)config -> AvroSchemaManagerFactory$.MODULE$.initialize(config)));
        }
        return option;
    }

    private static final Option avroSchemaManager$1(LazyRef avroSchemaManager$lzy$1, Option darwinConf$1) {
        return avroSchemaManager$lzy$1.initialized() ? (Option)avroSchemaManager$lzy$1.value() : KafkaSparkStructuredStreamingReader$.avroSchemaManager$lzycompute$1(avroSchemaManager$lzy$1, darwinConf$1);
    }

    private static final /* synthetic */ Option avroSchemaManager$lzycompute$2(LazyRef avroSchemaManager$lzy$2, Option darwinConf$2) {
        Option option;
        LazyRef lazyRef = avroSchemaManager$lzy$2;
        synchronized (lazyRef) {
            option = avroSchemaManager$lzy$2.initialized() ? (Option)avroSchemaManager$lzy$2.value() : (Option)avroSchemaManager$lzy$2.initialize((Object)darwinConf$2.map((Function1 & Serializable & scala.Serializable)config -> AvroSchemaManagerFactory$.MODULE$.initialize(config)));
        }
        return option;
    }

    private static final Option avroSchemaManager$2(LazyRef avroSchemaManager$lzy$2, Option darwinConf$2) {
        return avroSchemaManager$lzy$2.initialized() ? (Option)avroSchemaManager$lzy$2.value() : KafkaSparkStructuredStreamingReader$.avroSchemaManager$lzycompute$2(avroSchemaManager$lzy$2, darwinConf$2);
    }

    private static final Seq innerRetrieveTopicModelsRecursively$1(String topicDatastoreModelName2, TopicBL topicBL$1) {
        Seq seq;
        DatastoreModel topicDatastoreModel = (DatastoreModel)topicBL$1.getByName(topicDatastoreModelName2).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalArgumentException(new StringBuilder(29).append("Cannot find topic with name: ").append(topicDatastoreModelName2).toString());
        });
        DatastoreModel datastoreModel = topicDatastoreModel;
        if (datastoreModel instanceof TopicModel) {
            TopicModel topicModel = (TopicModel)datastoreModel;
            seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicModel[]{topicModel}));
        } else if (datastoreModel instanceof MultiTopicModel) {
            MultiTopicModel multiTopicModel = (MultiTopicModel)datastoreModel;
            seq = (Seq)multiTopicModel.topicModelNames().flatMap((Function1 & Serializable & scala.Serializable)topicDatastoreModelName -> KafkaSparkStructuredStreamingReader$.innerRetrieveTopicModelsRecursively$1(topicDatastoreModelName, topicBL$1), Seq$.MODULE$.canBuildFrom());
        } else {
            throw new MatchError((Object)datastoreModel);
        }
        return seq;
    }

    private static final Column when$1(Column condition, Column value) {
        return new Column((Expression)new CaseWhen((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)condition.expr(), (Object)value.expr())})), CaseWhen$.MODULE$.apply$default$2()));
    }

    private KafkaSparkStructuredStreamingReader$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
        this.KAFKA_METADATA_COL = "kafkaMetadata";
    }
}

