/*
 * Decompiled with CFR 0.152.
 */
package it.agilelab.bigdata.wasp.consumers.spark.strategies.gdpr.utils.hdfs;

import it.agilelab.bigdata.wasp.consumers.spark.strategies.gdpr.utils.GdprUtils$;
import it.agilelab.bigdata.wasp.consumers.spark.strategies.gdpr.utils.hdfs.HdfsUtils;
import it.agilelab.bigdata.wasp.core.logging.Logging;
import it.agilelab.bigdata.wasp.core.logging.WaspLogger;
import it.agilelab.bigdata.wasp.models.RawModel;
import it.agilelab.bigdata.wasp.models.RawOptions;
import it.agilelab.bigdata.wasp.utils.ConfigManagerHelper$;
import java.io.Serializable;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.spark.SparkContext;
import org.apache.spark.sql.DataFrameReader;
import org.apache.spark.sql.DataFrameWriter;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.types.DataType$;
import org.apache.spark.sql.types.StructType;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class HdfsUtils$
implements Logging {
    public static HdfsUtils$ MODULE$;
    private final WaspLogger logger;

    static {
        new HdfsUtils$();
    }

    public WaspLogger logger() {
        return this.logger;
    }

    public void it$agilelab$bigdata$wasp$core$logging$Logging$_setter_$logger_$eq(WaspLogger x$1) {
        this.logger = x$1;
    }

    public Try<Path> backupFiles(FileSystem fs, Seq<Path> filesToBackup, Path backupParentDir, Path dataPath) {
        Path backupDirPath = new Path(backupParentDir, new StringBuilder(7).append("backup_").append(UUID.randomUUID().toString()).toString());
        return Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> fs.exists(backupDirPath)).flatMap((Function1 & Serializable & scala.Serializable)exists -> HdfsUtils$.$anonfun$backupFiles$2(backupDirPath, filesToBackup, dataPath, fs, BoxesRunTime.unboxToBoolean((Object)exists)));
    }

    public Path replacePathPrefix(Path filePath, Path prefixPathToChange, Path newPrefix) {
        String fileUri = filePath.toUri().getPath();
        String fileUriWithoutPrefix = this.StringPrefix(fileUri).removePrefix(prefixPathToChange.toUri().getPath());
        return newPrefix.suffix(fileUriWithoutPrefix);
    }

    public List<Tuple2<String, String>> findPartitionColumns(String uri) {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])uri.split("/"))).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.contains("="))))).map((Function1 & Serializable & scala.Serializable)partitionColumn -> {
            String[] splits = partitionColumn.split("=");
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)splits[0]), (Object)splits[1]);
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).toList();
    }

    public Try<BoxedUnit> deletePath(FileSystem fs, Path sourcePath) {
        this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(15).append("Deleting path: ").append(sourcePath.toUri().toString()).toString());
        return Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> fs.delete(sourcePath, true)).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> HdfsUtils$.$anonfun$deletePath$3(sourcePath, BoxesRunTime.unboxToBoolean((Object)x0$1)));
    }

    public HdfsUtils.StringPrefix StringPrefix(String string) {
        return new HdfsUtils.StringPrefix(string);
    }

    public String getRawModelPathToWrite(RawModel rawModel) {
        String string;
        if (rawModel.timed()) {
            Path hdfsPath = new Path(rawModel.uri());
            Path timedPath = new Path(new StringBuilder(2).append(hdfsPath.toString()).append("/").append(ConfigManagerHelper$.MODULE$.buildTimedName("").substring(1)).append("/").toString());
            string = timedPath.toString();
        } else {
            string = rawModel.uri();
        }
        return string;
    }

    public String getRawModelPathToToLoad(RawModel rawModel, SparkContext sc) {
        String string;
        if (rawModel.timed()) {
            Path hdfsPath = new Path(rawModel.uri());
            FileSystem hdfs = hdfsPath.getFileSystem(sc.hadoopConfiguration());
            List subdirectories = (List)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])hdfs.listStatus(hdfsPath))).toList().filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.isDirectory()));
            Path mostRecentSubdirectory = ((FileStatus)((List)subdirectories.sortBy((Function1 & Serializable & scala.Serializable)x$3 -> x$3.getPath().getName(), (Ordering)Ordering.String$.MODULE$)).reverse().head()).getPath();
            string = mostRecentSubdirectory.toString();
        } else {
            string = rawModel.uri();
        }
        return string;
    }

    public Try<Dataset<Row>> readRawModel(RawModel rawModel, SparkSession spark) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            StructType schema = (StructType)DataType$.MODULE$.fromJson(rawModel.schema());
            RawOptions options = rawModel.options();
            DataFrameReader reader = spark.sqlContext().read().schema(schema).format(options.format()).options((Map)options.extraOptions().getOrElse((Function0 & Serializable & scala.Serializable)() -> (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$)));
            String path = MODULE$.getRawModelPathToToLoad(rawModel, spark.sparkContext());
            MODULE$.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(18).append("Load this path: '").append(path).append("'").toString());
            return reader.load(path);
        });
    }

    public Try<BoxedUnit> writeRawModel(RawModel rawModel, Dataset<Row> df) {
        return Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            MODULE$.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(26).append("Initializing HDFS writer: ").append(rawModel).toString());
            String path = MODULE$.getRawModelPathToWrite(rawModel);
            RawOptions options = rawModel.options();
            String string = options.saveMode();
            String string2 = "default";
            String mode = !(string != null ? !string.equals(string2) : string2 != null) ? "error" : options.saveMode();
            String format = options.format();
            scala.collection.immutable.Map extraOptions = (scala.collection.immutable.Map)options.extraOptions().getOrElse((Function0 & Serializable & scala.Serializable)() -> (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$));
            List partitionBy = (List)options.partitionBy().getOrElse((Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$);
            DataFrameWriter writer = df.write().mode(mode).format(format).options((Map)extraOptions).partitionBy((Seq)partitionBy);
            MODULE$.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(22).append("Write in this path: '").append(path).append("'").toString());
            writer.save(path);
        });
    }

    public <T, B> Try<B> foldIterator(RemoteIterator<T> iterator, Try<B> acc, Function2<B, T, B> f, Function1<B, Object> exitPath) {
        Failure failure;
        Try try_ = acc;
        if (try_ instanceof Failure) {
            Failure failure2;
            failure = failure2 = (Failure)try_;
        } else if (try_ instanceof Success) {
            Success success = (Success)try_;
            Object accOk = success.value();
            failure = Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> iterator.hasNext()).flatMap((Function1 & Serializable & scala.Serializable)hasNext -> HdfsUtils$.$anonfun$foldIterator$2(exitPath, accOk, iterator, f, acc, BoxesRunTime.unboxToBoolean((Object)hasNext)));
        } else {
            throw new MatchError(try_);
        }
        return failure;
    }

    public static final /* synthetic */ boolean $anonfun$backupFiles$5(Path dataPath$1, Path backupDirPath$1, FileSystem fs$1, Path f) {
        Path newPath = MODULE$.replacePathPrefix(f, dataPath$1, backupDirPath$1);
        return FileUtil.copy((FileSystem)fs$1, (Path)f, (FileSystem)fs$1, (Path)newPath, (boolean)false, (Configuration)fs$1.getConf());
    }

    public static final /* synthetic */ boolean $anonfun$backupFiles$7(boolean x) {
        return BoxesRunTime.unboxToBoolean((Object)Predef$.MODULE$.identity((Object)BoxesRunTime.boxToBoolean((boolean)x)));
    }

    public static final /* synthetic */ Try $anonfun$backupFiles$2(Path backupDirPath$1, Seq filesToBackup$1, Path dataPath$1, FileSystem fs$1, boolean exists) {
        Failure failure;
        if (exists) {
            failure = new Failure((Throwable)new IllegalStateException(new StringBuilder(35).append("Backup directory '").append(backupDirPath$1).append("' already exists!").toString()));
        } else if (filesToBackup$1.isEmpty()) {
            MODULE$.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(29).append("Nothing to backup, skipping: ").append(dataPath$1).toString());
            failure = new Success((Object)backupDirPath$1);
        } else {
            MODULE$.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(23).append("Backupping files ").append(filesToBackup$1.mkString("\n", "\n", "")).append(" to '").append(backupDirPath$1.toString()).append("'").toString());
            failure = GdprUtils$.MODULE$.traverseTry(filesToBackup$1, (Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)HdfsUtils$.$anonfun$backupFiles$5(dataPath$1, backupDirPath$1, fs$1, f))).flatMap((Function1 & Serializable & scala.Serializable)moves -> GdprUtils$.MODULE$.recoverFsOperation(moves.forall((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToBoolean((boolean)HdfsUtils$.$anonfun$backupFiles$7(BoxesRunTime.unboxToBoolean((Object)x)))), new StringBuilder(24).append("Cannot copy files into '").append(backupDirPath$1).toString()).map((Function1 & Serializable & scala.Serializable)_ -> backupDirPath$1));
        }
        return failure.map((Function1 & Serializable & scala.Serializable)backupPath -> backupPath);
    }

    public static final /* synthetic */ Try $anonfun$deletePath$3(Path sourcePath$1, boolean x0$1) {
        Success success;
        boolean bl = x0$1;
        if (bl) {
            success = new Success((Object)BoxedUnit.UNIT);
        } else if (!bl) {
            success = new Failure((Throwable)new IllegalStateException(new StringBuilder(26).append("Impossible to delete path ").append(sourcePath$1.toUri().toString()).toString()));
        } else {
            throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl));
        }
        return success;
    }

    public static final /* synthetic */ Try $anonfun$foldIterator$2(Function1 exitPath$1, Object accOk$1, RemoteIterator iterator$1, Function2 f$1, Try acc$1, boolean hasNext) {
        Try try_;
        if (hasNext && !BoxesRunTime.unboxToBoolean((Object)exitPath$1.apply(accOk$1))) {
            Try newAcc = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> iterator$1.next()).flatMap((Function1 & Serializable & scala.Serializable)t -> Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> f$1.apply(accOk$1, t)).map((Function1 & Serializable & scala.Serializable)newB -> newB));
            try_ = MODULE$.foldIterator(iterator$1, newAcc, f$1, exitPath$1);
        } else {
            try_ = acc$1;
        }
        return try_;
    }

    private HdfsUtils$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
    }
}

