/*
 * Decompiled with CFR 0.152.
 */
package it.agilelab.bigdata.wasp.consumers.spark.strategies.gdpr.hdfs;

import it.agilelab.bigdata.wasp.consumers.spark.strategies.gdpr.config.HdfsDeletionConfig;
import it.agilelab.bigdata.wasp.consumers.spark.strategies.gdpr.utils.GdprUtils$;
import it.agilelab.bigdata.wasp.consumers.spark.strategies.gdpr.utils.hdfs.HdfsUtils$;
import it.agilelab.bigdata.wasp.core.logging.Logging;
import it.agilelab.bigdata.wasp.core.logging.WaspLogger;
import it.agilelab.bigdata.wasp.models.RawModel;
import it.agilelab.bigdata.wasp.models.RawOptions;
import java.io.Serializable;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.functions$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\u0005Mc\u0001B\u0007\u000f\u0001\u0005B\u0001\u0002\r\u0001\u0003\u0002\u0003\u0006I!\r\u0005\ty\u0001\u0011\t\u0011)A\u0005{!AQ\u0003\u0001B\u0001B\u0003%!\tC\u0003J\u0001\u0011\u0005!\nC\u0004Q\u0001\t\u0007I\u0011A)\t\rU\u0003\u0001\u0015!\u0003S\u0011\u001d1\u0006A1A\u0005\u0002ECaa\u0016\u0001!\u0002\u0013\u0011\u0006\"\u0002-\u0001\t\u0003I\u0006\"B=\u0001\t\u0013Q\bbBA\f\u0001\u0011%\u0011\u0011\u0004\u0005\b\u0003k\u0001A\u0011BA\u001c\u0005MAEMZ:EK2,G/[8o\u0011\u0006tG\r\\3s\u0015\ty\u0001#\u0001\u0003iI\u001a\u001c(BA\t\u0013\u0003\u00119G\r\u001d:\u000b\u0005M!\u0012AC:ue\u0006$XmZ5fg*\u0011QCF\u0001\u0006gB\f'o\u001b\u0006\u0003/a\t\u0011bY8ogVlWM]:\u000b\u0005eQ\u0012\u0001B<bgBT!a\u0007\u000f\u0002\u000f\tLw\rZ1uC*\u0011QDH\u0001\tC\u001eLG.\u001a7bE*\tq$\u0001\u0002ji\u000e\u00011c\u0001\u0001#QA\u00111EJ\u0007\u0002I)\tQ%A\u0003tG\u0006d\u0017-\u0003\u0002(I\t1\u0011I\\=SK\u001a\u0004\"!\u000b\u0018\u000e\u0003)R!a\u000b\u0017\u0002\u000f1|wmZ5oO*\u0011Q\u0006G\u0001\u0005G>\u0014X-\u0003\u00020U\t9Aj\\4hS:<\u0017A\u00014t!\t\u0011$(D\u00014\u0015\t\u0001DG\u0003\u00026m\u00051\u0001.\u00193p_BT!a\u000e\u001d\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005I\u0014aA8sO&\u00111h\r\u0002\u000b\r&dWmU=ti\u0016l\u0017AB2p]\u001aLw\r\u0005\u0002?\u00016\tqH\u0003\u0002=!%\u0011\u0011i\u0010\u0002\u0013\u0011\u001247\u000fR3mKRLwN\\\"p]\u001aLw\r\u0005\u0002D\u000f6\tAI\u0003\u0002F\r\u0006\u00191/\u001d7\u000b\u0005U1\u0014B\u0001%E\u00051\u0019\u0006/\u0019:l'\u0016\u001c8/[8o\u0003\u0019a\u0014N\\5u}Q!1*\u0014(P!\ta\u0005!D\u0001\u000f\u0011\u0015\u0001D\u00011\u00012\u0011\u0015aD\u00011\u0001>\u0011\u0015)B\u00011\u0001C\u0003!!\u0017\r^1QCRDW#\u0001*\u0011\u0005I\u001a\u0016B\u0001+4\u0005\u0011\u0001\u0016\r\u001e5\u0002\u0013\u0011\fG/\u0019)bi\"\u0004\u0013aC:uC\u001eLgn\u001a)bi\"\fAb\u001d;bO&tw\rU1uQ\u0002\na\u0001Z3mKR,GC\u0001.d!\rYf\fY\u0007\u00029*\u0011Q\fJ\u0001\u0005kRLG.\u0003\u0002`9\n\u0019AK]=\u0011\u0005\r\n\u0017B\u00012%\u0005\u0011)f.\u001b;\t\u000b\u0011L\u0001\u0019A3\u0002\u001b\u0019LG.Z:U_\u001aKG\u000e^3s!\r1g.\u001d\b\u0003O2t!\u0001[6\u000e\u0003%T!A\u001b\u0011\u0002\rq\u0012xn\u001c;?\u0013\u0005)\u0013BA7%\u0003\u001d\u0001\u0018mY6bO\u0016L!a\u001c9\u0003\t1K7\u000f\u001e\u0006\u0003[\u0012\u0002\"A\u001d<\u000f\u0005M$\bC\u00015%\u0013\t)H%\u0001\u0004Qe\u0016$WMZ\u0005\u0003ob\u0014aa\u0015;sS:<'BA;%\u0003Q1\u0017\u000e\u001c;feJ{wo\u001d+p\u001b\u0006Lg\u000e^1j]R\u001910a\u0005\u0011\u0007q\fiAD\u0002~\u0003\u0017q1A`A\u0005\u001d\ry\u0018q\u0001\b\u0005\u0003\u0003\t)AD\u0002i\u0003\u0007I\u0011!O\u0005\u0003oaJ!!\u0006\u001c\n\u0005\u00153\u0015BA7E\u0013\u0011\ty!!\u0005\u0003\u0013\u0011\u000bG/\u0019$sC6,'BA7E\u0011\u0019\t)B\u0003a\u0001w\u0006QAM\u001a+p\r&dG/\u001a:\u0002AI,\u0017\r\u001a*bo6{G-\u001a7XSRD\u0007+\u0019:uSRLwN\\\"pYVlgn\u001d\u000b\u0007\u00037\t\u0019#!\n\u0015\t\u0005u\u0011q\u0004\t\u00047z[\bBBA\u0011\u0017\u0001\u0007\u0011/A\u0002ve&DQ!F\u0006A\u0002\tCq!a\n\f\u0001\u0004\tI#\u0001\u0005sC^lu\u000eZ3m!\u0011\tY#!\r\u000e\u0005\u00055\"bAA\u00181\u00051Qn\u001c3fYNLA!a\r\u0002.\tA!+Y<N_\u0012,G.A\nsK:\fW.Z!oI\u0006\u001b7-^7vY\u0006$X\r\u0006\u0004\u0002:\u0005=\u0013\u0011\u000b\u000b\u0007\u0003w\t\t%!\u0012\u0011\u0007\r\ni$C\u0002\u0002@\u0011\u0012qAQ8pY\u0016\fg\u000eC\u0004\u0002D1\u0001\r!a\u000f\u0002\u0007\u0005\u001c7\rC\u0004\u0002H1\u0001\r!!\u0013\u0002\t\u0019LG.\u001a\t\u0004e\u0005-\u0013bAA'g\t\tBj\\2bi\u0016$g)\u001b7f'R\fG/^:\t\u000bYc\u0001\u0019\u0001*\t\u000bAc\u0001\u0019\u0001*")
public class HdfsDeletionHandler
implements Logging {
    private final FileSystem fs;
    private final HdfsDeletionConfig config;
    private final SparkSession spark;
    private final Path dataPath;
    private final Path stagingPath;
    private final WaspLogger logger;

    public WaspLogger logger() {
        return this.logger;
    }

    public void it$agilelab$bigdata$wasp$core$logging$Logging$_setter_$logger_$eq(WaspLogger x$1) {
        this.logger = x$1;
    }

    public Path dataPath() {
        return this.dataPath;
    }

    public Path stagingPath() {
        return this.stagingPath;
    }

    public Try<BoxedUnit> delete(List<String> filesToFilter) {
        Success success;
        List<String> list = filesToFilter;
        if (Nil$.MODULE$.equals(list)) {
            Seq$.MODULE$.empty();
            success = new Success((Object)BoxedUnit.UNIT);
        } else {
            success = GdprUtils$.MODULE$.traverseWithTry(list, (Function1 & Serializable & scala.Serializable)uri -> this.readRawModelWithPartitionColumns($this.spark, $this.config.rawModel(), (String)uri)).flatMap((Function1 & Serializable & scala.Serializable)readDF -> Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> (Dataset)readDF.reduce((Function2 & Serializable & scala.Serializable)(x$1, x$2) -> x$1.union(x$2))).map((Function1 & Serializable & scala.Serializable)dfToFilter -> {
                Dataset<Row> dfToWrite = this.filterRowsToMaintain((Dataset<Row>)dfToFilter);
                return new Tuple2(dfToFilter, dfToWrite);
            }).flatMap((Function1 & Serializable & scala.Serializable)x$3 -> {
                Tuple2 tuple2 = x$3;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Dataset dfToWrite = (Dataset)tuple2._2();
                String x$1 = $this.config.stagingDirUri();
                String x$2 = $this.config.rawModel().copy$default$1();
                boolean x$32 = $this.config.rawModel().copy$default$3();
                String x$4 = $this.config.rawModel().copy$default$4();
                RawOptions x$5 = $this.config.rawModel().copy$default$5();
                Try try_ = HdfsUtils$.MODULE$.writeRawModel($this.config.rawModel().copy(x$2, x$1, x$32, x$4, x$5), (Dataset<Row>)dfToWrite).flatMap((Function1 & Serializable & scala.Serializable)_ -> GdprUtils$.MODULE$.traverseTry(filesToFilter, (Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)this.fs.delete(new Path(f), false))).flatMap((Function1 & Serializable & scala.Serializable)deletion -> GdprUtils$.MODULE$.recoverFsOperation(deletion.forall((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToBoolean((boolean)HdfsDeletionHandler.$anonfun$delete$10(BoxesRunTime.unboxToBoolean((Object)x)))), "Error during deletion").flatMap((Function1 & Serializable & scala.Serializable)_ -> Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> $this.fs.listFiles(this.stagingPath(), true)).flatMap((Function1 & Serializable & scala.Serializable)iterator -> HdfsUtils$.MODULE$.foldIterator(iterator, new Success((Object)BoxesRunTime.boxToBoolean((boolean)true)), (Function2 & Serializable & scala.Serializable)(acc, file) -> BoxesRunTime.boxToBoolean((boolean)this.renameAndAccumulate(this.stagingPath(), this.dataPath(), BoxesRunTime.unboxToBoolean((Object)acc), file)), (Function1 & Serializable & scala.Serializable)b -> BoxesRunTime.boxToBoolean((boolean)HdfsDeletionHandler.$anonfun$delete$15(BoxesRunTime.unboxToBoolean((Object)b)))).flatMap((Function1 & Serializable & scala.Serializable)renameResult -> HdfsDeletionHandler.$anonfun$delete$16(this, BoxesRunTime.unboxToBoolean((Object)renameResult)))))));
                return try_;
            }));
        }
        return success;
    }

    private Dataset<Row> filterRowsToMaintain(Dataset<Row> dfToFilter) {
        return dfToFilter.where(this.config.rawMatchingCondition().and(this.config.partitionPruningCondition()).unary_$bang());
    }

    private Try<Dataset<Row>> readRawModelWithPartitionColumns(SparkSession spark, RawModel rawModel, String uri) {
        String x$1 = uri;
        String x$2 = rawModel.copy$default$1();
        boolean x$3 = rawModel.copy$default$3();
        String x$4 = rawModel.copy$default$4();
        RawOptions x$5 = rawModel.copy$default$5();
        return HdfsUtils$.MODULE$.readRawModel(rawModel.copy(x$2, x$1, x$3, x$4, x$5), spark).map((Function1 & Serializable & scala.Serializable)df -> (Dataset)HdfsUtils$.MODULE$.findPartitionColumns(uri).foldLeft(df, (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2;
            Dataset accDf;
            block3: {
                Tuple2 tuple22;
                block2: {
                    tuple22 = new Tuple2(x0$1, x1$1);
                    if (tuple22 == null) break block2;
                    accDf = (Dataset)tuple22._1();
                    tuple2 = (Tuple2)tuple22._2();
                    if (tuple2 != null) break block3;
                }
                throw new MatchError((Object)tuple22);
            }
            String colName = (String)tuple2._1();
            String colValue = (String)tuple2._2();
            Dataset dataset = accDf.withColumn(colName, functions$.MODULE$.lit((Object)colValue));
            return dataset;
        }));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean renameAndAccumulate(Path stagingPath, Path dataPath, boolean acc, LocatedFileStatus file) {
        if (!file.isDirectory()) {
            String string = file.getPath().getName();
            String string2 = "_SUCCESS";
            if (string == null ? string2 != null : !string.equals(string2)) {
                Path newPath = HdfsUtils$.MODULE$.replacePathPrefix(file.getPath(), stagingPath, dataPath);
                if (!this.fs.rename(file.getPath(), newPath)) return false;
                if (!acc) return false;
                return true;
            }
        }
        boolean bl = acc;
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$delete$10(boolean x) {
        return BoxesRunTime.unboxToBoolean((Object)Predef$.MODULE$.identity((Object)BoxesRunTime.boxToBoolean((boolean)x)));
    }

    public static final /* synthetic */ boolean $anonfun$delete$15(boolean b) {
        return !b;
    }

    public static final /* synthetic */ void $anonfun$delete$18(BoxedUnit _) {
    }

    public static final /* synthetic */ Try $anonfun$delete$16(HdfsDeletionHandler $this, boolean renameResult) {
        return GdprUtils$.MODULE$.recoverFsOperation(renameResult, "Error while moving files from staging dir to data dir").flatMap((Function1 & Serializable & scala.Serializable)_2 -> HdfsUtils$.MODULE$.deletePath($this.fs, $this.stagingPath()).map((Function1 & Serializable & scala.Serializable)_ -> {
            HdfsDeletionHandler.$anonfun$delete$18(_);
            return BoxedUnit.UNIT;
        }));
    }

    public HdfsDeletionHandler(FileSystem fs, HdfsDeletionConfig config, SparkSession spark) {
        this.fs = fs;
        this.config = config;
        this.spark = spark;
        Logging.$init$((Logging)this);
        this.dataPath = new Path(config.rawModel().uri());
        this.stagingPath = new Path(config.stagingDirUri());
    }
}

