/*
 * Decompiled with CFR 0.152.
 */
package it.agilelab.bigdata.wasp.consumers.spark.strategies.gdpr.config;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigException;
import it.agilelab.bigdata.wasp.consumers.spark.strategies.gdpr.KeyWithCorrelation;
import it.agilelab.bigdata.wasp.consumers.spark.strategies.gdpr.RowKeyWithCorrelation;
import it.agilelab.bigdata.wasp.consumers.spark.strategies.gdpr.config.HBaseDeletionConfig;
import it.agilelab.bigdata.wasp.consumers.spark.strategies.gdpr.exception.ConfigExceptions;
import it.agilelab.bigdata.wasp.consumers.spark.strategies.gdpr.utils.ConfigUtils$;
import it.agilelab.bigdata.wasp.consumers.spark.strategies.gdpr.utils.GdprUtils$;
import it.agilelab.bigdata.wasp.core.logging.Logging;
import it.agilelab.bigdata.wasp.core.logging.WaspLogger;
import it.agilelab.bigdata.wasp.models.ExactKeyValueMatchingStrategy;
import it.agilelab.bigdata.wasp.models.KeyValueDataStoreConf;
import it.agilelab.bigdata.wasp.models.KeyValueMatchingStrategy;
import it.agilelab.bigdata.wasp.models.KeyValueModel$;
import it.agilelab.bigdata.wasp.models.PrefixAndTimeBoundKeyValueMatchingStrategy;
import it.agilelab.bigdata.wasp.models.PrefixKeyValueMatchingStrategy;
import it.agilelab.bigdata.wasp.models.configuration.HBaseConfigModel;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterList;
import org.apache.hadoop.hbase.filter.FirstKeyOnlyFilter;
import org.apache.hadoop.hbase.filter.KeyOnlyFilter;
import org.apache.hadoop.hbase.filter.PrefixFilter;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.spark.rdd.RDD;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple5;
import scala.collection.GenTraversableOnce;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

public final class HBaseDeletionConfig$
implements Logging,
scala.Serializable {
    public static HBaseDeletionConfig$ MODULE$;
    private final String KV_CONF_KEY;
    private final String KEYS_TO_DELETE_KEY;
    private final String CORRELATION_ID_KEY;
    private final String START_PERIOD_KEY;
    private final String END_PERIOD_KEY;
    private final String TIMEZONE_PERIOD_KEY;
    private final String BATCH_SIZE;
    private final String dryRun;
    private final WaspLogger logger;

    static {
        new HBaseDeletionConfig$();
    }

    public WaspLogger logger() {
        return this.logger;
    }

    public void it$agilelab$bigdata$wasp$core$logging$Logging$_setter_$logger_$eq(WaspLogger x$1) {
        this.logger = x$1;
    }

    public String KV_CONF_KEY() {
        return this.KV_CONF_KEY;
    }

    public String KEYS_TO_DELETE_KEY() {
        return this.KEYS_TO_DELETE_KEY;
    }

    public String CORRELATION_ID_KEY() {
        return this.CORRELATION_ID_KEY;
    }

    public String START_PERIOD_KEY() {
        return this.START_PERIOD_KEY;
    }

    public String END_PERIOD_KEY() {
        return this.END_PERIOD_KEY;
    }

    public String TIMEZONE_PERIOD_KEY() {
        return this.TIMEZONE_PERIOD_KEY;
    }

    public String BATCH_SIZE() {
        return this.BATCH_SIZE;
    }

    public String dryRun() {
        return this.dryRun;
    }

    public HBaseDeletionConfig create(Config rootConfig, KeyValueDataStoreConf keyValueDataStoreConf, RDD<KeyWithCorrelation> inputKeys, Option<HBaseConfigModel> hBaseConfigModel) {
        String value;
        RDD<Tuple2<RowKeyWithCorrelation, Scan>> rDD;
        Option<Config> maybeConfig = ConfigUtils$.MODULE$.getOptionalConfig(rootConfig, this.KV_CONF_KEY());
        RDD rowKeys = ConfigUtils$.MODULE$.keysToDeleteRDD(inputKeys, maybeConfig, this.KEYS_TO_DELETE_KEY(), this.CORRELATION_ID_KEY()).distinct().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            KeyWithCorrelation keyWithCorrelation = x0$1;
            if (keyWithCorrelation == null) {
                throw new MatchError((Object)keyWithCorrelation);
            }
            String key = keyWithCorrelation.key();
            String correlationId = keyWithCorrelation.correlationId();
            RowKeyWithCorrelation rowKeyWithCorrelation = new RowKeyWithCorrelation(GdprUtils$.MODULE$.StringToRowKey(key).asRowKey(), correlationId);
            return rowKeyWithCorrelation;
        }, ClassTag$.MODULE$.apply(RowKeyWithCorrelation.class));
        KeyValueMatchingStrategy keyValueMatchingStrategy = keyValueDataStoreConf.keyValueMatchingStrategy();
        if (keyValueMatchingStrategy instanceof ExactKeyValueMatchingStrategy) {
            rDD = this.scanExact((RDD<RowKeyWithCorrelation>)rowKeys, maybeConfig);
        } else if (keyValueMatchingStrategy instanceof PrefixKeyValueMatchingStrategy) {
            rDD = this.scanPrefix((RDD<RowKeyWithCorrelation>)rowKeys, maybeConfig);
        } else if (keyValueMatchingStrategy instanceof PrefixAndTimeBoundKeyValueMatchingStrategy) {
            Config x;
            PrefixAndTimeBoundKeyValueMatchingStrategy prefixAndTimeBoundKeyValueMatchingStrategy = (PrefixAndTimeBoundKeyValueMatchingStrategy)keyValueMatchingStrategy;
            Option<Config> option = maybeConfig;
            if (!(option instanceof Some)) {
                if (None$.MODULE$.equals(option)) {
                    throw new ConfigExceptions.KeyValueConfigException(new ConfigException.Missing(this.KV_CONF_KEY()), "Missing mandatory configuration key");
                }
                throw new MatchError(option);
            }
            Some some = (Some)option;
            Config config = x = (Config)some.value();
            Config config2 = config;
            rDD = this.scanPrefixWithTime(config2, (RDD<RowKeyWithCorrelation>)rowKeys, prefixAndTimeBoundKeyValueMatchingStrategy);
        } else {
            throw new MatchError((Object)keyValueMatchingStrategy);
        }
        RDD<Tuple2<RowKeyWithCorrelation, Scan>> keysWithScan = rDD;
        Try try_ = KeyValueModel$.MODULE$.extractTableName(keyValueDataStoreConf.keyValueModel().tableCatalog());
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable exception = failure.exception();
            throw new ConfigExceptions.KeyValueConfigException(exception, "Impossible to extract HBase table name from KeyValueModel");
        }
        if (!(try_ instanceof Success)) {
            throw new MatchError((Object)try_);
        }
        Success success = (Success)try_;
        String string = value = (String)success.value();
        String tableName = string;
        return new HBaseDeletionConfig((RDD<Tuple2<KeyWithCorrelation, Scan>>)keysWithScan.map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            RowKeyWithCorrelation rowKeyWithCorrelation = (RowKeyWithCorrelation)tuple2._1();
            Scan scan = (Scan)tuple2._2();
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)rowKeyWithCorrelation.asKey()), (Object)scan);
            return tuple22;
        }, ClassTag$.MODULE$.apply(Tuple2.class)), tableName, hBaseConfigModel, keyValueDataStoreConf.keyValueMatchingStrategy(), BoxesRunTime.unboxToBoolean((Object)maybeConfig.flatMap((Function1 & Serializable & scala.Serializable)x$5 -> ConfigUtils$.MODULE$.getOptionalBoolean((Config)x$5, MODULE$.dryRun())).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false)));
    }

    private RDD<Tuple2<RowKeyWithCorrelation, Scan>> scanExact(RDD<RowKeyWithCorrelation> keysToDelete, Option<Config> conf) {
        return keysToDelete.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            RowKeyWithCorrelation rowKeyWithCorrelation = x0$1;
            if (rowKeyWithCorrelation == null) {
                throw new MatchError((Object)rowKeyWithCorrelation);
            }
            byte[] rowKey = rowKeyWithCorrelation.rowKey();
            Scan scan = new Scan().withStartRow(rowKey).withStopRow(rowKey);
            conf.foreach((Function1 & Serializable & scala.Serializable)x$6 -> {
                HBaseDeletionConfig$.$anonfun$scanExact$2(scan, x$6);
                return BoxedUnit.UNIT;
            });
            Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)rowKeyWithCorrelation), (Object)scan.setFilter((Filter)new FilterList(new Filter[]{new KeyOnlyFilter(), new FirstKeyOnlyFilter()})));
            return tuple2;
        }, ClassTag$.MODULE$.apply(Tuple2.class));
    }

    private RDD<Tuple2<RowKeyWithCorrelation, Scan>> scanPrefix(RDD<RowKeyWithCorrelation> keysToDelete, Option<Config> conf) {
        return keysToDelete.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            RowKeyWithCorrelation rowKeyWithCorrelation = x0$1;
            if (rowKeyWithCorrelation == null) {
                throw new MatchError((Object)rowKeyWithCorrelation);
            }
            byte[] rowKey = rowKeyWithCorrelation.rowKey();
            Scan scan = new Scan().withStartRow(rowKey).withStopRow((byte[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(rowKey)).$plus$plus((GenTraversableOnce)new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(new byte[]{127})), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Byte())));
            conf.foreach((Function1 & Serializable & scala.Serializable)x$7 -> {
                HBaseDeletionConfig$.$anonfun$scanPrefix$2(scan, x$7);
                return BoxedUnit.UNIT;
            });
            Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)rowKeyWithCorrelation), (Object)scan.setFilter((Filter)new FilterList(new Filter[]{new PrefixFilter(rowKey)})));
            return tuple2;
        }, ClassTag$.MODULE$.apply(Tuple2.class));
    }

    private RDD<Tuple2<RowKeyWithCorrelation, Scan>> scanPrefixWithTime(Config config, RDD<RowKeyWithCorrelation> keysToDelete, PrefixAndTimeBoundKeyValueMatchingStrategy matchingStrategy) {
        ZoneId zoneId;
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(matchingStrategy.pattern(), Locale.forLanguageTag(matchingStrategy.locale()));
        long startDate = BoxesRunTime.unboxToLong(this.wrapConfigException((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> config.getLong(MODULE$.START_PERIOD_KEY())));
        long endDate = BoxesRunTime.unboxToLong(this.wrapConfigException((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> config.getLong(MODULE$.END_PERIOD_KEY())));
        try {
            zoneId = ZoneId.of(config.getString(this.TIMEZONE_PERIOD_KEY()));
        }
        catch (ConfigException.Missing missing) {
            zoneId = ZoneId.of("UTC");
        }
        ZoneId zoneId2 = zoneId;
        String startDateString = this.formatMillis(formatter, startDate, zoneId2);
        String endDateString = this.formatMillis(formatter, endDate, zoneId2);
        byte[] startDateBytes = Bytes.toBytes((String)startDateString);
        byte[] endDateBytes = Bytes.toBytes((String)endDateString);
        return keysToDelete.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            RowKeyWithCorrelation rowKeyWithCorrelation = x0$1;
            if (rowKeyWithCorrelation == null) {
                throw new MatchError((Object)rowKeyWithCorrelation);
            }
            byte[] rowKey = rowKeyWithCorrelation.rowKey();
            byte[] startRow = (byte[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps((byte[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps((byte[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(rowKey)).$plus$plus((GenTraversableOnce)new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(Bytes.toBytes((String)matchingStrategy.separator()))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Byte())))).$plus$plus((GenTraversableOnce)new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(startDateBytes)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Byte())))).$colon$plus((Object)BoxesRunTime.boxToByte((byte)((byte)0)), ClassTag$.MODULE$.Byte());
            byte[] stopRow = (byte[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps((byte[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps((byte[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(rowKey)).$plus$plus((GenTraversableOnce)new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(Bytes.toBytes((String)matchingStrategy.separator()))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Byte())))).$plus$plus((GenTraversableOnce)new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(endDateBytes)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Byte())))).$colon$plus((Object)BoxesRunTime.boxToByte((byte)((byte)255)), ClassTag$.MODULE$.Byte());
            MODULE$.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(29).append("Scan start: '").append(new String(startRow, StandardCharsets.UTF_8)).append("', scan stop: '").append(new String(stopRow, StandardCharsets.UTF_8)).append("'").toString());
            Scan scan = new Scan().withStartRow(startRow).withStopRow(stopRow);
            Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)rowKeyWithCorrelation), (Object)scan.setFilter((Filter)new FilterList(new Filter[]{new KeyOnlyFilter()})));
            return tuple2;
        }, ClassTag$.MODULE$.apply(Tuple2.class));
    }

    private String formatMillis(DateTimeFormatter formatter, long millis, ZoneId zoneId) {
        Instant instant = Instant.ofEpochMilli(millis);
        ZonedDateTime zonedDateTime = ZonedDateTime.ofInstant(instant, zoneId);
        return formatter.format(zonedDateTime);
    }

    private <T> T wrapConfigException(Function0<T> value) {
        Object object;
        try {
            object = value.apply();
        }
        catch (ConfigException e) {
            throw new ConfigExceptions.KeyValueConfigException(e, "Missing mandatory configuration key`");
        }
        return (T)object;
    }

    public HBaseDeletionConfig apply(RDD<Tuple2<KeyWithCorrelation, Scan>> keysWithScan, String tableName, Option<HBaseConfigModel> hbaseConfigModel, KeyValueMatchingStrategy keyValueMatchingStrategy, boolean dryRun) {
        return new HBaseDeletionConfig(keysWithScan, tableName, hbaseConfigModel, keyValueMatchingStrategy, dryRun);
    }

    public Option<Tuple5<RDD<Tuple2<KeyWithCorrelation, Scan>>, String, Option<HBaseConfigModel>, KeyValueMatchingStrategy, Object>> unapply(HBaseDeletionConfig x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple5(x$0.keysWithScan(), (Object)x$0.tableName(), x$0.hbaseConfigModel(), (Object)x$0.keyValueMatchingStrategy(), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.dryRun())));
    }

    private Object readResolve() {
        return MODULE$;
    }

    public static final /* synthetic */ void $anonfun$scanExact$2(Scan scan$1, Config x$6) {
        ConfigUtils$.MODULE$.getOptionalInt(x$6, MODULE$.BATCH_SIZE()).foreach((Function1 & Serializable & scala.Serializable)x$1 -> scan$1.setBatch(BoxesRunTime.unboxToInt((Object)x$1)));
    }

    public static final /* synthetic */ void $anonfun$scanPrefix$2(Scan scan$2, Config x$7) {
        ConfigUtils$.MODULE$.getOptionalInt(x$7, MODULE$.BATCH_SIZE()).foreach((Function1 & Serializable & scala.Serializable)x$1 -> scan$2.setBatch(BoxesRunTime.unboxToInt((Object)x$1)));
    }

    private HBaseDeletionConfig$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
        this.KV_CONF_KEY = "hbase";
        this.KEYS_TO_DELETE_KEY = "keys";
        this.CORRELATION_ID_KEY = "correlationId";
        this.START_PERIOD_KEY = "start";
        this.END_PERIOD_KEY = "end";
        this.TIMEZONE_PERIOD_KEY = "timeZone";
        this.BATCH_SIZE = "batchSize";
        this.dryRun = "dryRun";
    }
}

