/*
 * Decompiled with CFR 0.152.
 */
package it.agilelab.bigdata.wasp.aws.auth.v2;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.WebIdentityFederationSessionCredentialsProvider;
import com.amazonaws.services.securitytoken.model.ExpiredTokenException;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.hadoop.conf.Configuration;

public class WebIdentityProvider
implements AWSCredentialsProvider {
    private final Path tokenFile;
    private final String role;
    WebIdentityFederationSessionCredentialsProvider provider;
    private static String TOKEN_FILE_KEY = "fs.s3a.assumed.role.web.tokenfile";
    private static String TOKEN_FILE_DEFAULT = "/var/run/secrets/eks.amazonaws.com/serviceaccount/token";
    private static String ROLE_ARN = "fs.s3a.assumed.role.web.role.arn";
    private final Object lock = new Object();

    public WebIdentityProvider(URI uRI, Configuration configuration) throws IOException {
        this.tokenFile = Paths.get(configuration.get(TOKEN_FILE_KEY, TOKEN_FILE_DEFAULT), new String[0]);
        this.role = configuration.get(ROLE_ARN);
        this.provider = this.instantiate(this.tokenFile, this.role);
    }

    public WebIdentityFederationSessionCredentialsProvider instantiate(Path path, String string) throws IOException {
        if (!Files.exists(path, new LinkOption[0])) {
            throw new IOException("Token file [" + path + "] not found");
        }
        String string2 = new String(Files.readAllBytes(path), StandardCharsets.UTF_8);
        return new WebIdentityFederationSessionCredentialsProvider(string2, null, string);
    }

    public AWSCredentials getCredentials() {
        Object object = this.lock;
        synchronized (object) {
            try {
                return this.provider.getCredentials();
            }
            catch (ExpiredTokenException expiredTokenException) {
                try {
                    this.provider = this.instantiate(this.tokenFile, this.role);
                    return this.provider.getCredentials();
                }
                catch (IOException iOException) {
                    throw new RuntimeException("Could not instantiate provider");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        Object object = this.lock;
        synchronized (object) {
            this.provider.refresh();
        }
    }
}

