/*
 * Decompiled with CFR 0.152.
 */
package it.agilelab.bigdata.wasp.aws.auth.v2;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import it.agilelab.bigdata.wasp.aws.auth.v2.ConfigurationLoader;
import it.agilelab.bigdata.wasp.aws.auth.v2.DriverSideAssumeRoleCredentialsProvider;
import it.agilelab.bigdata.wasp.aws.auth.v2.ExecutorSideAssumeRoleCredentialsProvider;
import java.io.IOException;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlacementAwareCredentialsProvider
implements AWSCredentialsProvider {
    private final Logger logger = LoggerFactory.getLogger(PlacementAwareCredentialsProvider.class);
    AWSCredentialsProvider downstream;

    public PlacementAwareCredentialsProvider(URI uRI, Configuration configuration) throws IOException {
        String string = System.getProperty("sun.java.command");
        URI uRI2 = ConfigurationLoader.lookupConfig(uRI, configuration).getCheckpointBucket();
        this.logger.info("FsUri: [{}]", (Object)uRI);
        this.logger.info("CheckpointBucketUri: [{}]", (Object)uRI2);
        this.logger.info("FsUri host equals checkpointBucketUri: [{}]", (Object)uRI.getHost().equals(uRI2.getHost()));
        if (string.contains("CoarseGrainedExecutorBackend") || !uRI.getHost().equals(uRI2.getHost())) {
            this.logger.info("Instantiating {}", ExecutorSideAssumeRoleCredentialsProvider.class);
            this.downstream = new ExecutorSideAssumeRoleCredentialsProvider(uRI, configuration);
        } else {
            this.logger.info("Instantiating {}", DriverSideAssumeRoleCredentialsProvider.class);
            this.downstream = new DriverSideAssumeRoleCredentialsProvider(uRI, configuration);
        }
    }

    public AWSCredentials getCredentials() {
        return this.downstream.getCredentials();
    }

    public void refresh() {
        this.downstream.refresh();
    }
}

