/*
 * Decompiled with CFR 0.152.
 */
package it.agilelab.bigdata.wasp.aws.auth.v2;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import it.agilelab.bigdata.wasp.aws.auth.v2.ConfigurationLoader;
import it.agilelab.bigdata.wasp.aws.auth.v2.CredentialRenewer;
import it.agilelab.bigdata.wasp.aws.auth.v2.DefaultCredentialRenewer;
import java.io.IOException;
import java.net.URI;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hadoop.conf.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DriverSideAssumeRoleCredentialsProvider
implements AWSCredentialsProvider {
    Logger logger = LoggerFactory.getLogger(DriverSideAssumeRoleCredentialsProvider.class);
    private static ConcurrentHashMap<String, CredentialRenewer> renewers = new ConcurrentHashMap();
    private CredentialRenewer renewer;

    public DriverSideAssumeRoleCredentialsProvider(URI uRI, Configuration configuration) throws IOException {
        String string = uRI.getHost();
        this.renewer = renewers.computeIfAbsent(string, string2 -> {
            this.logger.info("Instantiating renewer for {}", (Object)string);
            return new DefaultCredentialRenewer(ConfigurationLoader.lookupConfig(uRI, configuration));
        });
    }

    public AWSCredentials getCredentials() {
        return this.renewer.getCredentials();
    }

    public void refresh() {
        this.renewer.refresh();
    }
}

