/*
 * Decompiled with CFR 0.152.
 */
package brave.sparkjava;

import brave.Span;
import brave.Tracer;
import brave.Tracing;
import brave.http.HttpServerHandler;
import brave.http.HttpTracing;
import spark.ExceptionHandler;
import spark.Filter;
import spark.Request;
import spark.Response;

public final class SparkTracing {
    final Tracer tracer;
    final HttpServerHandler<brave.http.HttpServerRequest, brave.http.HttpServerResponse> handler;

    public static SparkTracing create(Tracing tracing) {
        return new SparkTracing(HttpTracing.create((Tracing)tracing));
    }

    public static SparkTracing create(HttpTracing httpTracing) {
        return new SparkTracing(httpTracing);
    }

    SparkTracing(HttpTracing httpTracing) {
        this.tracer = httpTracing.tracing().tracer();
        this.handler = HttpServerHandler.create((HttpTracing)httpTracing);
    }

    public Filter before() {
        return (request, response) -> {
            Span span = this.handler.handleReceive((brave.http.HttpServerRequest)new HttpServerRequest(request));
            request.attribute(Tracer.SpanInScope.class.getName(), (Object)this.tracer.withSpanInScope(span));
        };
    }

    public Filter afterAfter() {
        return (request, response) -> {
            Span span = this.tracer.currentSpan();
            if (span == null) {
                return;
            }
            this.handler.handleSend((Object)new HttpServerResponse(response, request.requestMethod()), null, span);
            ((Tracer.SpanInScope)request.attribute(Tracer.SpanInScope.class.getName())).close();
        };
    }

    public ExceptionHandler exception(ExceptionHandler delegate) {
        return (error, request, response) -> {
            try {
                delegate.handle(error, request, response);
            }
            finally {
                Span span = this.tracer.currentSpan();
                if (span != null) {
                    HttpServerResponse res = new HttpServerResponse(response, request.requestMethod());
                    this.handler.handleSend((Object)res, (Throwable)error, span);
                    ((Tracer.SpanInScope)request.attribute(Tracer.SpanInScope.class.getName())).close();
                }
            }
        };
    }

    static final class HttpServerResponse
    extends brave.http.HttpServerResponse {
        final Response delegate;
        final String method;

        HttpServerResponse(Response delegate, String method) {
            this.delegate = delegate;
            this.method = method;
        }

        public Response unwrap() {
            return this.delegate;
        }

        public String method() {
            return this.method;
        }

        public String route() {
            return null;
        }

        public int statusCode() {
            return this.delegate.status();
        }
    }

    static final class HttpServerRequest
    extends brave.http.HttpServerRequest {
        final Request delegate;

        HttpServerRequest(Request delegate) {
            this.delegate = delegate;
        }

        public Request unwrap() {
            return this.delegate;
        }

        public boolean parseClientIpAndPort(Span span) {
            return span.remoteIpAndPort(this.delegate.raw().getRemoteAddr(), this.delegate.raw().getRemotePort());
        }

        public String method() {
            return this.delegate.requestMethod();
        }

        public String path() {
            return this.delegate.pathInfo();
        }

        public String url() {
            String baseUrl = this.delegate.url();
            if (this.delegate.queryString() != null && !this.delegate.queryString().isEmpty()) {
                return baseUrl + "?" + this.delegate.queryString();
            }
            return baseUrl;
        }

        public String header(String name) {
            return this.delegate.raw().getHeader(name);
        }
    }
}

