/*
 * Decompiled with CFR 0.152.
 */
package brave.sparkjava;

import brave.Span;
import brave.Tracer;
import brave.Tracing;
import brave.http.HttpServerHandler;
import brave.http.HttpServerRequest;
import brave.http.HttpServerResponse;
import brave.http.HttpTracing;
import brave.servlet.HttpServletRequestWrapper;
import brave.servlet.HttpServletResponseWrapper;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import spark.ExceptionHandler;
import spark.Filter;

public final class SparkTracing {
    final Tracer tracer;
    final HttpServerHandler<HttpServerRequest, HttpServerResponse> handler;

    public static SparkTracing create(Tracing tracing) {
        return new SparkTracing(HttpTracing.create((Tracing)tracing));
    }

    public static SparkTracing create(HttpTracing httpTracing) {
        return new SparkTracing(httpTracing);
    }

    SparkTracing(HttpTracing httpTracing) {
        this.tracer = httpTracing.tracing().tracer();
        this.handler = HttpServerHandler.create((HttpTracing)httpTracing);
    }

    public Filter before() {
        return (request, response) -> {
            Span span = this.handler.handleReceive(HttpServletRequestWrapper.create((HttpServletRequest)request.raw()));
            request.attribute(Tracer.SpanInScope.class.getName(), (Object)this.tracer.withSpanInScope(span));
        };
    }

    public Filter afterAfter() {
        return (req, res) -> {
            Span span = this.tracer.currentSpan();
            if (span == null) {
                return;
            }
            HttpServerResponse response = HttpServletResponseWrapper.create((HttpServletRequest)req.raw(), (HttpServletResponse)res.raw(), null);
            this.handler.handleSend((Object)response, response.error(), span);
            ((Tracer.SpanInScope)req.attribute(Tracer.SpanInScope.class.getName())).close();
        };
    }

    public ExceptionHandler exception(ExceptionHandler delegate) {
        return (error, req, res) -> {
            try {
                delegate.handle(error, req, res);
            }
            finally {
                Span span = this.tracer.currentSpan();
                if (span != null) {
                    HttpServerResponse response = HttpServletResponseWrapper.create((HttpServletRequest)req.raw(), (HttpServletResponse)res.raw(), (Throwable)error);
                    this.handler.handleSend((Object)response, response.error(), span);
                    ((Tracer.SpanInScope)req.attribute(Tracer.SpanInScope.class.getName())).close();
                }
            }
        };
    }
}

