/*
 * Decompiled with CFR 0.152.
 */
package brave.sparkjava;

import brave.Span;
import brave.Tracer;
import brave.Tracing;
import brave.http.HttpServerAdapter;
import brave.http.HttpServerHandler;
import brave.http.HttpTracing;
import brave.propagation.TraceContext;
import brave.servlet.HttpServletAdapter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import spark.ExceptionHandler;
import spark.Filter;
import spark.Request;

public final class SparkTracing {
    final Tracer tracer;
    final HttpServerHandler<HttpServletRequest, HttpServletResponse> handler;
    final TraceContext.Extractor<Request> extractor;

    public static SparkTracing create(Tracing tracing) {
        return new SparkTracing(HttpTracing.create((Tracing)tracing));
    }

    public static SparkTracing create(HttpTracing httpTracing) {
        return new SparkTracing(httpTracing);
    }

    SparkTracing(HttpTracing httpTracing) {
        this.tracer = httpTracing.tracing().tracer();
        this.handler = HttpServerHandler.create((HttpTracing)httpTracing, (HttpServerAdapter)new HttpServletAdapter());
        this.extractor = httpTracing.tracing().propagation().extractor(Request::headers);
    }

    public Filter before() {
        return (request, response) -> {
            Span span = this.handler.handleReceive(this.extractor, (Object)request, (Object)request.raw());
            request.attribute(Tracer.SpanInScope.class.getName(), (Object)this.tracer.withSpanInScope(span));
        };
    }

    public Filter afterAfter() {
        return (request, response) -> {
            Span span = this.tracer.currentSpan();
            if (span == null) {
                return;
            }
            ((Tracer.SpanInScope)request.attribute(Tracer.SpanInScope.class.getName())).close();
            this.handler.handleSend((Object)response.raw(), null, span);
        };
    }

    public ExceptionHandler exception(ExceptionHandler delegate) {
        return (exception, request, response) -> {
            Span span = this.tracer.currentSpan();
            if (span != null) {
                ((Tracer.SpanInScope)request.attribute(Tracer.SpanInScope.class.getName())).close();
                this.handler.handleSend(null, (Throwable)exception, span);
            }
            delegate.handle(exception, request, response);
        };
    }
}

