/*
 * Decompiled with CFR 0.152.
 */
package brave.jms;

import brave.jms.JmsTracing;
import brave.jms.TracingServerSessionPool;
import javax.jms.ConnectionConsumer;
import javax.jms.JMSException;
import javax.jms.ServerSessionPool;

final class TracingConnectionConsumer
implements ConnectionConsumer {
    final ConnectionConsumer delegate;
    final JmsTracing jmsTracing;

    static ConnectionConsumer create(ConnectionConsumer delegate, JmsTracing jmsTracing) {
        if (delegate == null) {
            throw new NullPointerException("connectionConsumer == null");
        }
        if (delegate instanceof TracingConnectionConsumer) {
            return delegate;
        }
        return new TracingConnectionConsumer(delegate, jmsTracing);
    }

    TracingConnectionConsumer(ConnectionConsumer delegate, JmsTracing jmsTracing) {
        this.delegate = delegate;
        this.jmsTracing = jmsTracing;
    }

    public ServerSessionPool getServerSessionPool() throws JMSException {
        return TracingServerSessionPool.create(this.delegate.getServerSessionPool(), this.jmsTracing);
    }

    public void close() throws JMSException {
        this.delegate.close();
    }
}

