/*
 * Decompiled with CFR 0.152.
 */
package brave.jms;

import brave.Span;
import brave.SpanCustomizer;
import brave.Tracer;
import brave.internal.Nullable;
import brave.jms.JmsTracing;
import brave.propagation.CurrentTraceContext;
import brave.propagation.TraceContext;
import brave.propagation.TraceContextOrSamplingFlags;
import javax.jms.Destination;

abstract class TracingProducer<P, M> {
    final P delegate;
    final JmsTracing jmsTracing;
    final Tracer tracer;
    final CurrentTraceContext current;
    @Nullable
    final String remoteServiceName;

    TracingProducer(P delegate, JmsTracing jmsTracing) {
        this.delegate = delegate;
        this.jmsTracing = jmsTracing;
        this.tracer = jmsTracing.tracing.tracer();
        this.current = jmsTracing.tracing.currentTraceContext();
        this.remoteServiceName = jmsTracing.remoteServiceName;
    }

    Span createAndStartProducerSpan(Destination destination, M message) {
        Span span;
        TraceContext maybeParent = this.current.get();
        if (maybeParent == null) {
            span = this.tracer.nextSpan(this.extractAndClearMessage(message));
        } else {
            span = this.tracer.newChild(maybeParent);
            this.clearPropagationHeaders(message);
        }
        if (!span.isNoop()) {
            span.kind(Span.Kind.PRODUCER).name("send");
            if (destination == null) {
                destination = this.destination(message);
            }
            if (destination != null) {
                this.jmsTracing.tagQueueOrTopic(destination, (SpanCustomizer)span);
            }
            if (this.remoteServiceName != null) {
                span.remoteServiceName(this.remoteServiceName);
            }
            span.start();
        }
        this.addB3SingleHeader(message, span.context());
        return span;
    }

    abstract void addB3SingleHeader(M var1, TraceContext var2);

    abstract void clearPropagationHeaders(M var1);

    abstract TraceContextOrSamplingFlags extractAndClearMessage(M var1);

    @Nullable
    abstract Destination destination(M var1);
}

