/*
 * Decompiled with CFR 0.152.
 */
package com.github.kristofa.brave.grpc;

import com.github.kristofa.brave.Brave;
import com.github.kristofa.brave.IdConversion;
import com.github.kristofa.brave.KeyValueAnnotation;
import com.github.kristofa.brave.ServerRequestAdapter;
import com.github.kristofa.brave.ServerRequestInterceptor;
import com.github.kristofa.brave.ServerResponseAdapter;
import com.github.kristofa.brave.ServerResponseInterceptor;
import com.github.kristofa.brave.SpanId;
import com.github.kristofa.brave.TraceData;
import com.github.kristofa.brave.grpc.BravePropagationKeys;
import com.github.kristofa.brave.internal.Util;
import com.google.common.base.Preconditions;
import io.grpc.ForwardingServerCall;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import io.grpc.Status;
import java.util.Collection;
import java.util.Collections;

@Deprecated
public final class BraveGrpcServerInterceptor
implements ServerInterceptor {
    private final ServerRequestInterceptor serverRequestInterceptor;
    private final ServerResponseInterceptor serverResponseInterceptor;

    public static BraveGrpcServerInterceptor create(Brave brave) {
        return new Builder(brave).build();
    }

    public static Builder builder(Brave brave) {
        return new Builder(brave);
    }

    BraveGrpcServerInterceptor(Builder b) {
        this.serverRequestInterceptor = b.brave.serverRequestInterceptor();
        this.serverResponseInterceptor = b.brave.serverResponseInterceptor();
    }

    @Deprecated
    public BraveGrpcServerInterceptor(Brave brave) {
        this(BraveGrpcServerInterceptor.builder(brave));
    }

    public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(final ServerCall<ReqT, RespT> call, final Metadata requestHeaders, ServerCallHandler<ReqT, RespT> next) {
        return next.startCall((ServerCall)new ForwardingServerCall.SimpleForwardingServerCall<ReqT, RespT>(call){

            public void request(int numMessages) {
                BraveGrpcServerInterceptor.this.serverRequestInterceptor.handle(new GrpcServerRequestAdapter(call, requestHeaders));
                super.request(numMessages);
            }

            public void close(Status status, Metadata trailers) {
                BraveGrpcServerInterceptor.this.serverResponseInterceptor.handle((ServerResponseAdapter)new GrpcServerResponseAdapter(status));
                super.close(status, trailers);
            }
        }, requestHeaders);
    }

    static SpanId getSpanId(String traceId, String spanId, String parentSpanId, Boolean sampled) {
        return SpanId.builder().traceIdHigh(traceId.length() == 32 ? IdConversion.convertToLong((String)traceId, (int)0) : 0L).traceId(IdConversion.convertToLong((String)traceId)).spanId(IdConversion.convertToLong((String)spanId)).sampled(sampled).parentId(parentSpanId == null ? null : Long.valueOf(IdConversion.convertToLong((String)parentSpanId))).build();
    }

    static final class GrpcServerResponseAdapter
    implements ServerResponseAdapter {
        final Status status;

        public GrpcServerResponseAdapter(Status status) {
            this.status = status;
        }

        public Collection<KeyValueAnnotation> responseAnnotations() {
            Status.Code statusCode = this.status.getCode();
            return statusCode == Status.Code.OK ? Collections.emptyList() : Collections.singletonList(KeyValueAnnotation.create((String)"grpc.status_code", (String)statusCode.name()));
        }
    }

    static final class GrpcServerRequestAdapter<ReqT, RespT>
    implements ServerRequestAdapter {
        private final ServerCall<ReqT, RespT> call;
        private final MethodDescriptor<ReqT, RespT> method;
        private final Metadata requestHeaders;

        GrpcServerRequestAdapter(ServerCall<ReqT, RespT> call, Metadata requestHeaders) {
            this.call = (ServerCall)Preconditions.checkNotNull(call);
            this.method = (MethodDescriptor)Preconditions.checkNotNull((Object)call.getMethodDescriptor());
            this.requestHeaders = (Metadata)Preconditions.checkNotNull((Object)requestHeaders);
        }

        public TraceData getTraceData() {
            Boolean parsedSampled;
            String sampled = (String)this.requestHeaders.get(BravePropagationKeys.Sampled);
            String parentSpanId = (String)this.requestHeaders.get(BravePropagationKeys.ParentSpanId);
            String traceId = (String)this.requestHeaders.get(BravePropagationKeys.TraceId);
            String spanId = (String)this.requestHeaders.get(BravePropagationKeys.SpanId);
            Boolean bl = sampled != null ? Boolean.valueOf(sampled.equals("1") || sampled.equalsIgnoreCase("true")) : (parsedSampled = null);
            if (traceId != null && spanId != null) {
                return TraceData.create((SpanId)BraveGrpcServerInterceptor.getSpanId(traceId, spanId, parentSpanId, parsedSampled));
            }
            if (parsedSampled == null) {
                return TraceData.EMPTY;
            }
            if (parsedSampled.booleanValue()) {
                return TraceData.EMPTY;
            }
            return TraceData.NOT_SAMPLED;
        }

        public String getSpanName() {
            return this.method.getFullMethodName().toLowerCase();
        }

        public Collection<KeyValueAnnotation> requestAnnotations() {
            return Collections.emptyList();
        }
    }

    public static final class Builder {
        final Brave brave;

        Builder(Brave brave) {
            this.brave = (Brave)Util.checkNotNull((Object)brave, (String)"brave", (Object[])new Object[0]);
        }

        public BraveGrpcServerInterceptor build() {
            return new BraveGrpcServerInterceptor(this);
        }
    }
}

