/*
 * Decompiled with CFR 0.152.
 */
package com.github.kristofa.brave.grpc;

import com.github.kristofa.brave.Brave;
import com.github.kristofa.brave.IdConversion;
import com.github.kristofa.brave.KeyValueAnnotation;
import com.github.kristofa.brave.ServerRequestAdapter;
import com.github.kristofa.brave.ServerRequestInterceptor;
import com.github.kristofa.brave.ServerResponseAdapter;
import com.github.kristofa.brave.ServerResponseInterceptor;
import com.github.kristofa.brave.SpanId;
import com.github.kristofa.brave.TraceData;
import com.github.kristofa.brave.grpc.BravePropagationKeys;
import com.google.common.base.Preconditions;
import io.grpc.ForwardingServerCall;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import io.grpc.Status;
import java.net.SocketAddress;
import java.util.Collection;
import java.util.Collections;

public final class BraveGrpcServerInterceptor
implements ServerInterceptor {
    private final ServerRequestInterceptor serverRequestInterceptor;
    private final ServerResponseInterceptor serverResponseInterceptor;

    public BraveGrpcServerInterceptor(Brave brave) {
        this.serverRequestInterceptor = (ServerRequestInterceptor)Preconditions.checkNotNull((Object)brave.serverRequestInterceptor());
        this.serverResponseInterceptor = (ServerResponseInterceptor)Preconditions.checkNotNull((Object)brave.serverResponseInterceptor());
    }

    public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(final ServerCall<ReqT, RespT> call, final Metadata requestHeaders, ServerCallHandler<ReqT, RespT> next) {
        return next.startCall((ServerCall)new ForwardingServerCall.SimpleForwardingServerCall<ReqT, RespT>(call){

            public void request(int numMessages) {
                BraveGrpcServerInterceptor.this.serverRequestInterceptor.handle(new GrpcServerRequestAdapter(call, requestHeaders));
                super.request(numMessages);
            }

            public void close(Status status, Metadata trailers) {
                BraveGrpcServerInterceptor.this.serverResponseInterceptor.handle((ServerResponseAdapter)new GrpcServerResponseAdapter(status));
                super.close(status, trailers);
            }
        }, requestHeaders);
    }

    static SpanId getSpanId(String traceId, String spanId, String parentSpanId) {
        return SpanId.builder().traceIdHigh(traceId.length() == 32 ? IdConversion.convertToLong((String)traceId, (int)0) : 0L).traceId(IdConversion.convertToLong((String)traceId)).spanId(IdConversion.convertToLong((String)spanId)).parentId(parentSpanId == null ? null : Long.valueOf(IdConversion.convertToLong((String)parentSpanId))).build();
    }

    static final class GrpcServerResponseAdapter
    implements ServerResponseAdapter {
        final Status status;

        public GrpcServerResponseAdapter(Status status) {
            this.status = status;
        }

        public Collection<KeyValueAnnotation> responseAnnotations() {
            Status.Code statusCode = this.status.getCode();
            return statusCode == Status.Code.OK ? Collections.emptyList() : Collections.singletonList(KeyValueAnnotation.create((String)"grpc.status_code", (String)statusCode.name()));
        }
    }

    static final class GrpcServerRequestAdapter<ReqT, RespT>
    implements ServerRequestAdapter {
        private final ServerCall<ReqT, RespT> call;
        private MethodDescriptor<ReqT, RespT> method;
        private Metadata requestHeaders;

        public GrpcServerRequestAdapter(ServerCall<ReqT, RespT> call, Metadata requestHeaders) {
            this.call = (ServerCall)Preconditions.checkNotNull(call);
            this.method = (MethodDescriptor)Preconditions.checkNotNull((Object)call.getMethodDescriptor());
            this.requestHeaders = (Metadata)Preconditions.checkNotNull((Object)requestHeaders);
        }

        public TraceData getTraceData() {
            String sampled = (String)this.requestHeaders.get(BravePropagationKeys.Sampled);
            if (sampled != null) {
                if (sampled.equals("0") || sampled.toLowerCase().equals("false")) {
                    return TraceData.builder().sample(Boolean.valueOf(false)).build();
                }
                String parentSpanId = (String)this.requestHeaders.get(BravePropagationKeys.ParentSpanId);
                String traceId = (String)this.requestHeaders.get(BravePropagationKeys.TraceId);
                String spanId = (String)this.requestHeaders.get(BravePropagationKeys.SpanId);
                if (traceId != null && spanId != null) {
                    SpanId span = BraveGrpcServerInterceptor.getSpanId(traceId, spanId, parentSpanId);
                    return TraceData.builder().sample(Boolean.valueOf(true)).spanId(span).build();
                }
            }
            return TraceData.builder().build();
        }

        public String getSpanName() {
            return this.method.getFullMethodName().toLowerCase();
        }

        public Collection<KeyValueAnnotation> requestAnnotations() {
            SocketAddress socketAddress = (SocketAddress)this.call.attributes().get(ServerCall.REMOTE_ADDR_KEY);
            if (socketAddress != null) {
                KeyValueAnnotation remoteAddrAnnotation = KeyValueAnnotation.create((String)"grpc.remote_addr", (String)socketAddress.toString());
                return Collections.singleton(remoteAddrAnnotation);
            }
            return Collections.emptyList();
        }
    }
}

