/*
 * Decompiled with CFR 0.152.
 */
package com.github.kristofa.brave.grpc;

import com.github.kristofa.brave.Brave;
import com.github.kristofa.brave.ClientRequestAdapter;
import com.github.kristofa.brave.ClientRequestInterceptor;
import com.github.kristofa.brave.ClientResponseAdapter;
import com.github.kristofa.brave.ClientResponseInterceptor;
import com.github.kristofa.brave.ClientSpanThreadBinder;
import com.github.kristofa.brave.IdConversion;
import com.github.kristofa.brave.KeyValueAnnotation;
import com.github.kristofa.brave.SpanId;
import com.github.kristofa.brave.grpc.BravePropagationKeys;
import com.github.kristofa.brave.internal.Nullable;
import com.google.common.base.Preconditions;
import com.twitter.zipkin.gen.Endpoint;
import com.twitter.zipkin.gen.Span;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.ForwardingClientCall;
import io.grpc.ForwardingClientCallListener;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import java.util.Collection;
import java.util.Collections;

public final class BraveGrpcClientInterceptor
implements ClientInterceptor {
    private final ClientRequestInterceptor clientRequestInterceptor;
    private final ClientResponseInterceptor clientResponseInterceptor;
    private final ClientSpanThreadBinder clientSpanThreadBinder;

    public BraveGrpcClientInterceptor(Brave brave) {
        this.clientRequestInterceptor = (ClientRequestInterceptor)Preconditions.checkNotNull((Object)brave.clientRequestInterceptor());
        this.clientResponseInterceptor = (ClientResponseInterceptor)Preconditions.checkNotNull((Object)brave.clientResponseInterceptor());
        this.clientSpanThreadBinder = (ClientSpanThreadBinder)Preconditions.checkNotNull((Object)brave.clientSpanThreadBinder());
    }

    public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(final MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
        return new ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT>(next.newCall(method, callOptions)){

            public void start(ClientCall.Listener<RespT> responseListener, Metadata headers) {
                BraveGrpcClientInterceptor.this.clientRequestInterceptor.handle(new GrpcClientRequestAdapter(method, headers));
                final Span currentClientSpan = BraveGrpcClientInterceptor.this.clientSpanThreadBinder.getCurrentClientSpan();
                super.start((ClientCall.Listener)new ForwardingClientCallListener.SimpleForwardingClientCallListener<RespT>(responseListener){

                    public void onClose(Status status, Metadata trailers) {
                        try {
                            BraveGrpcClientInterceptor.this.clientSpanThreadBinder.setCurrentSpan(currentClientSpan);
                            BraveGrpcClientInterceptor.this.clientResponseInterceptor.handle((ClientResponseAdapter)new GrpcClientResponseAdapter(status));
                            super.onClose(status, trailers);
                        }
                        finally {
                            BraveGrpcClientInterceptor.this.clientSpanThreadBinder.setCurrentSpan(null);
                        }
                    }
                }, headers);
            }
        };
    }

    static final class GrpcClientResponseAdapter
    implements ClientResponseAdapter {
        private final Status status;

        public GrpcClientResponseAdapter(Status status) {
            this.status = (Status)Preconditions.checkNotNull((Object)status);
        }

        public Collection<KeyValueAnnotation> responseAnnotations() {
            Status.Code statusCode = this.status.getCode();
            return statusCode == Status.Code.OK ? Collections.emptyList() : Collections.singletonList(KeyValueAnnotation.create((String)"grpc.status_code", (String)statusCode.name()));
        }
    }

    static final class GrpcClientRequestAdapter<ReqT, RespT>
    implements ClientRequestAdapter {
        private final MethodDescriptor<ReqT, RespT> method;
        private final Metadata headers;

        public GrpcClientRequestAdapter(MethodDescriptor<ReqT, RespT> method, Metadata headers) {
            this.method = (MethodDescriptor)Preconditions.checkNotNull(method);
            this.headers = (Metadata)Preconditions.checkNotNull((Object)headers);
        }

        public String getSpanName() {
            return this.method.getFullMethodName().toLowerCase();
        }

        public void addSpanIdToRequest(@Nullable SpanId spanId) {
            if (spanId == null) {
                this.headers.put(BravePropagationKeys.Sampled, (Object)"0");
            } else {
                this.headers.put(BravePropagationKeys.Sampled, (Object)"1");
                this.headers.put(BravePropagationKeys.TraceId, (Object)spanId.traceIdString());
                this.headers.put(BravePropagationKeys.SpanId, (Object)IdConversion.convertToString((long)spanId.spanId));
                if (spanId.nullableParentId() != null) {
                    this.headers.put(BravePropagationKeys.ParentSpanId, (Object)IdConversion.convertToString((long)spanId.parentId));
                }
            }
        }

        public Collection<KeyValueAnnotation> requestAnnotations() {
            return Collections.emptyList();
        }

        public Endpoint serverAddress() {
            return null;
        }
    }
}

