/*
 * Decompiled with CFR 0.152.
 */
package brave.context.rxjava2;

import brave.propagation.CurrentTraceContext;
import brave.propagation.TraceContext;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.plugins.RxJavaPlugins;

final class TraceContextObserver<T>
implements Observer<T> {
    final Observer<T> downstream;
    final CurrentTraceContext currentTraceContext;
    final TraceContext assemblyContext;
    Disposable upstream;
    boolean done;

    TraceContextObserver(Observer<T> downstream, CurrentTraceContext currentTraceContext, TraceContext assemblyContext) {
        this.downstream = downstream;
        this.currentTraceContext = currentTraceContext;
        this.assemblyContext = assemblyContext;
    }

    public final void onSubscribe(Disposable d) {
        if (DisposableHelper.validate((Disposable)this.upstream, (Disposable)d)) {
            this.upstream = d;
            this.downstream.onSubscribe(this.upstream);
        }
    }

    public void onNext(T t) {
        CurrentTraceContext.Scope scope = this.currentTraceContext.maybeScope(this.assemblyContext);
        try {
            this.downstream.onNext(t);
        }
        finally {
            scope.close();
        }
    }

    public void onError(Throwable t) {
        if (this.done) {
            RxJavaPlugins.onError((Throwable)t);
            return;
        }
        this.done = true;
        CurrentTraceContext.Scope scope = this.currentTraceContext.maybeScope(this.assemblyContext);
        try {
            this.downstream.onError(t);
        }
        finally {
            scope.close();
        }
    }

    public void onComplete() {
        if (this.done) {
            return;
        }
        this.done = true;
        CurrentTraceContext.Scope scope = this.currentTraceContext.maybeScope(this.assemblyContext);
        try {
            this.downstream.onComplete();
        }
        finally {
            scope.close();
        }
    }
}

