/*
 * Decompiled with CFR 0.152.
 */
package brave.context.rxjava2;

import brave.propagation.CurrentTraceContext;
import brave.propagation.TraceContext;
import io.reactivex.internal.fuseable.ConditionalSubscriber;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.plugins.RxJavaPlugins;
import org.reactivestreams.Subscription;

final class TraceContextConditionalSubscriber<T>
implements ConditionalSubscriber<T> {
    final ConditionalSubscriber<T> downstream;
    final CurrentTraceContext currentTraceContext;
    final TraceContext assemblyContext;
    Subscription upstream;
    boolean done;

    TraceContextConditionalSubscriber(ConditionalSubscriber downstream, CurrentTraceContext currentTraceContext, TraceContext assemblyContext) {
        this.downstream = downstream;
        this.currentTraceContext = currentTraceContext;
        this.assemblyContext = assemblyContext;
    }

    public final void onSubscribe(Subscription s) {
        if (SubscriptionHelper.validate((Subscription)this.upstream, (Subscription)s)) {
            this.upstream = s;
            this.downstream.onSubscribe(this.upstream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tryOnNext(T t) {
        CurrentTraceContext.Scope scope = this.currentTraceContext.maybeScope(this.assemblyContext);
        try {
            boolean bl = this.downstream.tryOnNext(t);
            return bl;
        }
        finally {
            scope.close();
        }
    }

    public void onNext(T t) {
        CurrentTraceContext.Scope scope = this.currentTraceContext.maybeScope(this.assemblyContext);
        try {
            this.downstream.onNext(t);
        }
        finally {
            scope.close();
        }
    }

    public void onError(Throwable t) {
        if (this.done) {
            RxJavaPlugins.onError((Throwable)t);
            return;
        }
        this.done = true;
        CurrentTraceContext.Scope scope = this.currentTraceContext.maybeScope(this.assemblyContext);
        try {
            this.downstream.onError(t);
        }
        finally {
            scope.close();
        }
    }

    public void onComplete() {
        if (this.done) {
            return;
        }
        this.done = true;
        CurrentTraceContext.Scope scope = this.currentTraceContext.maybeScope(this.assemblyContext);
        try {
            this.downstream.onComplete();
        }
        finally {
            scope.close();
        }
    }
}

