/*
 * Decompiled with CFR 0.152.
 */
package brave.context.rxjava2.internal;

import brave.context.rxjava2.internal.Util;
import brave.propagation.CurrentTraceContext;
import brave.propagation.TraceContext;
import io.reactivex.SingleObserver;
import io.reactivex.disposables.Disposable;

final class TraceContextSingleObserver<T>
implements SingleObserver<T>,
Disposable {
    final SingleObserver<T> downstream;
    final CurrentTraceContext contextScoper;
    final TraceContext assembled;
    Disposable upstream;

    TraceContextSingleObserver(SingleObserver<T> downstream, CurrentTraceContext contextScoper, TraceContext assembled) {
        this.downstream = downstream;
        this.contextScoper = contextScoper;
        this.assembled = assembled;
    }

    public void onSubscribe(Disposable d) {
        if (!Util.validate(this.upstream, d)) {
            return;
        }
        this.upstream = d;
        this.downstream.onSubscribe((Disposable)this);
    }

    public void onError(Throwable t) {
        CurrentTraceContext.Scope scope = this.contextScoper.maybeScope(this.assembled);
        try {
            this.downstream.onError(t);
        }
        finally {
            scope.close();
        }
    }

    public void onSuccess(T value) {
        CurrentTraceContext.Scope scope = this.contextScoper.maybeScope(this.assembled);
        try {
            this.downstream.onSuccess(value);
        }
        finally {
            scope.close();
        }
    }

    public boolean isDisposed() {
        return this.upstream.isDisposed();
    }

    public void dispose() {
        this.upstream.dispose();
    }
}

