/*
 * Decompiled with CFR 0.152.
 */
package brave.context.rxjava2;

import brave.propagation.CurrentTraceContext;
import brave.propagation.TraceContext;
import io.reactivex.Completable;
import io.reactivex.CompletableObserver;
import io.reactivex.CompletableSource;
import io.reactivex.disposables.Disposable;
import io.reactivex.internal.disposables.DisposableHelper;

final class TraceContextCompletable
extends Completable {
    final CompletableSource source;
    final CurrentTraceContext currentTraceContext;
    final TraceContext assemblyContext;

    TraceContextCompletable(CompletableSource source, CurrentTraceContext currentTraceContext, TraceContext assemblyContext) {
        this.source = source;
        this.currentTraceContext = currentTraceContext;
        this.assemblyContext = assemblyContext;
    }

    protected void subscribeActual(CompletableObserver s) {
        try (CurrentTraceContext.Scope scope = this.currentTraceContext.maybeScope(this.assemblyContext);){
            this.source.subscribe((CompletableObserver)new Observer(s, this.currentTraceContext, this.assemblyContext));
        }
    }

    static final class Observer
    implements CompletableObserver,
    Disposable {
        final CompletableObserver actual;
        final CurrentTraceContext currentTraceContext;
        final TraceContext assemblyContext;
        Disposable d;

        Observer(CompletableObserver actual, CurrentTraceContext currentTraceContext, TraceContext assemblyContext) {
            this.actual = actual;
            this.currentTraceContext = currentTraceContext;
            this.assemblyContext = assemblyContext;
        }

        public void onSubscribe(Disposable d) {
            if (!DisposableHelper.validate((Disposable)this.d, (Disposable)d)) {
                return;
            }
            this.d = d;
            try (CurrentTraceContext.Scope scope = this.currentTraceContext.maybeScope(this.assemblyContext);){
                this.actual.onSubscribe((Disposable)this);
            }
        }

        public void onError(Throwable t) {
            try (CurrentTraceContext.Scope scope = this.currentTraceContext.maybeScope(this.assemblyContext);){
                this.actual.onError(t);
            }
        }

        public void onComplete() {
            try (CurrentTraceContext.Scope scope = this.currentTraceContext.maybeScope(this.assemblyContext);){
                this.actual.onComplete();
            }
        }

        public boolean isDisposed() {
            return this.d.isDisposed();
        }

        public void dispose() {
            this.d.dispose();
        }
    }
}

