/*
 * Decompiled with CFR 0.152.
 */
package brave.context.rxjava2;

import brave.propagation.CurrentTraceContext;
import brave.propagation.TraceContext;
import io.reactivex.Observable;
import io.reactivex.ObservableSource;
import io.reactivex.internal.fuseable.QueueDisposable;
import io.reactivex.internal.observers.BasicFuseableObserver;

final class TraceContextObservable<T>
extends Observable<T> {
    final ObservableSource<T> source;
    final CurrentTraceContext currentTraceContext;
    final TraceContext assemblyContext;

    TraceContextObservable(ObservableSource<T> source, CurrentTraceContext currentTraceContext, TraceContext assemblyContext) {
        this.source = source;
        this.currentTraceContext = currentTraceContext;
        this.assemblyContext = assemblyContext;
    }

    protected void subscribeActual(io.reactivex.Observer<? super T> s) {
        try (CurrentTraceContext.Scope scope = this.currentTraceContext.maybeScope(this.assemblyContext);){
            this.source.subscribe(new Observer<T>(s, this.currentTraceContext, this.assemblyContext));
        }
    }

    static final class Observer<T>
    extends BasicFuseableObserver<T, T> {
        final CurrentTraceContext currentTraceContext;
        final TraceContext assemblyContext;

        Observer(io.reactivex.Observer<T> actual, CurrentTraceContext currentTraceContext, TraceContext assemblyContext) {
            super(actual);
            this.currentTraceContext = currentTraceContext;
            this.assemblyContext = assemblyContext;
        }

        public void onNext(T t) {
            try (CurrentTraceContext.Scope scope = this.currentTraceContext.maybeScope(this.assemblyContext);){
                this.actual.onNext(t);
            }
        }

        public void onError(Throwable t) {
            try (CurrentTraceContext.Scope scope = this.currentTraceContext.maybeScope(this.assemblyContext);){
                this.actual.onError(t);
            }
        }

        public void onComplete() {
            try (CurrentTraceContext.Scope scope = this.currentTraceContext.maybeScope(this.assemblyContext);){
                this.actual.onComplete();
            }
        }

        public int requestFusion(int mode) {
            QueueDisposable qs = this.qs;
            if (qs != null) {
                int m;
                this.sourceMode = m = qs.requestFusion(mode);
                return m;
            }
            return 0;
        }

        public T poll() throws Exception {
            return (T)this.qs.poll();
        }
    }
}

