/*
 * Decompiled with CFR 0.152.
 */
package io.r2mo.vertx.jooq.shared.postgres;

import io.vertx.core.json.Json;
import io.vertx.core.spi.json.JsonCodec;
import org.jooq.Converter;
import org.jooq.JSON;

public class JSONToJsonPojoConverter<U>
implements Converter<JSON, U> {
    private final Class<U> userType;
    private final JsonCodec jsonCodec;

    public JSONToJsonPojoConverter(Class<U> userType, JsonCodec jsonCodec) {
        this.userType = userType;
        this.jsonCodec = jsonCodec;
    }

    public JSONToJsonPojoConverter(Class<U> userType) {
        this(userType, Json.CODEC);
    }

    public U from(JSON t) {
        return (U)(t == null || t.data().equals("null") ? null : this.jsonCodec.fromString(t.data(), this.userType));
    }

    public JSON to(U u) {
        return u == null ? null : JSON.valueOf((String)this.jsonCodec.toString(u));
    }

    public Class<JSON> fromType() {
        return JSON.class;
    }

    public Class<U> toType() {
        return this.userType;
    }
}

