/*
 * Decompiled with CFR 0.152.
 */
package io.r2mo.vertx.jooq.shared.postgres;

import io.vertx.core.json.Json;
import io.vertx.core.spi.json.JsonCodec;
import org.jooq.Converter;
import org.jooq.JSONB;

public class JSONBToJsonPojoConverter<U>
implements Converter<JSONB, U> {
    private final Class<U> userType;
    private final JsonCodec jsonCodec;

    public JSONBToJsonPojoConverter(Class<U> userType, JsonCodec jsonCodec) {
        this.userType = userType;
        this.jsonCodec = jsonCodec;
    }

    public JSONBToJsonPojoConverter(Class<U> userType) {
        this(userType, Json.CODEC);
    }

    public U from(JSONB t) {
        return (U)(t == null || t.data().equals("null") ? null : this.jsonCodec.fromString(t.data(), this.userType));
    }

    public JSONB to(U u) {
        return u == null ? null : JSONB.valueOf((String)this.jsonCodec.toString(u));
    }

    public Class<JSONB> fromType() {
        return JSONB.class;
    }

    public Class<U> toType() {
        return this.userType;
    }
}

