/*
 * Decompiled with CFR 0.152.
 */
package io.r2mo.vertx.jooq.shared.internal.jdbc;

import io.r2mo.vertx.jooq.shared.internal.AbstractQueryResult;
import io.r2mo.vertx.jooq.shared.internal.QueryResult;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.jooq.Field;
import org.jooq.Record;
import org.jooq.Result;

public class JDBCQueryResult
extends AbstractQueryResult {
    private final Result<? extends Record> result;
    private final int index;

    public JDBCQueryResult(Result<? extends Record> result) {
        this(result, 0);
    }

    private JDBCQueryResult(Result<? extends Record> result, int index) {
        this.result = result;
        this.index = index;
    }

    @Override
    public <T> T get(Field<T> field) {
        return (T)this.supplyOrThrow(() -> this.result.getValue(this.index, field));
    }

    @Override
    public <T> T get(int index, Class<T> type) {
        return (T)this.supplyOrThrow(() -> this.result.getValue(this.index, index));
    }

    @Override
    public <T> T get(String columnName, Class<T> type) {
        return (T)this.supplyOrThrow(() -> this.result.getValue(this.index, columnName));
    }

    @Override
    public <T> T unwrap() {
        return (T)this.result;
    }

    @Override
    public boolean hasResults() {
        return this.result.size() > 0;
    }

    @Override
    public Stream<QueryResult> stream() {
        return IntStream.range(this.index, this.result.size()).mapToObj(i -> new JDBCQueryResult(this.result, i));
    }
}

