/*
 * Decompiled with CFR 0.152.
 */
package io.r2mo.vertx.jooq.shared.internal;

import io.r2mo.vertx.jooq.shared.internal.GenericVertxDAO;
import io.r2mo.vertx.jooq.shared.internal.QueryExecutor;
import io.vertx.core.impl.Arguments;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.jooq.Condition;
import org.jooq.Configuration;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.InsertReturningStep;
import org.jooq.InsertSetMoreStep;
import org.jooq.InsertSetStep;
import org.jooq.OrderField;
import org.jooq.Record;
import org.jooq.Record1;
import org.jooq.SelectConditionStep;
import org.jooq.SelectField;
import org.jooq.Table;
import org.jooq.TableField;
import org.jooq.True;
import org.jooq.UniqueKey;
import org.jooq.UpdatableRecord;
import org.jooq.impl.DSL;

public abstract class AbstractVertxDAO<R extends UpdatableRecord<R>, P, T, FIND_MANY, FIND_ONE, EXECUTE, INSERT_RETURNING>
implements GenericVertxDAO<R, P, T, FIND_MANY, FIND_ONE, EXECUTE, INSERT_RETURNING> {
    private final Class<P> type;
    private final Table<R> table;
    private final QueryExecutor<R, T, FIND_MANY, FIND_ONE, EXECUTE, INSERT_RETURNING> queryExecutor;

    protected AbstractVertxDAO(Table<R> table, Class<P> type, QueryExecutor<R, T, FIND_MANY, FIND_ONE, EXECUTE, INSERT_RETURNING> queryExecutor) {
        this.type = type;
        this.table = table;
        this.queryExecutor = queryExecutor;
    }

    public Class<P> getType() {
        return this.type;
    }

    public Table<R> getTable() {
        return this.table;
    }

    @Override
    public QueryExecutor<R, T, FIND_MANY, FIND_ONE, EXECUTE, INSERT_RETURNING> queryExecutor() {
        return this.queryExecutor;
    }

    @Override
    public EXECUTE update(P object) {
        Objects.requireNonNull(object);
        return this.queryExecutor().execute(dslContext -> {
            UpdatableRecord rec = (UpdatableRecord)dslContext.newRecord(this.getTable(), object);
            True where = DSL.trueCondition();
            UniqueKey pk = this.getTable().getPrimaryKey();
            for (TableField tableField : pk.getFields()) {
                rec.changed((Field)tableField, false);
                where = where.and(tableField.eq(rec.get((Field)tableField)));
            }
            Map valuesToUpdate = Arrays.stream(rec.fields()).collect(HashMap::new, (m, f) -> m.put(f.getName(), f.getValue((Record)rec)), HashMap::putAll);
            return dslContext.update(this.getTable()).set(valuesToUpdate).where((Condition)where);
        });
    }

    private Function<DSLContext, SelectConditionStep<R>> selectQuery(Condition condition) {
        return dslContext -> dslContext.selectFrom(this.getTable()).where(condition);
    }

    @Override
    public FIND_MANY findManyByCondition(Condition condition) {
        return this.queryExecutor().findMany(this.selectQuery(condition));
    }

    @Override
    public FIND_MANY findManyByCondition(Condition condition, int limit) {
        return this.queryExecutor().findMany(this.selectQuery(condition).andThen(sel -> sel.limit((Number)limit)));
    }

    @Override
    public FIND_MANY findManyByCondition(Condition condition, OrderField<?> ... orderField) {
        return this.queryExecutor().findMany(this.selectQuery(condition).andThen(sel -> sel.orderBy(orderField)));
    }

    @Override
    public FIND_MANY findManyByCondition(Condition condition, int limit, OrderField<?> ... orderField) {
        return this.queryExecutor().findMany(this.selectQuery(condition).andThen(sel -> sel.orderBy(orderField).limit((Number)limit)));
    }

    @Override
    public FIND_MANY findManyByCondition(Condition condition, int limit, int offset, OrderField<?> ... orderFields) {
        return this.queryExecutor().findMany(this.selectQuery(condition).andThen(sel -> sel.orderBy(orderFields).limit((Number)offset, (Number)limit)));
    }

    @Override
    public FIND_MANY findManyByIds(Collection<T> ids) {
        return this.findManyByCondition(this.equalKeys(ids));
    }

    @Override
    public FIND_MANY findAll() {
        return this.findManyByCondition((Condition)DSL.trueCondition());
    }

    @Override
    public FIND_ONE findOneById(T id) {
        return this.findOneByCondition(this.equalKey(id));
    }

    @Override
    public FIND_ONE findOneByCondition(Condition condition) {
        return this.queryExecutor().findOne(dslContext -> dslContext.selectFrom(this.getTable()).where(condition));
    }

    @Override
    public EXECUTE deleteByCondition(Condition condition) {
        return this.queryExecutor().execute(dslContext -> dslContext.deleteFrom(this.getTable()).where(condition));
    }

    @Override
    public EXECUTE deleteById(T id) {
        return this.deleteByCondition(this.equalKey(id));
    }

    @Override
    public EXECUTE deleteByIds(Collection<T> ids) {
        return this.deleteByCondition(this.equalKeys(ids));
    }

    @Override
    public EXECUTE insert(P pojo) {
        return this.insert(pojo, false);
    }

    @Override
    public EXECUTE insert(P pojo, boolean onDuplicateKeyIgnore) {
        Objects.requireNonNull(pojo);
        return this.queryExecutor().execute(dslContext -> {
            InsertSetMoreStep insertStep = dslContext.insertInto(this.getTable()).set(this.newRecord((DSLContext)dslContext, pojo));
            return onDuplicateKeyIgnore ? insertStep.onDuplicateKeyIgnore() : insertStep;
        });
    }

    @Override
    public EXECUTE insert(Collection<P> pojos) {
        return this.insert(pojos, false);
    }

    @Override
    public EXECUTE insert(Collection<P> pojos, boolean onDuplicateKeyIgnore) {
        Arguments.require((!pojos.isEmpty() ? 1 : 0) != 0, (String)"No elements");
        return this.queryExecutor().execute(dslContext -> {
            InsertSetStep insertSetStep = dslContext.insertInto(this.getTable());
            InsertReturningStep insertValuesStepN = null;
            for (Object pojo : pojos) {
                insertValuesStepN = insertSetStep.values(this.newRecord((DSLContext)dslContext, (P)pojo).intoArray());
            }
            return onDuplicateKeyIgnore ? insertValuesStepN.onDuplicateKeyIgnore() : insertValuesStepN;
        });
    }

    @Override
    public INSERT_RETURNING insertReturningPrimary(P object) {
        UniqueKey key = this.getTable().getPrimaryKey();
        Objects.requireNonNull(key, () -> "No primary key");
        return this.queryExecutor().insertReturning(dslContext -> dslContext.insertInto(this.getTable()).set(this.newRecord((DSLContext)dslContext, object)).returning((Collection)key.getFields()), this.keyConverter());
    }

    protected Function<Object, T> keyConverter() {
        return record -> {
            Objects.requireNonNull(record, () -> "Failed inserting record or no key");
            Record key1 = ((UpdatableRecord)record).key();
            if (key1.size() == 1) {
                return ((Record1)key1).value1();
            }
            return key1;
        };
    }

    protected Condition equalKey(T id) {
        UniqueKey uk = this.getTable().getPrimaryKey();
        Objects.requireNonNull(uk, () -> "No primary key");
        TableField[] pk = uk.getFieldsArray();
        Condition condition = pk.length == 1 ? pk[0].equal(pk[0].getDataType().convert(id)) : DSL.row((SelectField[])pk).equal((Record)id);
        return condition;
    }

    protected Condition equalKeys(Collection<T> ids) {
        UniqueKey uk = this.getTable().getPrimaryKey();
        Objects.requireNonNull(uk, () -> "No primary key");
        TableField[] pk = uk.getFieldsArray();
        Condition condition = pk.length == 1 ? (ids.size() == 1 ? this.equalKey(ids.iterator().next()) : pk[0].in((Collection)pk[0].getDataType().convert(ids))) : DSL.row((SelectField[])pk).in(ids.toArray(new Record[ids.size()]));
        return condition;
    }

    protected T compositeKeyRecord(Object ... values) {
        UniqueKey key = this.table.getPrimaryKey();
        if (key == null) {
            return null;
        }
        TableField[] fields = key.getFieldsArray();
        Record result = DSL.using((Configuration)this.queryExecutor.configuration()).newRecord((Field[])fields);
        for (int i = 0; i < values.length; ++i) {
            result.set((Field)fields[i], fields[i].getDataType().convert(values[i]));
        }
        return (T)result;
    }

    protected Record newRecord(DSLContext dslContext, P pojo) {
        return this.setDefault(dslContext.newRecord(this.getTable(), pojo));
    }

    private Record setDefault(Record record) {
        int size = record.size();
        for (int i = 0; i < size; ++i) {
            Field field;
            if (record.get(i) != null || (field = record.field(i)).getDataType().nullable() || field.getDataType().identity()) continue;
            record.set(field, (Object)DSL.defaultValue());
        }
        return record;
    }

    protected abstract T getId(P var1);
}

