/*
 * Decompiled with CFR 0.152.
 */
package io.r2mo.vertx.jooq.shared;

import io.vertx.core.json.JsonObject;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Objects;
import org.jooq.Binding;
import org.jooq.BindingGetResultSetContext;
import org.jooq.BindingGetSQLInputContext;
import org.jooq.BindingGetStatementContext;
import org.jooq.BindingRegisterContext;
import org.jooq.BindingSQLContext;
import org.jooq.BindingSetSQLOutputContext;
import org.jooq.BindingSetStatementContext;
import org.jooq.Converter;
import org.jooq.Field;
import org.jooq.RenderContext;
import org.jooq.SQLDialect;
import org.jooq.impl.DSL;

public class ObjectToJsonObjectBinding
implements Binding<Object, JsonObject> {
    private static final Converter<Object, JsonObject> CONVERTER = new Converter<Object, JsonObject>(){

        public JsonObject from(Object t) {
            return t == null ? null : new JsonObject(t.toString());
        }

        public Object to(JsonObject u) {
            return u == null ? null : u.encode();
        }

        public Class<Object> fromType() {
            return Object.class;
        }

        public Class<JsonObject> toType() {
            return JsonObject.class;
        }
    };

    public Converter<Object, JsonObject> converter() {
        return CONVERTER;
    }

    public void sql(BindingSQLContext<JsonObject> ctx) {
        RenderContext context = (RenderContext)ctx.render().visit((Field)DSL.val((Object)ctx.convert(this.converter()).value()));
        if (SQLDialect.POSTGRES.equals((Object)ctx.configuration().dialect().family())) {
            context.sql("::json");
        }
    }

    public void register(BindingRegisterContext<JsonObject> ctx) throws SQLException {
        ctx.statement().registerOutParameter(ctx.index(), 12);
    }

    public void set(BindingSetStatementContext<JsonObject> ctx) throws SQLException {
        ctx.statement().setString(ctx.index(), Objects.toString(ctx.convert(this.converter()).value(), null));
    }

    public void get(BindingGetResultSetContext<JsonObject> ctx) throws SQLException {
        ctx.convert(this.converter()).value((Object)ctx.resultSet().getString(ctx.index()));
    }

    public void get(BindingGetStatementContext<JsonObject> ctx) throws SQLException {
        ctx.convert(this.converter()).value((Object)ctx.statement().getString(ctx.index()));
    }

    public void set(BindingSetSQLOutputContext<JsonObject> ctx) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    public void get(BindingGetSQLInputContext<JsonObject> ctx) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }
}

