/*
 * Decompiled with CFR 0.152.
 */
package io.r2mo.vertx.jooq.shared;

import java.util.EnumMap;
import java.util.function.Function;
import org.jooq.impl.AbstractConverter;
import org.jooq.tools.Convert;
import org.jooq.tools.JooqLogger;

public abstract class EnumToEnumConverter<T extends Enum<T>, U extends Enum<U>>
extends AbstractConverter<T, U> {
    private static final JooqLogger logger = JooqLogger.getLogger(EnumToEnumConverter.class);
    private final Function<U, String> nameRepresentationLookup;
    private final EnumMap<T, U> lookup;

    public EnumToEnumConverter(Class<T> fromType, Class<U> toType) {
        this(fromType, toType, Enum::name);
    }

    public EnumToEnumConverter(Class<T> fromType, Class<U> toType, Function<U, String> nameRepresentationLookup) {
        super(fromType, toType);
        this.nameRepresentationLookup = nameRepresentationLookup;
        this.lookup = new EnumMap(fromType);
        for (Enum u : (Enum[])toType.getEnumConstants()) {
            T to = this.to((U)u);
            if (to == null) {
                logger.warn((Object)String.format("No mapping found for type %s and name %s", toType.getName(), u.name()));
                continue;
            }
            this.lookup.put(to, (U)u);
        }
    }

    public U from(T databaseObject) {
        return (U)((Enum)this.lookup.get(databaseObject));
    }

    public T to(U userObject) {
        if (userObject == null) {
            return null;
        }
        return (T)((Enum)Convert.convert((Object)this.nameRepresentationLookup.apply(userObject), (Class)this.fromType()));
    }
}

