/*
 * Decompiled with CFR 0.152.
 */
package io.r2mo.typed.hutool.spi;

import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONObject;
import io.r2mo.function.Fn;
import io.r2mo.spi.SPI;
import io.r2mo.typed.hutool.spi.JUtilImpl;
import io.r2mo.typed.json.JArray;
import io.r2mo.typed.json.JBase;
import io.r2mo.typed.json.JObject;
import io.r2mo.typed.json.JUtil;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;

class JObjectImpl
implements JObject {
    private final JSONObject data;

    JObjectImpl() {
        this.data = new JSONObject();
    }

    JObjectImpl(JSONObject data) {
        this.data = data;
    }

    JObjectImpl(String jsonStr) {
        this.data = new JSONObject((Object)jsonStr);
    }

    public int getInt(String key, int defaultValue) {
        return this.data.getInt((Object)key, Integer.valueOf(defaultValue));
    }

    public long getLong(String key, long defaultValue) {
        return this.data.getLong((Object)key, Long.valueOf(defaultValue));
    }

    public boolean getBool(String key, boolean defaultValue) {
        return this.data.getBool((Object)key, Boolean.valueOf(defaultValue));
    }

    public String getString(String key, String defaultValue) {
        return this.data.getStr((Object)key, defaultValue);
    }

    public Object get(String key) {
        Object value = this.data.get((Object)key);
        if (value instanceof JSONObject || value instanceof JSONArray) {
            return JUtilImpl.boxIn(value);
        }
        return this.data.getObj((Object)key);
    }

    public JObject getJObject(String key) {
        return (JObject)this.getJson(key);
    }

    private <T extends JBase> T getJson(String key) {
        Object value = this.get(key);
        if (Objects.isNull(value)) {
            return null;
        }
        return JUtilImpl.boxIn(value);
    }

    public JArray getJArray(String key) {
        return (JArray)this.getJson(key);
    }

    public JObject put(String key, Object value) {
        Objects.requireNonNull(key, "[ R2MO ] JSON \u952e\u4e0d\u80fd\u4e3a\u7a7a");
        this.data.set(key, JUtilImpl.boxOut(value));
        return this;
    }

    public JObject remove(String ... keys) {
        Arrays.stream(keys).forEach(arg_0 -> ((JSONObject)this.data).remove(arg_0));
        return this;
    }

    public boolean containsKey(String key) {
        return this.data.containsKey((Object)key);
    }

    public Set<String> fieldNames() {
        return this.data.keySet();
    }

    public boolean isNested() {
        return this.data.values().stream().anyMatch(arg_0 -> ((JUtil)SPI.V_UTIL).isJObject(arg_0));
    }

    public Map<String, Object> toMap() {
        return new HashMap<String, Object>((Map<String, Object>)this.data);
    }

    public Stream<Map.Entry<String, Object>> itKv() {
        return this.data.entrySet().stream();
    }

    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    public String encode() {
        return this.data.toString();
    }

    public String encodePretty() {
        return this.data.toStringPretty();
    }

    public String encodeYaml() {
        return SPI.V_UTIL.toYaml((JBase)this);
    }

    public JSONObject data() {
        return this.data;
    }

    public JObject subset(String ... fields) {
        JObjectImpl subset = new JObjectImpl();
        Arrays.stream(fields).filter(this::containsKey).forEach(field -> subset.put((String)field, this.get((String)field)));
        return subset;
    }

    public String toString() {
        return this.encode();
    }

    public JObject copy() {
        return new JObjectImpl((JSONObject)Fn.jvmOr(() -> ((JSONObject)this.data).clone()));
    }
}

