/*
 * Decompiled with CFR 0.152.
 */
package io.r2mo.typed.hutool.spi;

import cn.hutool.json.JSONArray;
import io.r2mo.function.Fn;
import io.r2mo.spi.SPI;
import io.r2mo.typed.hutool.spi.JUtilImpl;
import io.r2mo.typed.json.JArray;
import io.r2mo.typed.json.JBase;
import io.r2mo.typed.json.JObject;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;

class JArrayImpl
implements JArray {
    private final JSONArray data;

    JArrayImpl(JSONArray jsonArray) {
        this.data = jsonArray;
    }

    JArrayImpl(String jsonStr) {
        this.data = new JSONArray((Object)jsonStr);
    }

    JArrayImpl() {
        this.data = new JSONArray();
    }

    public Stream<String> itString() {
        return this.data.stream().filter(item -> item instanceof String).map(item -> (String)item);
    }

    public Stream<JObject> itObject() {
        return this.data.stream().map(JUtilImpl::boxIn).filter(item -> item instanceof JObject).map(item -> (JObject)item);
    }

    public <T> JArray addAll(Collection<T> values) {
        this.data.addAll(values);
        return this;
    }

    public <T> JArray add(T value) {
        this.data.add(JUtilImpl.boxOut(value));
        return this;
    }

    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    public String encode() {
        return this.data.toString();
    }

    public String encodePretty() {
        return this.data.toStringPretty();
    }

    public String encodeYaml() {
        return SPI.V_UTIL.toYaml((JBase)this);
    }

    public JSONArray data() {
        return this.data;
    }

    public List toList() {
        return this.data.stream().toList();
    }

    public String toString() {
        return this.encode();
    }

    public JObject findOne(String field, Object value) {
        return this.findInternal(field, value).findAny().orElse(null);
    }

    public JArray findMany(String field, Object value) {
        JArrayImpl foundList = new JArrayImpl();
        this.findInternal(field, value).forEach(arg_0 -> ((JArray)foundList).add(arg_0));
        return foundList;
    }

    private Stream<JObject> findInternal(String field, Object value) {
        return this.itObject().filter(item -> value.equals(item.get(field)));
    }

    public JArray subset(String ... fields) {
        JArrayImpl subset = new JArrayImpl();
        this.itObject().map(rec$ -> ((JBase)rec$).subset(new String[0])).forEach(arg_0 -> ((JArray)subset).add(arg_0));
        return subset;
    }

    public JArray copy() {
        return new JArrayImpl((JSONArray)Fn.jvmOr(() -> ((JSONArray)this.data).clone()));
    }
}

