/*
 * Decompiled with CFR 0.152.
 */
package io.r2mo.typed.hutool.spi;

import cn.hutool.json.JSONObject;
import io.r2mo.spi.SPI;
import io.r2mo.typed.hutool.spi.JUtilImpl;
import io.r2mo.typed.json.JArray;
import io.r2mo.typed.json.JBase;
import io.r2mo.typed.json.JObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;

class JObjectImpl
implements JObject {
    private final JSONObject data;

    JObjectImpl() {
        this.data = new JSONObject();
    }

    JObjectImpl(JSONObject data) {
        this.data = data;
    }

    JObjectImpl(String jsonStr) {
        this.data = new JSONObject((Object)jsonStr);
    }

    public int getInt(String key, int defaultValue) {
        return this.data.getInt((Object)key, Integer.valueOf(defaultValue));
    }

    public boolean getBool(String key, boolean defaultValue) {
        return this.data.getBool((Object)key, Boolean.valueOf(defaultValue));
    }

    public String getString(String key, String defaultValue) {
        return this.data.getStr((Object)key, defaultValue);
    }

    public Object get(String key) {
        return this.data.getObj((Object)key);
    }

    public JObject getJObject(String key) {
        return (JObject)this.getJson(key);
    }

    private <T extends JBase> T getJson(String key) {
        Object value = this.get(key);
        if (Objects.isNull(value)) {
            return null;
        }
        return JUtilImpl.boxIn(value);
    }

    public JArray getJArray(String key) {
        return (JArray)this.getJson(key);
    }

    public JObject put(String key, Object value) {
        this.data.set(key, JUtilImpl.boxOut(value));
        return this;
    }

    public JObject put(Map<String, Object> map) {
        map.forEach(this::put);
        return this;
    }

    public boolean containsKey(String key) {
        return this.data.containsKey((Object)key);
    }

    public Map<String, Object> toMap() {
        return new HashMap<String, Object>((Map<String, Object>)this.data);
    }

    public Stream<Map.Entry<String, Object>> itKv() {
        return this.data.entrySet().stream();
    }

    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    public String encode() {
        return this.data.toString();
    }

    public String encodePretty() {
        return this.data.toStringPretty();
    }

    public String encodeYaml() {
        return SPI.V_UTIL.toYaml((JBase)this);
    }

    public JSONObject data() {
        return this.data;
    }
}

